/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.mixin.AbstractArrowMixin;
import elucent.eidolon.mixin.ProjectileMixin;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.util.EntityUtil;
import elucent.eidolon.util.RegistryUtil;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AngelArrowEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    public AbstractArrow internal = null;
    public Predicate<Entity> mode = target -> true;

    public AngelArrowEntity(EntityType<? extends AbstractArrow> type, Level worldIn) {
        super(type, worldIn);
    }

    public AngelArrowEntity(Level worldIn, LivingEntity shooter) {
        super((EntityType)EidolonEntities.ANGEL_ARROW.get(), shooter, worldIn);
    }

    public void setArrow(AbstractArrow entity) {
        this.internal = entity;
        this.internal.m_20359_((Entity)this);
    }

    public static float lerpDegrees(float a, float b, float t) {
        float d3;
        float d1 = Math.abs(b - a);
        float d2 = Math.abs(b - 360.0f - a);
        if (d2 > (d3 = Math.abs(b + 360.0f - a)) && d2 > d1) {
            b -= 360.0f;
            d1 = d2;
        }
        if (d3 > d2 && d3 > d1) {
            b += 360.0f;
            d1 = d3;
        }
        return a + d1 * t;
    }

    public void m_8119_() {
        if (this.internal == null) {
            this.m_6089_();
            return;
        }
        super.m_8119_();
        this.internal.m_8119_();
        this.internal.f_19854_ = this.f_19854_;
        this.internal.f_19855_ = this.f_19855_;
        this.internal.f_19856_ = this.f_19856_;
        this.internal.f_19860_ = this.f_19860_;
        this.internal.f_19859_ = this.f_19859_;
        this.internal.m_20359_((Entity)this);
        this.internal.m_20256_(this.m_20184_());
        if (!this.f_36703_) {
            EntityUtil.moveTowardsTarget((Entity)this);
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.internal == null ? ItemStack.f_41583_ : ((AbstractArrowMixin)this.internal).callGetPickupItem();
    }

    public void m_5790_(@NotNull EntityHitResult result) {
        ((ProjectileMixin)this.internal).callOnHit((HitResult)result);
        if (this.internal.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("type", RegistryUtil.getRegistryName(this.internal.m_6095_()).toString());
        nbt.m_128365_("data", (Tag)this.internal.serializeNBT());
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        ResourceLocation rl = new ResourceLocation(nbt.m_128461_("type"));
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl);
        if (type == null) {
            this.m_6089_();
        }
        this.internal = (AbstractArrow)type.m_20615_(this.f_19853_);
        this.internal.deserializeNBT(nbt.m_128469_("data"));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag extra = new CompoundTag();
        extra.m_128359_("type", RegistryUtil.getRegistryName(this.internal.m_6095_()).toString());
        extra.m_128365_("data", (Tag)this.internal.serializeNBT());
        buffer.m_130079_(extra);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag extra = additionalData.m_130260_();
        ResourceLocation rl = new ResourceLocation(extra.m_128461_("type"));
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl);
        if (type == null) {
            this.m_6089_();
        }
        this.internal = (AbstractArrow)type.m_20615_(this.f_19853_);
        this.internal.deserializeNBT(extra.m_128469_("data"));
    }
}

