/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.SoulUpdatePacket;
import elucent.eidolon.registries.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class SoulboneAmuletItem
extends ItemBase
implements ICurioItem {
    public SoulboneAmuletItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(SoulboneAmuletItem::onKill);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            if (CuriosApi.getCuriosHelper().findFirstCurio(e, (Item)Registry.SOULBONE_AMULET.get()).isPresent()) {
                e.getCapability(ISoul.INSTANCE).ifPresent(cap -> {
                    cap.setMaxEtherealHealth(Math.max(Math.min(ISoul.getPersistentHealth(e), cap.getMaxEtherealHealth()), (float)(2 * (int)Math.floor((cap.getEtherealHealth() + 3.0f) / 2.0f))));
                    cap.setEtherealHealth(cap.getEtherealHealth() + 2.0f);
                    if (!e.f_19853_.f_46443_) {
                        Networking.sendToTracking(e.f_19853_, e.m_20097_(), new SoulUpdatePacket(e));
                    }
                });
            }
        }
    }
}

