/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.DamageTypeData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DarkTouchSpell
extends StaticSpell {
    public static final String NECROTIC_KEY = new ResourceLocation("eidolon", "necrotic").toString();

    public DarkTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, 20, signs);
        MinecraftForge.EVENT_BUS.addListener(DarkTouchSpell::onHurt);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            CompoundTag tag;
            LivingEntity living = (LivingEntity)entity;
            if (!event.getSource().m_276093_(DamageTypes.f_268493_) && (tag = living.m_21205_().m_41783_()) != null && tag.m_128441_(NECROTIC_KEY)) {
                float amount = Math.min(1.0f, event.getAmount());
                event.setAmount(event.getAmount() - amount);
                if (event.getAmount() <= 0.0f) {
                    event.setCanceled(true);
                }
                int prevHurtResist = event.getEntity().f_19802_;
                event.getEntity().f_19802_ = 0;
                if (event.getEntity().m_6469_(DamageTypeData.source((LevelAccessor)living.f_19853_, (ResourceKey<DamageType>)DamageTypes.f_268493_, (Entity)living, null), amount)) {
                    tag.m_128405_(NECROTIC_KEY, -1);
                    if (tag.m_128451_(NECROTIC_KEY) <= 0) {
                        tag.m_128473_(NECROTIC_KEY);
                    }
                    if (living.m_21223_() <= 0.0f) {
                        event.setCanceled(true);
                    } else {
                        living.f_19802_ = prevHurtResist;
                    }
                }
            }
        }
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        if (!world.getCapability(IReputation.INSTANCE).isPresent()) {
            return false;
        }
        if (((IReputation)world.getCapability(IReputation.INSTANCE).resolve().get()).getReputation(player, Deities.DARK_DEITY.getId()) < 4.0) {
            return false;
        }
        Vec3 v = DarkTouchSpell.getVector(world, player);
        List items = world.m_45976_(ItemEntity.class, new AABB(v.f_82479_ - 1.5, v.f_82480_ - 1.5, v.f_82481_ - 1.5, v.f_82479_ + 1.5, v.f_82480_ + 1.5, v.f_82481_ + 1.5));
        if (items.size() != 1) {
            return false;
        }
        ItemStack stack = ((ItemEntity)items.get(0)).m_32055_();
        return stack.m_41613_() == 1 && this.canTouch(stack);
    }

    boolean canTouch(ItemStack stack) {
        return stack.m_41720_() == Registry.PEWTER_INLAY.get() || stack.m_41720_() == Items.f_41938_ || stack.m_41720_() instanceof RecordItem && stack.m_41720_() != Registry.PAROUSIA_DISC.get() || stack.m_41763_() && stack.m_41741_() == 1;
    }

    protected ItemStack touchResult(ItemStack stack, Player player) {
        if (stack.m_41720_() == Registry.PEWTER_INLAY.get()) {
            return new ItemStack((ItemLike)Registry.UNHOLY_SYMBOL.get());
        }
        if (stack.m_41720_() == Items.f_41938_) {
            return new ItemStack((ItemLike)Registry.TOP_HAT.get());
        }
        if (stack.m_41720_() instanceof RecordItem && stack.m_41720_() != Registry.PAROUSIA_DISC.get()) {
            return new ItemStack((ItemLike)Registry.PAROUSIA_DISC.get());
        }
        ISoul.expendMana(player, this.getCost());
        stack.m_41784_().m_128405_(NECROTIC_KEY, 50);
        return stack;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        Vec3 v = DarkTouchSpell.getVector(world, player);
        List items = world.m_45976_(ItemEntity.class, new AABB(v.f_82479_ - 1.5, v.f_82480_ - 1.5, v.f_82481_ - 1.5, v.f_82479_ + 1.5, v.f_82480_ + 1.5, v.f_82481_ + 1.5));
        if (items.size() == 1) {
            if (!world.f_46443_) {
                ItemStack stack = ((ItemEntity)items.get(0)).m_32055_();
                if (this.canTouch(stack)) {
                    ((ItemEntity)items.get(0)).m_32045_(this.touchResult(stack, player));
                    Vec3 p = ((ItemEntity)items.get(0)).m_20182_();
                    ((ItemEntity)items.get(0)).m_32060_();
                    Networking.sendToTracking(world, ((ItemEntity)items.get(0)).m_20183_(), new MagicBurstEffectPacket(p.f_82479_, p.f_82480_, p.f_82481_, Signs.WICKED_SIGN.getColor(), Signs.BLOOD_SIGN.getColor()));
                }
            } else {
                world.m_5594_(player, player.m_20183_(), SoundEvents.f_11887_, SoundSource.NEUTRAL, 1.0f, 0.6f + world.f_46441_.m_188501_() * 0.2f);
            }
        }
    }
}

