/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.spell.DarkTouchSpell;
import elucent.eidolon.registries.Registry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LightTouchSpell
extends DarkTouchSpell {
    public static final String SACRED_KEY = new ResourceLocation("eidolon", "sacred").toString();

    public LightTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, signs);
        MinecraftForge.EVENT_BUS.addListener(LightTouchSpell::onHurt);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            CompoundTag tag;
            Mob mob;
            LivingEntity caster = (LivingEntity)entity;
            entity = event.getEntity();
            if (entity instanceof Mob && (mob = (Mob)entity).m_6336_() == MobType.f_21641_ && (tag = caster.m_21205_().m_41783_()) != null && tag.m_128441_(SACRED_KEY)) {
                event.setAmount(event.getAmount() * 1.5f);
                tag.m_128405_(SACRED_KEY, tag.m_128451_(SACRED_KEY) - 1);
                if (tag.m_128451_(SACRED_KEY) <= 0) {
                    tag.m_128473_(SACRED_KEY);
                }
            }
        }
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        if (!world.getCapability(IReputation.INSTANCE).isPresent()) {
            return false;
        }
        if (((IReputation)world.getCapability(IReputation.INSTANCE).resolve().get()).getReputation(player, Deities.LIGHT_DEITY.getId()) < 4.0) {
            return false;
        }
        Vec3 v = LightTouchSpell.getVector(world, player);
        List items = world.m_45976_(ItemEntity.class, new AABB(v.f_82479_ - 1.5, v.f_82480_ - 1.5, v.f_82481_ - 1.5, v.f_82479_ + 1.5, v.f_82480_ + 1.5, v.f_82481_ + 1.5));
        if (items.size() != 1) {
            return false;
        }
        ItemStack stack = ((ItemEntity)items.get(0)).m_32055_();
        return stack.m_41613_() == 1 && this.canTouch(stack);
    }

    @Override
    boolean canTouch(ItemStack stack) {
        return stack.m_41720_() == Registry.GOLD_INLAY.get() || stack.m_41720_() == Items.f_41938_ || stack.m_41720_() instanceof RecordItem && stack.m_41720_() != Registry.PAROUSIA_DISC.get() || stack.m_41763_() && stack.m_41741_() == 1;
    }

    @Override
    protected ItemStack touchResult(ItemStack stack, Player player) {
        if (stack.m_41720_() == Registry.GOLD_INLAY.get()) {
            return new ItemStack((ItemLike)Registry.HOLY_SYMBOL.get());
        }
        if (stack.m_41720_() == Items.f_41938_) {
            return new ItemStack((ItemLike)Registry.TOP_HAT.get());
        }
        if (stack.m_41720_() instanceof RecordItem && stack.m_41720_() != Registry.PAROUSIA_DISC.get()) {
            return new ItemStack((ItemLike)Registry.PAROUSIA_DISC.get());
        }
        ISoul.expendMana(player, this.getCost());
        stack.m_41784_().m_128405_(SACRED_KEY, 50);
        return stack;
    }
}

