/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.altar.AltarInfo;
import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.block.HorizontalBlockBase;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.common.tile.EffigyTileEntity;
import elucent.eidolon.common.tile.GobletTileEntity;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.SoulUpdatePacket;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.util.RGBProvider;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;

public class PrayerSpell
extends StaticSpell {
    final Deity deity;

    public PrayerSpell(ResourceLocation name, Deity deity, Sign ... signs) {
        super(name, signs);
        this.deity = deity;
    }

    public PrayerSpell(ResourceLocation name, Deity deity, int cost, Sign ... signs) {
        super(name, cost, signs);
        this.deity = deity;
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        if (this.reputationCheck(world, player, 0.0)) {
            return false;
        }
        EffigyTileEntity effigy = PrayerSpell.getEffigy(world, pos);
        return effigy != null && effigy.ready();
    }

    public static void updateMagic(AltarInfo altarInfo, Player player, Level world, double reputation) {
        player.getCapability(ISoul.INSTANCE).ifPresent(soul -> {
            double capacity = altarInfo.getCapacity();
            double power = altarInfo.getPower();
            soul.setMaxMagic((float)Math.max((double)soul.getMaxMagic(), 20.0 + reputation * (1.0 + capacity / 2.0)));
            soul.setMagic((float)Math.max((double)soul.getMagic(), (double)soul.getMagic() + reputation + power * 2.0));
            if (!world.f_46443_) {
                Networking.sendToTracking(world, player.m_20097_(), new SoulUpdatePacket(player));
            }
        });
    }

    protected boolean reputationCheck(Level world, Player player, double minDevotion) {
        LazyOptional iReputationLazyOptional = world.getCapability(IReputation.INSTANCE);
        if (iReputationLazyOptional.resolve().isEmpty()) {
            return true;
        }
        IReputation iReputation = (IReputation)iReputationLazyOptional.resolve().get();
        if (!iReputation.canPray(player, this.getRegistryName(), world.m_46467_())) {
            player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.prayer_cooldown"), true);
            return true;
        }
        return iReputation.getReputation(player.m_20148_(), this.deity.getId()) < minDevotion;
    }

    @Nullable
    protected static GobletTileEntity getGoblet(Level world, BlockPos pos) {
        List<GobletTileEntity> goblets = Ritual.getTilesWithinAABB(GobletTileEntity.class, world, new AABB(pos.m_7918_(-4, -4, -4), pos.m_7918_(5, 5, 5)));
        if (goblets.isEmpty()) {
            return null;
        }
        return goblets.stream().min(Comparator.comparingDouble(e -> e.m_58899_().m_123331_((Vec3i)pos))).get();
    }

    @Nullable
    protected static EffigyTileEntity getEffigy(Level world, BlockPos pos) {
        List<EffigyTileEntity> effigies = Ritual.getTilesWithinAABB(EffigyTileEntity.class, world, new AABB(pos.m_7918_(-4, -4, -4), pos.m_7918_(5, 5, 5)));
        if (effigies.isEmpty()) {
            return null;
        }
        return effigies.stream().min(Comparator.comparingDouble(e -> e.m_58899_().m_123331_((Vec3i)pos))).get();
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EffigyTileEntity effigy = PrayerSpell.getEffigy(world, pos);
        if (effigy == null) {
            return;
        }
        if (!world.f_46443_) {
            effigy.pray();
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
            world.getCapability(IReputation.INSTANCE, null).ifPresent(rep -> {
                rep.pray(player, this.getRegistryName(), world.m_46467_());
                rep.addReputation(player, this.deity.getId(), 1.0 + 0.25 * info.getPower());
                PrayerSpell.updateMagic(info, player, world, rep.getReputation(player, this.deity.getId()));
            });
        } else {
            this.playSuccessSound(world, player, effigy, this.deity);
        }
    }

    protected void playSuccessSound(Level world, Player player, EffigyTileEntity effigy, RGBProvider color) {
        world.m_5594_(player, effigy.m_58899_(), SoundEvents.f_12090_, SoundSource.NEUTRAL, 10000.0f, 0.6f + world.f_46441_.m_188501_() * 0.2f);
        world.m_5594_(player, effigy.m_58899_(), SoundEvents.f_12089_, SoundSource.NEUTRAL, 2.0f, 0.5f + world.f_46441_.m_188501_() * 0.2f);
        BlockState state = world.m_8055_(effigy.m_58899_());
        Direction dir = (Direction)state.m_61143_((Property)HorizontalBlockBase.HORIZONTAL_FACING);
        Direction tangent = dir.m_122427_();
        float x = (float)effigy.m_58899_().m_123341_() + 0.5f + (float)dir.m_122429_() * 0.21875f;
        float y = (float)effigy.m_58899_().m_123342_() + 0.8125f;
        float z = (float)effigy.m_58899_().m_123343_() + 0.5f + (float)dir.m_122431_() * 0.21875f;
        Particles.create(EidolonParticles.FLAME_PARTICLE).setColor(color.getRed(), color.getGreen(), color.getBlue()).setAlpha(0.5f, 0.0f).setScale(0.125f, 0.0625f).randomOffset(0.01f).randomVelocity(0.0025f).addVelocity(0.0, 0.005f, 0.0).repeat(world, x + 0.09375f * (float)tangent.m_122429_(), y, z + 0.09375f * (float)tangent.m_122431_(), 8);
        Particles.create(EidolonParticles.FLAME_PARTICLE).setColor(color.getRed(), color.getGreen(), color.getBlue()).setAlpha(0.5f, 0.0f).setScale(0.1875f, 0.125f).randomOffset(0.01f).randomVelocity(0.0025f).addVelocity(0.0, 0.005f, 0.0).repeat(world, x - 0.09375f * (float)tangent.m_122429_(), y, z - 0.09375f * (float)tangent.m_122431_(), 8);
    }
}

