/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import com.mojang.serialization.DynamicOps;
import elucent.eidolon.api.altar.AltarInfo;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.PrayerSpell;
import elucent.eidolon.common.tile.EffigyTileEntity;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;

public class ZombifySpell
extends PrayerSpell {
    public ZombifySpell(ResourceLocation resourceLocation, Sign ... signs) {
        super(resourceLocation, Deities.DARK_DEITY, 20, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        HitResult ray = ZombifySpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
        boolean flag = ray instanceof EntityHitResult && (result = (EntityHitResult)ray).m_82443_() instanceof Villager;
        EffigyTileEntity effigy = ZombifySpell.getEffigy(world, pos);
        if (effigy == null) {
            return false;
        }
        AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
        if (info.getAltar() != Registry.STONE_ALTAR.get() || info.getIcon() != Registry.ELDER_EFFIGY.get()) {
            return false;
        }
        return flag && super.canCast(world, pos, player);
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        Entity entity;
        EffigyTileEntity effigy = ZombifySpell.getEffigy(world, pos);
        if (effigy == null) {
            return;
        }
        HitResult ray = ZombifySpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
        if (!(ray instanceof EntityHitResult) || !((entity = (result = (EntityHitResult)ray).m_82443_()) instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            effigy.pray();
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
            world.getCapability(IReputation.INSTANCE, null).ifPresent(rep -> {
                rep.pray(player, this.getRegistryName(), world.m_46467_());
                KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.ZOMBIFY_VILLAGER);
                rep.addReputation(player, this.deity.getId(), 6.0 + info.getPower());
                ZombifySpell.updateMagic(info, player, world, rep.getReputation(player, this.deity.getId()));
            });
            this.zombify(villager, level);
            ISoul.expendMana(player, this.getCost());
        } else {
            this.playSuccessSound(world, player, effigy, Signs.DEATH_SIGN);
        }
    }

    private void zombify(Villager villager, ServerLevel level) {
        ZombieVillager zombievillager = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false);
        if (zombievillager == null) {
            return;
        }
        zombievillager.m_6518_((ServerLevelAccessor)level, level.m_6436_(zombievillager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), null);
        zombievillager.m_34375_(villager.m_7141_());
        zombievillager.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
        zombievillager.m_34411_(villager.m_6616_().m_45388_());
        zombievillager.m_34373_(villager.m_7809_());
        ForgeEventFactory.onLivingConvert((LivingEntity)villager, (LivingEntity)zombievillager);
    }
}

