/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import elucent.eidolon.common.tile.CrucibleTileEntity;
import elucent.eidolon.recipe.CrucibleRegistry;
import elucent.eidolon.registries.EidolonRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class CrucibleRecipe
implements Recipe<Container> {
    List<Step> steps;
    ResourceLocation registryName;
    final ItemStack result;

    public ItemStack getResult() {
        return this.result;
    }

    public CrucibleRecipe(List<Step> steps, ItemStack result) {
        this.steps = steps;
        this.result = result;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public CrucibleRecipe setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return this;
    }

    public boolean matches(List<CrucibleTileEntity.CrucibleStep> items) {
        if (this.steps.size() != items.size()) {
            return false;
        }
        ArrayList<Ingredient> matchList = new ArrayList<Ingredient>();
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.steps.size(); ++i) {
            Step correct = this.steps.get(i);
            CrucibleTileEntity.CrucibleStep provided = items.get(i);
            if (correct.stirs != provided.getStirs()) {
                return false;
            }
            matchList.clear();
            itemList.clear();
            matchList.addAll(correct.matches);
            itemList.addAll(provided.getContents());
            block1: for (int j = 0; j < matchList.size(); ++j) {
                for (int k = 0; k < itemList.size(); ++k) {
                    if (!((Ingredient)matchList.get(j)).test((ItemStack)itemList.get(k))) continue;
                    matchList.remove(j--);
                    itemList.remove(k--);
                    continue block1;
                }
            }
            if (matchList.isEmpty() && itemList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean m_5818_(@NotNull Container inv, @NotNull Level worldIn) {
        return false;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inv, @NotNull RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.result;
    }

    @NotNull
    public ItemStack getResultItem() {
        return this.result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.registryName;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.CRUCIBLE_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.CRUCIBLE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Step {
        public final List<Ingredient> matches = new ArrayList<Ingredient>();
        public final int stirs;

        public Step(int stirs, List<Ingredient> matches) {
            this.stirs = stirs;
            this.matches.addAll(matches);
        }
    }

    public static class Serializer
    implements RecipeSerializer<CrucibleRecipe> {
        @NotNull
        public CrucibleRecipe fromJson(@NotNull ResourceLocation recipeId, JsonObject json) {
            ArrayList<Step> steps = new ArrayList<Step>();
            JsonArray stepArray = json.getAsJsonArray("steps");
            for (JsonElement elt : stepArray) {
                if (!elt.isJsonObject()) {
                    throw new JsonSyntaxException("Expected JSON object for crucible step.");
                }
                JsonObject step = elt.getAsJsonObject();
                int stirs = step.has("stirs") ? step.get("stirs").getAsInt() : 0;
                ArrayList<Ingredient> matches = new ArrayList<Ingredient>();
                if (step.has("items")) {
                    JsonArray items = step.get("items").getAsJsonArray();
                    for (JsonElement item : items) {
                        matches.add(Ingredient.m_43917_((JsonElement)item));
                    }
                }
                steps.add(new Step(stirs, matches));
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("result"), (boolean)true);
            return CrucibleRegistry.register(new CrucibleRecipe(steps, result).setRegistryName(recipeId));
        }

        public CrucibleRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int count = buffer.readInt();
            ArrayList<Step> steps = new ArrayList<Step>();
            for (int i = 0; i < count; ++i) {
                int stirs = buffer.readInt();
                int ingredients = buffer.readInt();
                ArrayList<Ingredient> matches = new ArrayList<Ingredient>();
                for (int j = 0; j < ingredients; ++j) {
                    matches.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                }
                steps.add(new Step(stirs, matches));
            }
            ItemStack result = buffer.m_130267_();
            return CrucibleRegistry.register(new CrucibleRecipe(steps, result).setRegistryName(recipeId));
        }

        public void toNetwork(FriendlyByteBuf buffer, CrucibleRecipe recipe) {
            buffer.writeInt(recipe.steps.size());
            for (Step step : recipe.steps) {
                buffer.writeInt(step.stirs);
                buffer.writeInt(step.matches.size());
                for (Ingredient i : step.matches) {
                    i.m_43923_(buffer);
                }
            }
            buffer.m_130055_(recipe.result);
        }
    }
}

