/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.Validate;

public class CyclingControl<T extends Enum<T>>
implements Control<T> {
    private final Option<T> option;
    private final T[] allowedValues;
    private final Component[] names;

    public CyclingControl(Option<T> option, Class<T> enumType) {
        this(option, enumType, (Enum[])enumType.getEnumConstants());
    }

    public CyclingControl(Option<T> option, Class<T> enumType, Component[] names) {
        Object[] universe = (Enum[])enumType.getEnumConstants();
        Validate.isTrue((universe.length == names.length ? 1 : 0) != 0, (String)"Mismatch between universe length and names array length", (Object[])new Object[0]);
        Validate.notEmpty((Object[])universe, (String)"The enum universe must contain at least one item", (Object[])new Object[0]);
        this.option = option;
        this.allowedValues = universe;
        this.names = names;
    }

    public CyclingControl(Option<T> option, Class<T> enumType, T[] allowedValues) {
        Enum[] universe = (Enum[])enumType.getEnumConstants();
        this.option = option;
        this.allowedValues = allowedValues;
        this.names = new Component[universe.length];
        for (int i = 0; i < this.names.length; ++i) {
            Enum value = universe[i];
            Object name = value instanceof TextProvider ? ((TextProvider)((Object)value)).getLocalizedName() : Component.m_237113_((String)value.name());
            this.names[i] = name;
        }
    }

    @Override
    public Option<T> getOption() {
        return this.option;
    }

    @Override
    public ControlElement<T> createElement(Dim2i dim) {
        return new CyclingControlElement(this.option, dim, this.allowedValues, this.names);
    }

    @Override
    public int getMaxWidth() {
        return 70;
    }

    private static class CyclingControlElement<T extends Enum<T>>
    extends ControlElement<T> {
        private final T[] allowedValues;
        private final Component[] names;
        private int currentIndex;

        public CyclingControlElement(Option<T> option, Dim2i dim, T[] allowedValues, Component[] names) {
            super(option, dim);
            this.allowedValues = allowedValues;
            this.names = names;
            this.currentIndex = 0;
            for (int i = 0; i < allowedValues.length; ++i) {
                if (allowedValues[i] != option.getValue()) continue;
                this.currentIndex = i;
                break;
            }
        }

        @Override
        public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            super.m_88315_(drawContext, mouseX, mouseY, delta);
            Enum value = (Enum)this.option.getValue();
            Component name = this.names[value.ordinal()];
            int strWidth = this.getStringWidth((FormattedText)name);
            this.drawString(drawContext, name, this.dim.getLimitX() - strWidth - 6, this.dim.getCenterY() - 4, -1);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                this.cycleControl(Screen.m_96638_());
                this.playClickSound();
                return true;
            }
            return false;
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (!this.m_93696_()) {
                return false;
            }
            if (CommonInputs.m_278691_((int)keyCode)) {
                this.cycleControl(Screen.m_96638_());
                return true;
            }
            return false;
        }

        public void cycleControl(boolean reverse) {
            this.currentIndex = reverse ? (this.currentIndex + this.allowedValues.length - 1) % this.allowedValues.length : (this.currentIndex + 1) % this.allowedValues.length;
            this.option.setValue(this.allowedValues[this.currentIndex]);
        }
    }
}

