/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.dynamiclights.api;

import java.util.function.Function;
import me.srrapero720.dynamiclights.LambDynLights;
import me.srrapero720.embeddiumplus.EmbPlusConfig;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DynamicLightHandler<T> {
    public int getLuminance(T var1);

    default public boolean isWaterSensitive(T lightSource) {
        return false;
    }

    @NotNull
    public static <T extends LivingEntity> DynamicLightHandler<T> makeHandler(final Function<T, Integer> luminance, final Function<T, Boolean> waterSensitive) {
        return new DynamicLightHandler<T>(){

            @Override
            public int getLuminance(T lightSource) {
                return (Integer)luminance.apply(lightSource);
            }

            @Override
            public boolean isWaterSensitive(T lightSource) {
                return (Boolean)waterSensitive.apply(lightSource);
            }
        };
    }

    @NotNull
    public static <T extends LivingEntity> DynamicLightHandler<T> makeLivingEntityHandler(@NotNull DynamicLightHandler<T> handler) {
        return entity -> {
            int luminance = 0;
            for (ItemStack equipped : entity.m_20158_()) {
                luminance = Math.max(luminance, LambDynLights.getLuminanceFromItemStack(equipped, entity.m_5842_()));
            }
            return Math.max(luminance, handler.getLuminance(entity));
        };
    }

    @NotNull
    public static <T extends Creeper> DynamicLightHandler<T> makeCreeperEntityHandler(final @Nullable DynamicLightHandler<T> handler) {
        return new DynamicLightHandler<T>(){

            @Override
            public int getLuminance(T entity) {
                int luminance = 0;
                if ((double)entity.m_32320_(0.0f) > 0.001) {
                    switch ((EmbPlusConfig.DynamicLightsQuality)((Object)EmbPlusConfig.dynQuality.get())) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case OFF: {
                            int n = 0;
                            break;
                        }
                        case SLOW: 
                        case FAST: 
                        case FASTEST: {
                            int n = 10;
                            break;
                        }
                        case REALTIME: {
                            int n = luminance = (int)((double)entity.m_32320_(0.0f) * 10.0);
                        }
                    }
                }
                if (handler != null) {
                    luminance = Math.max(luminance, handler.getLuminance(entity));
                }
                return luminance;
            }

            @Override
            public boolean isWaterSensitive(T lightSource) {
                return true;
            }
        };
    }
}

