/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.dynamiclights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import me.srrapero720.dynamiclights.LambDynLights;
import me.srrapero720.dynamiclights.api.item.ItemLightSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class ItemLightSources {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final List<ItemLightSource> ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();
    private static final List<ItemLightSource> STATIC_ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();

    private ItemLightSources() {
        throw new UnsupportedOperationException("ItemLightSources only contains static definitions.");
    }

    public static void load(@NotNull ResourceManager resourceManager) {
        ITEM_LIGHT_SOURCES.clear();
        resourceManager.m_214159_("dynamiclights/item", path -> path.m_135815_().endsWith(".json")).forEach((id, resource) -> ItemLightSources.load(resourceManager, id, resource));
        ITEM_LIGHT_SOURCES.addAll(STATIC_ITEM_LIGHT_SOURCES);
    }

    private static void load(@NotNull ResourceManager resourceManager, @NotNull ResourceLocation resourceId, Resource resource) {
        ResourceLocation id = new ResourceLocation(resourceId.m_135827_(), resourceId.m_135815_().replace(".json", ""));
        try {
            JsonObject json = JSON_PARSER.parse((Reader)new InputStreamReader(resource.m_215507_())).getAsJsonObject();
            ItemLightSource.fromJson(id, json).ifPresent(data -> {
                if (!STATIC_ITEM_LIGHT_SOURCES.contains(data)) {
                    ItemLightSources.register(data);
                }
            });
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.warn("Failed to load item light source \"" + id + "\".");
        }
    }

    private static void register(@NotNull ItemLightSource data) {
        for (ItemLightSource other : ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            LambDynLights.warn("Failed to register item light source \"" + data.id() + "\", duplicates item \"" + ForgeRegistries.ITEMS.getKey((Object)data.item()) + "\" found in \"" + other.id() + "\".");
            return;
        }
        ITEM_LIGHT_SOURCES.add(data);
    }

    public static void registerItemLightSource(@NotNull ItemLightSource data) {
        for (ItemLightSource other : STATIC_ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            LambDynLights.warn("Failed to register item light source \"" + data.id() + "\", duplicates item \"" + ForgeRegistries.ITEMS.getKey((Object)data.item()) + "\" found in \"" + other.id() + "\".");
            return;
        }
        STATIC_ITEM_LIGHT_SOURCES.add(data);
    }

    public static int getLuminance(@NotNull ItemStack stack, boolean submergedInWater) {
        for (ItemLightSource data : ITEM_LIGHT_SOURCES) {
            if (data.item() != stack.m_41720_()) continue;
            return data.getLuminance(stack, submergedInWater);
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return ItemLightSource.BlockItemLightSource.getLuminance(stack, blockItem.m_40614_().m_49966_());
        }
        return 0;
    }
}

