/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EmbPlusTools {
    public static boolean isNearPlayer(Level world, BlockPos pos, int maxHeight, int maxDistanceSquare) {
        return EmbPlusTools.isNearPlayerInternal(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), maxHeight, maxDistanceSquare, false);
    }

    private static boolean isNearPlayerInternal(Level world, double posx, double posy, double posz, int maxHeight, int maxDistanceSquare, boolean allowNullPlayers) {
        List closest = world.m_6907_();
        for (Player player : closest) {
            double z;
            double x;
            boolean nearPlayer;
            if (player == null) {
                return allowNullPlayers;
            }
            if (!(Math.abs(player.m_20186_() - posy) < (double)maxHeight) || !(nearPlayer = (x = player.m_20185_() - posx) * x + (z = player.m_20189_() - posz) * z < (double)maxDistanceSquare)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity player, Entity entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.m_20186_() - entity.m_20186_() - 4.0) < (double)maxHeight) {
            double z;
            double x = player.m_20185_() - entity.m_20185_();
            return x * x + (z = player.m_20189_() - entity.m_20189_()) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(BlockPos player, Vec3 entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs((double)player.m_123342_() - entity.f_82480_ - 4.0) < (double)maxHeight) {
            double z;
            double x = (double)player.m_123341_() - entity.f_82479_;
            return x * x + (z = (double)player.m_123343_() - entity.f_82481_) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity player, double cameraX, double cameraY, double cameraZ, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.m_20186_() - cameraY - 4.0) < (double)maxHeight) {
            double z;
            double x = player.m_20185_() - cameraX;
            return x * x + (z = player.m_20189_() - cameraZ) * z < (double)maxDistanceSquare;
        }
        return false;
    }
}

