/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

public class CoralEnderman
extends BaseEnderman {
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public CoralEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 6;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new CoralEndermanMoveControl();
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.13).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnCoralEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return BaseEnderman.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean checkSpawnRules(EntityType<CoralEnderman> enderman, ServerLevelAccessor serverLevel, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        if (!EndermanOverhaulConfig.spawnCoralEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        if (!serverLevel.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        boolean bl = serverLevel.m_46791_() != Difficulty.PEACEFUL && CoralEnderman.m_219009_((ServerLevelAccessor)serverLevel, (BlockPos)pos, (RandomSource)random) && (mobSpawnType == MobSpawnType.SPAWNER || serverLevel.m_6425_(pos).m_205070_(FluidTags.f_13131_));
        return random.m_188503_(40) == 0 && pos.m_123342_() < serverLevel.m_5736_() - 5 && bl;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 0, state -> {
            if (this.m_20069_()) {
                state.getController().setAnimation(ConstantAnimations.SWIM);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation((double)state.getLimbSwingAmount() > 0.1 || (double)state.getLimbSwingAmount() < -0.1 ? ConstantAnimations.WALK : ConstantAnimations.IDLE);
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.m_21324_(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        })});
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BaseEnderman.EndermanFreezeWhenLookedAt(this));
        this.f_21345_.m_25352_(1, (Goal)new CoralEndermanSwimGoal());
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BaseEnderman.EndermanLookForPlayerGoal(this, arg_0 -> ((CoralEnderman)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    @Nullable
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.BUBBLE.get();
    }

    @Override
    public int getParticleCount() {
        return 1;
    }

    @Override
    public int getParticleRate() {
        return 4;
    }

    @Override
    public boolean canPickupBlocks() {
        return false;
    }

    @Override
    public boolean canTeleport() {
        return this.m_32531_() || this.m_20146_() <= 20;
    }

    @Override
    public double getVisionRange() {
        return 64.0;
    }

    public boolean m_6126_() {
        return false;
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public void m_6075_() {
        int airSupply = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(airSupply);
    }

    @Override
    public boolean speedUpWhenAngry() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
        super.m_7023_(travelVector);
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_9236_().m_8055_(this.m_20183_().m_7494_().m_7494_()).m_60713_(Blocks.f_49990_)) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
        super.m_5844_();
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() <= 20 && this.m_9236_().m_46467_() % 20L == 0L && !this.teleportToWater()) {
                for (int i = 0; i < 64 && !this.m_32529_(); ++i) {
                }
            }
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    private boolean teleportToWater() {
        RandomSource randomSource = this.m_217043_();
        BlockPos blockPos = this.m_20183_();
        for (int i = 0; i < 100; ++i) {
            BlockPos blockPos2 = blockPos.m_7918_(randomSource.m_188503_(30) - 10, 2 - randomSource.m_188503_(8), randomSource.m_188503_(30) - 10);
            if (!this.m_9236_().m_8055_(blockPos2).m_60713_(Blocks.f_49990_)) continue;
            Vec3 pos = Vec3.m_82539_((Vec3i)blockPos2);
            if (pos == null) {
                return false;
            }
            this.m_9236_().m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
            this.m_6021_(pos.m_7096_() + 0.5, pos.m_7098_(), pos.m_7094_() + 0.5);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private class CoralEndermanMoveControl
    extends MoveControl {
        CoralEndermanMoveControl() {
            super((Mob)CoralEnderman.this);
        }

        public void m_8126_() {
            if (!CoralEnderman.this.m_20069_()) {
                super.m_8126_();
                return;
            }
            LivingEntity livingEntity = CoralEnderman.this.m_5448_();
            if (livingEntity != null && livingEntity.m_20186_() > CoralEnderman.this.m_20186_()) {
                CoralEnderman.this.m_20256_(CoralEnderman.this.m_20184_().m_82520_(0.0, 0.002, 0.0));
            }
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO || CoralEnderman.this.m_21573_().m_26571_()) {
                CoralEnderman.this.m_7910_(0.0f);
                return;
            }
            double d = this.f_24975_ - CoralEnderman.this.m_20185_();
            double e = this.f_24976_ - CoralEnderman.this.m_20186_();
            double f = this.f_24977_ - CoralEnderman.this.m_20189_();
            double g = Math.sqrt(d * d + e * e + f * f);
            e /= g;
            float h = (float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f;
            CoralEnderman.this.m_146922_(this.m_24991_(CoralEnderman.this.m_146908_(), h, 90.0f));
            CoralEnderman.this.f_20883_ = CoralEnderman.this.m_146908_();
            float i = (float)(this.f_24978_ * CoralEnderman.this.m_21133_(Attributes.f_22279_));
            float j = Mth.m_14179_((float)0.125f, (float)CoralEnderman.this.m_6113_(), (float)i);
            CoralEnderman.this.m_7910_(j);
            CoralEnderman.this.m_20256_(CoralEnderman.this.m_20184_().m_82520_((double)(j *= 15.0f) * d * 0.005, (double)j * e * 0.025, (double)j * f * 0.005));
            if (CoralEnderman.this.m_32531_()) {
                CoralEnderman.this.m_246865_(new Vec3(CoralEnderman.this.m_20184_().f_82479_ * 0.18, 0.0, CoralEnderman.this.m_20184_().f_82481_ * 0.18));
            }
        }
    }

    private class CoralEndermanSwimGoal
    extends RandomSwimmingGoal {
        public CoralEndermanSwimGoal() {
            super((PathfinderMob)CoralEnderman.this, 1.0, 40);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !CoralEnderman.this.m_32531_();
        }
    }
}

