/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.base;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.items.HoodItem;

public abstract class BaseEnderman
extends EnderMan
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lastStareSound = Integer.MIN_VALUE;

    public BaseEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 5, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(this.m_32531_() && this.playRunAnimWhenAngry() ? ConstantAnimations.RUN : ConstantAnimations.WALK);
            } else {
                state.getController().setAnimation(ConstantAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "creepy_controller", 5, state -> {
            if (!this.canOpenMouth()) {
                return PlayState.STOP;
            }
            if (!this.m_32531_()) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ANGRY);
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "hold_controller", 5, state -> {
            if (!this.canPickupBlocks()) {
                return PlayState.STOP;
            }
            if (this.m_32530_() == null) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.HOLDING);
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.m_21324_(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        })});
    }

    public boolean canOpenMouth() {
        return true;
    }

    public boolean playRunAnimWhenAngry() {
        return true;
    }

    public boolean canShake() {
        return true;
    }

    public boolean playArmSwingAnimWhenAttacking() {
        return true;
    }

    public boolean isProvokedByEyeContact() {
        return true;
    }

    public boolean hasParticles() {
        return true;
    }

    @Nullable
    public ParticleOptions getCustomParticles() {
        return null;
    }

    public int getParticleCount() {
        return 2;
    }

    public int getParticleRate() {
        return 1;
    }

    public boolean canPickupBlocks() {
        return true;
    }

    public Vec3 getHeldBlockOffset() {
        return Vec3.f_82478_;
    }

    public boolean isAlwaysHostile() {
        return false;
    }

    public boolean canTeleport() {
        return true;
    }

    public double getVisionRange() {
        return 256.0;
    }

    @Nullable
    public MobEffectInstance getHitEffect() {
        return null;
    }

    public TagKey<Block> getCarriableBlockTag() {
        return BlockTags.f_13046_;
    }

    @Nullable
    public MobEffectInstance getAreaEffect() {
        return null;
    }

    @Nullable
    public SoundEvent getAreaEffectSound() {
        return null;
    }

    public int getAreaEffectRange() {
        return 0;
    }

    public boolean hasLargeCreepyHitbox() {
        return false;
    }

    public SoundEvent getStareSound() {
        return SoundEvents.f_11851_;
    }

    public boolean speedUpWhenAngry() {
        return true;
    }

    public boolean canFloat() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickAreaEffect();
    }

    protected void tickAreaEffect() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.m_9236_().m_46467_() % 20L != 0L) {
            return;
        }
        MobEffectInstance areaEffect = this.getAreaEffect();
        if (areaEffect == null || this.getAreaEffectRange() == 0) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        if (this.m_20280_((Entity)target) <= (double)(this.getAreaEffectRange() * this.getAreaEffectRange())) {
            if (this.getAreaEffectSound() != null && !target.m_21023_(areaEffect.m_19544_())) {
                this.m_9236_().m_5594_(null, target.m_20183_(), this.getAreaEffectSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            target.m_7292_(areaEffect);
        }
    }

    public void m_32528_() {
        if (this.f_19797_ >= this.lastStareSound + 400) {
            this.lastStareSound = this.f_19797_;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), this.getStareSound(), this.m_5720_(), 2.5f, 1.0f, false);
            }
        }
    }

    public void m_8107_() {
        ParticleOptions customParticleType = this.getCustomParticles();
        if (this.hasParticles() && this.m_9236_().m_5776_() && customParticleType != null && this.m_9236_().m_46467_() % (long)this.getParticleRate() == 0L) {
            for (int i = 0; i < this.getParticleCount(); ++i) {
                this.m_9236_().m_7106_(customParticleType, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        super.m_8107_();
    }

    public boolean m_7327_(@NotNull Entity target) {
        if (super.m_7327_(target)) {
            MobEffectInstance effect = this.getHitEffect();
            if (effect != null && target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                entity.m_7292_(effect);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (!this.hasLargeCreepyHitbox() || !this.m_32531_()) {
            return super.m_6972_(pose);
        }
        return super.m_6972_(pose).m_20390_(1.0f, 1.15f);
    }

    protected void m_8099_() {
        if (this.canFloat()) {
            this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        }
        this.f_21345_.m_25352_(1, (Goal)new EndermanFreezeWhenLookedAt());
        if (this.isAlwaysHostile()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, e -> !(e.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof HoodItem)));
        }
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new EndermanLeaveBlockGoal());
        this.f_21345_.m_25352_(11, (Goal)new EndermanTakeBlockGoal());
        this.f_21346_.m_25352_(1, (Goal)new EndermanLookForPlayerGoal(arg_0 -> ((BaseEnderman)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean m_32534_(Player player) {
        if (!this.isProvokedByEyeContact()) {
            return false;
        }
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof HoodItem) {
            return false;
        }
        ItemStack itemStack = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (itemStack.m_150930_(Blocks.f_50143_.m_5456_())) {
            return false;
        }
        Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
        Vec3 vec32 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double d = vec32.m_82553_();
        double e = vec3.m_82526_(vec32 = vec32.m_82541_());
        return e > 1.0 - 0.025 / d && player.m_142582_((Entity)this);
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 2.55f + (dimensions.f_20378_ - 2.9f);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        this.m_6210_();
    }

    protected boolean m_32529_() {
        if (!this.canTeleport()) {
            return false;
        }
        return super.m_32529_();
    }

    public boolean m_32500_(Entity target) {
        if (!this.canTeleport()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20227_(0.5) - target.m_20188_(), this.m_20189_() - target.m_20189_());
        vec3 = vec3.m_82541_();
        double e = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double f = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double g = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(e, f, g);
    }

    public boolean teleport(double x, double y, double z) {
        if (!this.canTeleport()) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_280555_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
        boolean bl = blockState.m_280555_();
        boolean bl2 = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (bl && !bl2) {
            Vec3 vec3 = this.m_20182_();
            boolean bl3 = this.m_20984_(x, y, z, true);
            if (bl3) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return bl3;
        }
        return false;
    }

    public class EndermanFreezeWhenLookedAt
    extends Goal {
        @Nullable
        private LivingEntity target;

        public EndermanFreezeWhenLookedAt() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = BaseEnderman.this.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d = this.target.m_20280_((Entity)BaseEnderman.this);
            return !(d > BaseEnderman.this.getVisionRange()) && BaseEnderman.this.m_32534_((Player)this.target);
        }

        public void m_8056_() {
            BaseEnderman.this.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            BaseEnderman.this.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }

    public class EndermanLeaveBlockGoal
    extends Goal {
        public boolean m_8036_() {
            if (BaseEnderman.this.m_32530_() == null) {
                return false;
            }
            if (!BaseEnderman.this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                return false;
            }
            return BaseEnderman.this.m_217043_().m_188503_(EndermanLeaveBlockGoal.m_186073_((int)2000)) == 0;
        }

        public void m_8037_() {
            RandomSource randomSource = BaseEnderman.this.m_217043_();
            Level level = BaseEnderman.this.m_9236_();
            int i = Mth.m_14107_((double)(BaseEnderman.this.m_20185_() - 1.0 + randomSource.m_188500_() * 2.0));
            int j = Mth.m_14107_((double)(BaseEnderman.this.m_20186_() + randomSource.m_188500_() * 2.0));
            int k = Mth.m_14107_((double)(BaseEnderman.this.m_20189_() - 1.0 + randomSource.m_188500_() * 2.0));
            BlockPos blockPos = new BlockPos(i, j, k);
            BlockState blockState = level.m_8055_(blockPos);
            BlockPos blockPos2 = blockPos.m_7495_();
            BlockState blockState2 = level.m_8055_(blockPos2);
            BlockState blockState3 = BaseEnderman.this.m_32530_();
            if (blockState3 != null && this.canPlaceBlock(level, blockPos, blockState3 = Block.m_49931_((BlockState)blockState3, (LevelAccessor)BaseEnderman.this.m_9236_(), (BlockPos)blockPos), blockState, blockState2, blockPos2)) {
                level.m_7731_(blockPos, blockState3, 3);
                level.m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)BaseEnderman.this, (BlockState)blockState3));
                BaseEnderman.this.m_32521_(null);
            }
        }

        private boolean canPlaceBlock(Level level, BlockPos destinationPos, BlockState carriedState, BlockState destinationState, BlockState belowDestinationState, BlockPos belowDestinationPos) {
            return destinationState.m_60795_() && !belowDestinationState.m_60795_() && !belowDestinationState.m_60713_(Blocks.f_50752_) && belowDestinationState.m_60838_((BlockGetter)level, belowDestinationPos) && carriedState.m_60710_((LevelReader)level, destinationPos) && level.m_45933_((Entity)BaseEnderman.this, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)destinationPos))).isEmpty();
        }
    }

    public class EndermanTakeBlockGoal
    extends Goal {
        public boolean m_8036_() {
            if (!EndermanOverhaulConfig.allowPickingUpBlocks) {
                return false;
            }
            if (!BaseEnderman.this.canPickupBlocks()) {
                return false;
            }
            if (BaseEnderman.this.m_32530_() != null) {
                return false;
            }
            if (!BaseEnderman.this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                return false;
            }
            return BaseEnderman.this.m_217043_().m_188503_(EndermanTakeBlockGoal.m_186073_((int)20)) == 0;
        }

        public void m_8037_() {
            RandomSource randomSource = BaseEnderman.this.m_217043_();
            Level level = BaseEnderman.this.m_9236_();
            int i = Mth.m_14107_((double)(BaseEnderman.this.m_20185_() - 2.0 + randomSource.m_188500_() * 4.0));
            int j = Mth.m_14107_((double)(BaseEnderman.this.m_20186_() + randomSource.m_188500_() * 3.0));
            int k = Mth.m_14107_((double)(BaseEnderman.this.m_20189_() - 2.0 + randomSource.m_188500_() * 4.0));
            BlockPos blockPos = new BlockPos(i, j, k);
            BlockState blockState = level.m_8055_(blockPos);
            Vec3 vec3 = new Vec3((double)BaseEnderman.this.m_146903_() + 0.5, (double)j + 0.5, (double)BaseEnderman.this.m_146907_() + 0.5);
            Vec3 vec32 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockHitResult blockHitResult = level.m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)BaseEnderman.this));
            boolean bl = blockHitResult.m_82425_().equals((Object)blockPos);
            if (blockState.m_204336_(BaseEnderman.this.getCarriableBlockTag()) && bl) {
                level.m_7471_(blockPos, false);
                level.m_220407_(GameEvent.f_157794_, blockPos, GameEvent.Context.m_223719_((Entity)BaseEnderman.this, (BlockState)blockState));
                BaseEnderman.this.m_32521_(blockState.m_60734_().m_49966_());
            }
        }
    }

    public class EndermanLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions;
        private final Predicate<LivingEntity> isAngerInducing;

        public EndermanLookForPlayerGoal(Predicate<LivingEntity> predicate) {
            super((Mob)BaseEnderman.this, Player.class, 10, false, false, predicate);
            this.continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();
            this.isAngerInducing = livingEntity -> (BaseEnderman.this.m_32534_((Player)livingEntity) || BaseEnderman.this.m_21674_((LivingEntity)livingEntity)) && !BaseEnderman.this.m_20367_((Entity)livingEntity);
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(this.isAngerInducing);
        }

        public boolean m_8036_() {
            this.pendingTarget = BaseEnderman.this.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)BaseEnderman.this);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            this.teleportTime = 0;
            BaseEnderman.this.m_32533_();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.isAngerInducing.test((LivingEntity)this.pendingTarget)) {
                    return false;
                }
                BaseEnderman.this.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            if (this.f_26050_ != null) {
                if (BaseEnderman.this.m_20367_((Entity)this.f_26050_)) {
                    return false;
                }
                if (this.continueAggroTargetConditions.m_26885_((LivingEntity)BaseEnderman.this, this.f_26050_)) {
                    return true;
                }
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            if (BaseEnderman.this.m_5448_() == null) {
                super.m_26070_(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !BaseEnderman.this.m_20159_()) {
                    if (BaseEnderman.this.m_32534_((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)BaseEnderman.this) < 16.0) {
                            BaseEnderman.this.m_32529_();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)BaseEnderman.this) > BaseEnderman.this.getVisionRange() && this.teleportTime++ >= this.m_183277_(30) && BaseEnderman.this.m_32500_((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

