/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.common.enchantment.override;

import cofh.lib.common.enchantment.EnchantmentOverride;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class ProtectionEnchantmentImp
extends EnchantmentOverride {
    private final Type protectionType;

    public ProtectionEnchantmentImp(Enchantment.Rarity rarityIn, Type protectionTypeIn, EquipmentSlot[] slots) {
        super(rarityIn, protectionTypeIn == Type.FALL ? EnchantmentCategory.ARMOR_FEET : EnchantmentCategory.ARMOR, slots);
        this.protectionType = protectionTypeIn;
        this.maxLevel = 4;
    }

    public int m_7205_(int level, DamageSource source) {
        if (level <= 0 || source.m_269533_(DamageTypeTags.f_268738_)) {
            return 0;
        }
        if (this.protectionType == Type.ALL) {
            return level;
        }
        if (this.protectionType == Type.FALL && source.m_269533_(DamageTypeTags.f_268549_)) {
            return level * 3;
        }
        if (this.protectionType == Type.FIRE && source.m_269533_(DamageTypeTags.f_268745_)) {
            return level * 2;
        }
        if (this.protectionType == Type.EXPLOSION && source.m_269533_(DamageTypeTags.f_268415_)) {
            return level * 2;
        }
        if (this.protectionType == Type.MAGIC && source.m_269533_(DamageTypeTags.f_268731_)) {
            return level * 2;
        }
        return this.protectionType == Type.PROJECTILE && source.m_269533_(DamageTypeTags.f_268524_) ? level * 2 : 0;
    }

    public int m_6183_(int level) {
        return this.protectionType.getMinimalEnchantability() + (level - 1) * this.protectionType.getEnchantIncreasePerLevel();
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + this.protectionType.getEnchantIncreasePerLevel();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (!this.enable) {
            if (this.protectionType == Type.MAGIC) {
                return false;
            }
            return super.canApplyAtEnchantingTable(stack);
        }
        return super.canApplyAtEnchantingTable(stack) || stack.m_41720_() instanceof HorseArmorItem;
    }

    public boolean m_5975_(Enchantment ench) {
        if (ench instanceof ProtectionEnchantmentImp) {
            ProtectionEnchantmentImp enchProtection = (ProtectionEnchantmentImp)ench;
            if (this.protectionType == enchProtection.protectionType) {
                return false;
            }
            return this.protectionType == Type.FALL || enchProtection.protectionType == Type.FALL;
        }
        return super.m_5975_(ench);
    }

    public boolean isAllowedOnBooks() {
        return this.protectionType == Type.MAGIC ? this.enable && this.allowOnBooks : super.isAllowedOnBooks();
    }

    public static enum Type {
        ALL("all", 1, 11),
        FALL("fall", 5, 6),
        FIRE("fire", 10, 8),
        EXPLOSION("explosion", 5, 8),
        MAGIC("magic", 10, 8),
        PROJECTILE("projectile", 3, 6);

        private final String typeName;
        private final int minEnchantability;
        private final int levelCost;

        private Type(String typeName, int minEnchantability, int levelCost) {
            this.typeName = typeName;
            this.minEnchantability = minEnchantability;
            this.levelCost = levelCost;
        }

        public int getMinimalEnchantability() {
            return this.minEnchantability;
        }

        public int getEnchantIncreasePerLevel() {
            return this.levelCost;
        }
    }
}

