/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.common.event;

import cofh.ensorcellation.common.enchantment.DisplacementEnchantment;
import cofh.ensorcellation.common.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.common.enchantment.FrostRebukeEnchantment;
import cofh.ensorcellation.common.enchantment.override.ThornsEnchantmentImp;
import cofh.ensorcellation.init.registries.ModEnchantments;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ThornsEnchantment;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class ShieldEnchEvents {
    private ShieldEnchEvents() {
    }

    @SubscribeEvent
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        ItemStack stack = entity.m_21211_();
        if (ShieldEnchEvents.canBlockDamageSource(entity, source) && attacker != null) {
            Player playerAttacker;
            int encBulwark;
            int encFrostRebuke;
            int encFireRebuke;
            int encDisplacement;
            int encThorns = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44972_, (ItemStack)stack);
            if (ThornsEnchantmentImp.shouldHit(encThorns, entity.m_217043_())) {
                attacker.m_6469_(entity.m_269291_().m_269374_((Entity)entity), (float)ThornsEnchantment.m_220319_((int)encThorns, (RandomSource)entity.m_217043_()));
            }
            if (DisplacementEnchantment.shouldHit(encDisplacement = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.DISPLACEMENT.get()), (ItemStack)stack), entity.m_217043_())) {
                DisplacementEnchantment.onHit(entity, attacker, encDisplacement);
            }
            if (FireRebukeEnchantment.shouldHit(encFireRebuke = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.FIRE_REBUKE.get()), (ItemStack)stack), entity.m_217043_())) {
                FireRebukeEnchantment.onHit(entity, attacker, encFireRebuke);
            }
            if (FrostRebukeEnchantment.shouldHit(encFrostRebuke = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.FROST_REBUKE.get()), (ItemStack)stack), entity.m_217043_())) {
                FrostRebukeEnchantment.onHit(entity, attacker, encFrostRebuke);
            }
            if ((encBulwark = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.BULWARK.get()), (ItemStack)stack)) > 0 && attacker instanceof Player && (playerAttacker = (Player)attacker).m_217043_().m_188501_() < 0.5f) {
                playerAttacker.m_36335_().m_41524_(playerAttacker.m_21205_().m_41720_(), 100);
                attacker.f_19853_.m_7605_(attacker, (byte)30);
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingUpdateEvent(LivingEvent.LivingTickEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ItemStack stack = entity.m_21211_();
        AttributeInstance knockbackResAttr = entity.m_21051_(Attributes.f_22278_);
        AttributeInstance moveSpeedAttr = entity.m_21051_(Attributes.f_22279_);
        if (knockbackResAttr != null) {
            knockbackResAttr.m_22120_(Constants.UUID_ENCH_BULWARK_KNOCKBACK_RESISTANCE);
        }
        if (moveSpeedAttr != null) {
            moveSpeedAttr.m_22120_(Constants.UUID_ENCH_PHALANX_MOVEMENT_SPEED);
        }
        if (stack.m_41720_().canPerformAction(stack, ToolActions.SHIELD_BLOCK)) {
            int encBulwark = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.BULWARK.get()), (ItemStack)stack);
            if (knockbackResAttr != null && encBulwark > 0) {
                knockbackResAttr.m_22118_(new AttributeModifier(Constants.UUID_ENCH_BULWARK_KNOCKBACK_RESISTANCE, "bulwark", 1.0, AttributeModifier.Operation.ADDITION));
            }
            int encPhalanx = Utils.getItemEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.PHALANX.get()), (ItemStack)stack);
            if (moveSpeedAttr != null && encPhalanx > 0) {
                moveSpeedAttr.m_22118_(new AttributeModifier(Constants.UUID_ENCH_PHALANX_MOVEMENT_SPEED, "phalanx", 1.25 * (double)encPhalanx, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    private static boolean canBlockDamageSource(LivingEntity living, DamageSource source) {
        Vec3 vec3d2;
        AbstractArrow arrow;
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_36796_() > 0) {
            return false;
        }
        if (!source.m_269533_(DamageTypeTags.f_276146_) && living.m_21254_() && (vec3d2 = source.m_7270_()) != null) {
            Vec3 vec3d = living.m_20252_(1.0f);
            Vec3 vec3d1 = vec3d2.m_82505_(new Vec3(living.m_20185_(), living.m_20186_(), living.m_20189_())).m_82541_();
            vec3d1 = new Vec3(vec3d1.f_82479_, 0.0, vec3d1.f_82481_);
            return vec3d1.m_82526_(vec3d) < 0.0;
        }
        return false;
    }
}

