/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.entity;

import cy.jdkdigital.everythingcopper.common.entity.IWeatheringEntity;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;

public class CopperGolem
extends IronGolem
implements IWeatheringEntity {
    private static BlockPattern patternBase;
    private static BlockPattern patternFull;

    public CopperGolem(EntityType<? extends IronGolem> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public SynchedEntityData getSyncData() {
        return super.m_20088_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.getSyncData().m_135372_(DATA_WEATHER_STATE, (Object)WeatheringCopper.WeatherState.UNAFFECTED.name());
        this.getSyncData().m_135372_(DATA_WAXED, (Object)false);
    }

    protected Component m_5677_() {
        String id = (this.isWaxed() ? "waxed_" : "") + this.getAge().name().toLowerCase() + "_copper_golem";
        return Component.m_237115_((String)this.m_6095_().m_20675_().replace("copper_golem", id));
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_151052_)) {
            float f = this.m_21223_();
            this.m_5634_(25.0f);
            if (this.m_21223_() == f) {
                return InteractionResult.PASS;
            }
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            this.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_8119_() {
        if (this.f_19797_ % 369 == 0 && this.canAge() && this.m_9236_().f_46441_.m_188501_() < 0.005688889f) {
            this.setAge(WeatheringUtils.nextState(this.getAge()));
        }
        super.m_8119_();
    }

    public float m_6113_() {
        return super.m_6113_() * this.speedModifier();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.saveWeatheredState(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadWeatheredState(tag);
    }

    public static boolean canSpawnGolem(LevelReader level, BlockPos pos) {
        return CopperGolem.getOrCreateCopperGolemBase().m_61184_(level, pos) != null;
    }

    private static BlockPattern getOrCreateCopperGolemBase() {
        if (patternBase == null) {
            patternBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "###", "~#~"}).m_61244_('#', BlockInWorld.m_61169_(state -> state != null && (state.m_60713_(Blocks.f_152504_) || state.m_60713_(Blocks.f_152503_) || state.m_60713_(Blocks.f_152502_) || state.m_60713_(Blocks.f_152501_) || state.m_60713_(Blocks.f_152571_) || state.m_60713_(Blocks.f_152573_) || state.m_60713_(Blocks.f_152572_) || state.m_60713_(Blocks.f_152574_)))).m_61244_('~', state -> state.m_61168_().m_60795_()).m_61249_();
        }
        return patternBase;
    }

    public static BlockPattern getOrCreateCopperGolemFull() {
        if (patternFull == null) {
            patternFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_((Predicate)CarvedPumpkinBlock.f_51372_)).m_61244_('#', BlockInWorld.m_61169_(state -> state != null && (state.m_60713_(Blocks.f_152504_) || state.m_60713_(Blocks.f_152503_) || state.m_60713_(Blocks.f_152502_) || state.m_60713_(Blocks.f_152501_) || state.m_60713_(Blocks.f_152571_) || state.m_60713_(Blocks.f_152573_) || state.m_60713_(Blocks.f_152572_) || state.m_60713_(Blocks.f_152574_)))).m_61244_('~', block -> block.m_61168_().m_60795_()).m_61249_();
        }
        return patternFull;
    }
}

