/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.clibano;

import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoItemHandler;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResidueType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResiduesStorage;
import com.stal111.forbidden_arcanus.common.block.properties.ClibanoCenterType;
import com.stal111.forbidden_arcanus.common.block.properties.ClibanoSideType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoMenu;
import com.stal111.forbidden_arcanus.common.recipe.ClibanoRecipe;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceFuelSlot;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.valhelsia.valhelsia_core.api.common.block.entity.MenuCreationContext;
import net.valhelsia.valhelsia_core.api.common.block.entity.forge.ValhelsiaContainerBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClibanoMainBlockEntity
extends ValhelsiaContainerBlockEntity<ClibanoMainBlockEntity>
implements RecipeHolder {
    public static final int SOUL_DURATION = 2700;
    public static final int DATA_SOUL_TIME = 0;
    public static final int DATA_BURN_TIME = 1;
    public static final int DATA_BURN_DURATION = 2;
    public static final int DATA_COOKING_PROGRESS_FIRST = 3;
    public static final int DATA_COOKING_PROGRESS_SECOND = 4;
    public static final int DATA_COOKING_DURATION_FIRST = 5;
    public static final int DATA_COOKING_DURATION_SECOND = 6;
    public static final int DATA_FIRE_TYPE = 7;
    public static final int DATA_RESIDUE_FULLNESS = 8;
    public static final int BASE_DATA_COUNT = 9;
    public static final int FULL_DATA_COUNT = 9 + ResiduesStorage.RESIDUE_TYPES.size();
    public static final RecipeType<ClibanoRecipe> RECIPE_TYPE = (RecipeType)ModRecipeTypes.CLIBANO_COMBUSTION.get();
    private final ResiduesStorage residuesStorage = new ResiduesStorage();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private int soulTime;
    private int burnTime;
    private int burnDuration;
    private int cookingProgressFirst;
    private int cookingProgressSecond;
    private int cookingDurationFirst;
    private int cookingDurationSecond;
    private ClibanoFireType fireType = ClibanoFireType.FIRE;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            ClibanoMainBlockEntity blockEntity = ClibanoMainBlockEntity.this;
            return switch (index) {
                case 0 -> blockEntity.soulTime;
                case 1 -> blockEntity.burnTime;
                case 2 -> blockEntity.burnDuration;
                case 3 -> blockEntity.cookingProgressFirst;
                case 4 -> blockEntity.cookingProgressSecond;
                case 5 -> blockEntity.cookingDurationFirst;
                case 6 -> blockEntity.cookingDurationSecond;
                case 7 -> blockEntity.fireType.ordinal();
                case 8 -> blockEntity.residuesStorage.getTotalAmount();
                default -> {
                    ResidueType type = ResiduesStorage.RESIDUE_TYPES.get(index - 9);
                    yield blockEntity.residuesStorage.getResidueTypeAmountMap().getOrDefault(type, 0);
                }
            };
        }

        public void m_8050_(int index, int value) {
            ClibanoMainBlockEntity blockEntity = ClibanoMainBlockEntity.this;
            switch (index) {
                case 0: {
                    blockEntity.setSoulTime(value);
                    break;
                }
                case 1: {
                    blockEntity.burnTime = value;
                    break;
                }
                case 2: {
                    blockEntity.burnDuration = value;
                    break;
                }
                case 3: {
                    blockEntity.cookingProgressFirst = value;
                    break;
                }
                case 4: {
                    blockEntity.cookingProgressSecond = value;
                    break;
                }
                case 5: {
                    blockEntity.cookingDurationFirst = value;
                    break;
                }
                case 6: {
                    blockEntity.cookingDurationSecond = value;
                    break;
                }
                case 7: {
                    blockEntity.fireType = ClibanoFireType.values()[value];
                    break;
                }
                case 8: {
                    blockEntity.residuesStorage.setTotalAmount(value);
                    break;
                }
                default: {
                    blockEntity.residuesStorage.getResidueTypeAmountMap().put(ResiduesStorage.RESIDUE_TYPES.get(index - 9), value);
                }
            }
        }

        public int m_6499_() {
            return FULL_DATA_COUNT;
        }
    };
    private Direction frontDirection = Direction.NORTH;
    private boolean wasLit = false;
    private final LazyOptional<IItemHandler> topInputHandler = LazyOptional.of(() -> new ClibanoItemHandler((IItemHandler)this.getItemStackHandler(), Direction.UP));
    private final LazyOptional<IItemHandler> sideInputHandler = LazyOptional.of(() -> new ClibanoItemHandler((IItemHandler)this.getItemStackHandler(), Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new ClibanoItemHandler((IItemHandler)this.getItemStackHandler(), Direction.DOWN));

    public ClibanoMainBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CLIBANO_MAIN.get(), pos, state, 7, (slot, stack) -> {
            if (slot == 1) {
                return ClibanoFireType.fromItem(stack) != ClibanoFireType.FIRE;
            }
            if (slot == 2) {
                return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44109_) > 0 || FurnaceFuelSlot.m_39529_((ItemStack)stack);
            }
            return !slot.equals(ClibanoMenu.RESULT_SLOTS.getFirst()) && !slot.equals(ClibanoMenu.RESULT_SLOTS.getSecond());
        });
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ClibanoMainBlockEntity blockEntity) {
        SimpleContainer firstSlot = new SimpleContainer(new ItemStack[]{blockEntity.getStack((Integer)ClibanoMenu.INPUT_SLOTS.getFirst())});
        SimpleContainer secondSlot = new SimpleContainer(new ItemStack[]{blockEntity.getStack((Integer)ClibanoMenu.INPUT_SLOTS.getSecond())});
        ClibanoRecipe firstRecipe = level.m_7465_().m_44015_(RECIPE_TYPE, (Container)firstSlot, level).orElse(null);
        ClibanoRecipe secondRecipe = level.m_7465_().m_44015_(RECIPE_TYPE, (Container)secondSlot, level).orElse(null);
        boolean isLit = blockEntity.burnTime > 0;
        ClibanoFireType newFireType = blockEntity.getFireTypeFromInput();
        ClibanoFireType currentHighestType = newFireType.ordinal() > blockEntity.fireType.ordinal() ? newFireType : blockEntity.fireType;
        RegistryAccess registryAccess = level.m_9598_();
        boolean canSmeltFirst = firstRecipe != null && blockEntity.canBurn(registryAccess, firstRecipe, currentHighestType, blockEntity.getMaxStackSize(), (Integer)ClibanoMenu.INPUT_SLOTS.getFirst());
        boolean canSmeltSecond = secondRecipe != null && blockEntity.canBurn(registryAccess, secondRecipe, currentHighestType, blockEntity.getMaxStackSize(), (Integer)ClibanoMenu.INPUT_SLOTS.getSecond());
        RandomSource random = level.m_213780_();
        blockEntity.residuesStorage.tick(level, blockEntity);
        if (blockEntity.soulTime != 0) {
            --blockEntity.soulTime;
            if (blockEntity.soulTime == 0) {
                blockEntity.changeFireType(level, ClibanoFireType.FIRE, firstRecipe, secondRecipe);
            }
        } else if ((canSmeltFirst || canSmeltSecond) && newFireType != ClibanoFireType.FIRE) {
            blockEntity.soulTime = 2700;
            blockEntity.changeFireType(level, newFireType, firstRecipe, secondRecipe);
            blockEntity.getStack(1).m_41774_(1);
        }
        if (isLit) {
            --blockEntity.burnTime;
        } else {
            if (canSmeltFirst || canSmeltSecond) {
                ItemStack fuel = blockEntity.getStack(2);
                blockEntity.burnDuration = 0;
                if (!fuel.m_41619_()) {
                    blockEntity.burnDuration = blockEntity.burnTime = blockEntity.getBurnDuration(fuel);
                    fuel.m_41774_(1);
                    if (!blockEntity.wasLit) {
                        blockEntity.updateAppearance(level);
                    }
                    blockEntity.m_6596_();
                }
            }
            if (blockEntity.cookingProgressFirst != 0 || blockEntity.cookingProgressSecond != 0) {
                blockEntity.cookingProgressFirst = Math.max(0, blockEntity.cookingProgressFirst - 2);
                blockEntity.cookingProgressSecond = Math.max(0, blockEntity.cookingProgressSecond - 2);
                blockEntity.m_6596_();
            }
            if (blockEntity.wasLit) {
                blockEntity.updateAppearance(level);
            }
            blockEntity.wasLit = false;
            return;
        }
        if (canSmeltFirst) {
            blockEntity.cookingDurationFirst = firstRecipe.getCookingTime(blockEntity.fireType);
            ++blockEntity.cookingProgressFirst;
            if (blockEntity.cookingProgressFirst == blockEntity.cookingDurationFirst) {
                blockEntity.finishRecipe(registryAccess, firstRecipe, random, (Integer)ClibanoMenu.INPUT_SLOTS.getFirst());
            }
            blockEntity.m_6596_();
        } else {
            blockEntity.cookingProgressFirst = 0;
        }
        if (canSmeltSecond) {
            blockEntity.cookingDurationSecond = secondRecipe.getCookingTime(blockEntity.fireType);
            ++blockEntity.cookingProgressSecond;
            if (blockEntity.cookingProgressSecond == blockEntity.cookingDurationSecond) {
                blockEntity.finishRecipe(registryAccess, secondRecipe, random, (Integer)ClibanoMenu.INPUT_SLOTS.getSecond());
            }
            blockEntity.m_6596_();
        } else {
            blockEntity.cookingProgressSecond = 0;
        }
        blockEntity.wasLit = true;
    }

    private ClibanoFireType getFireTypeFromInput() {
        ItemStack soul = this.getStack(1);
        if (!soul.m_41619_()) {
            return ClibanoFireType.fromItem(soul);
        }
        return ClibanoFireType.FIRE;
    }

    private static void createExperience(ServerLevel level, Vec3 position, int count, float experience) {
        int i = Mth.m_14143_((float)((float)count * experience));
        float f = Mth.m_14187_((float)((float)count * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)i);
    }

    private boolean canBurn(RegistryAccess registryAccess, ClibanoRecipe recipe, ClibanoFireType fireType, int maxCount, int slot) {
        if (this.getStack(slot).m_41619_()) {
            return false;
        }
        ItemStack stack = recipe.m_8043_(registryAccess);
        if (stack.m_41619_() || fireType.ordinal() < recipe.getRequiredFireType().ordinal()) {
            return false;
        }
        ItemStack resultStack = this.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getFirst());
        ItemStack secondResultStack = this.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getSecond());
        if (resultStack.m_41619_() || secondResultStack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)resultStack, (ItemStack)stack) && !ItemStack.m_41656_((ItemStack)secondResultStack, (ItemStack)stack)) {
            return false;
        }
        if (ItemStack.m_41656_((ItemStack)resultStack, (ItemStack)stack) && resultStack.m_41613_() + stack.m_41613_() <= maxCount && resultStack.m_41613_() + stack.m_41613_() <= resultStack.m_41741_()) {
            return true;
        }
        if (ItemStack.m_41656_((ItemStack)secondResultStack, (ItemStack)stack) && secondResultStack.m_41613_() + stack.m_41613_() <= maxCount && secondResultStack.m_41613_() + stack.m_41613_() <= secondResultStack.m_41741_()) {
            return true;
        }
        return ItemStack.m_41656_((ItemStack)resultStack, (ItemStack)stack) && resultStack.m_41613_() + stack.m_41613_() <= stack.m_41741_() || ItemStack.m_41656_((ItemStack)secondResultStack, (ItemStack)stack) && secondResultStack.m_41613_() + stack.m_41613_() <= stack.m_41741_();
    }

    private void finishRecipe(RegistryAccess registryAccess, ClibanoRecipe recipe, RandomSource random, int slot) {
        ItemStack stack = recipe.m_8043_(registryAccess);
        this.getStack(slot).m_41774_(1);
        if (slot == (Integer)ClibanoMenu.INPUT_SLOTS.getFirst()) {
            this.cookingProgressFirst = 0;
        } else {
            this.cookingProgressSecond = 0;
        }
        if (stack.m_41619_()) {
            return;
        }
        ItemStack resultStack = this.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getFirst());
        ItemStack secondResultStack = this.getStack((Integer)ClibanoMenu.RESULT_SLOTS.getSecond());
        if (ItemStack.m_41656_((ItemStack)resultStack, (ItemStack)stack) && resultStack.m_41613_() + stack.m_41613_() <= resultStack.m_41741_()) {
            resultStack.m_41769_(stack.m_41613_());
        } else if (ItemStack.m_41656_((ItemStack)secondResultStack, (ItemStack)stack) && secondResultStack.m_41613_() + stack.m_41613_() <= secondResultStack.m_41741_()) {
            secondResultStack.m_41769_(stack.m_41613_());
        } else if (resultStack.m_41619_()) {
            this.setStack((Integer)ClibanoMenu.RESULT_SLOTS.getFirst(), stack.m_41777_());
        } else if (secondResultStack.m_41619_()) {
            this.setStack((Integer)ClibanoMenu.RESULT_SLOTS.getSecond(), stack.m_41777_());
        }
        this.addResidue(recipe, random);
        this.m_6029_((Recipe<?>)recipe);
    }

    private void addResidue(ClibanoRecipe recipe, RandomSource random) {
        if (this.fireType == ClibanoFireType.FIRE) {
            return;
        }
        ClibanoRecipe.ResidueInfo residueInfo = recipe.getResidueInfo();
        if (residueInfo == ClibanoRecipe.ResidueInfo.NONE) {
            return;
        }
        if (random.m_188500_() < residueInfo.chance()) {
            this.residuesStorage.increaseType(residueInfo.getType(), 1);
        }
    }

    private void changeFireType(Level level, ClibanoFireType fireType, @Nullable ClibanoRecipe firstRecipe, @Nullable ClibanoRecipe secondRecipe) {
        int oldDuration;
        this.fireType = fireType;
        if (firstRecipe != null) {
            oldDuration = this.cookingDurationFirst;
            this.cookingDurationFirst = firstRecipe.getCookingTime(fireType);
            this.cookingProgressFirst = (int)((float)this.cookingProgressFirst / (float)oldDuration * (float)this.cookingDurationFirst);
        }
        if (secondRecipe != null) {
            oldDuration = this.cookingDurationSecond;
            this.cookingDurationSecond = secondRecipe.getCookingTime(fireType);
            this.cookingProgressSecond = (int)((float)this.cookingProgressSecond / (float)oldDuration * (float)this.cookingDurationSecond);
        }
        this.updateAppearance(level);
        this.m_6596_();
    }

    private void updateAppearance(Level level) {
        ClibanoCenterType centerType = ClibanoCenterType.FRONT_OFF;
        ClibanoSideType sideType = ClibanoSideType.OFF;
        if (this.burnTime > 0) {
            centerType = this.fireType.getCenterType();
            sideType = this.fireType.getSideType();
        }
        BlockPos frontCenterPos = this.f_58858_.m_121945_(this.frontDirection);
        BlockState center = (BlockState)level.m_8055_(frontCenterPos).m_61124_(ModBlockStateProperties.CLIBANO_CENTER_TYPE, (Comparable)((Object)centerType));
        level.m_46597_(frontCenterPos, center);
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == this.frontDirection.m_122434_()) continue;
            BlockState side = (BlockState)level.m_8055_(frontCenterPos.m_121945_(direction)).m_61124_(ModBlockStateProperties.CLIBANO_SIDE_TYPE, (Comparable)((Object)sideType));
            level.m_46597_(frontCenterPos.m_121945_(direction), side);
        }
    }

    public void setFrontDirection(Direction direction) {
        this.frontDirection = direction;
    }

    @Nonnull
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.forbidden_arcanus.clibano");
    }

    protected AbstractContainerMenu createMenu(int containerId, @NotNull MenuCreationContext context) {
        return new ClibanoMenu(containerId, this.getItemStackHandler(), this.containerData, (MenuCreationContext<ClibanoMainBlockEntity, IItemHandler>)context);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        this.saveInventory(tag);
        tag.m_128405_("SoulTime", this.soulTime);
        tag.m_128405_("BurnTime", this.burnTime);
        tag.m_128405_("CookingProgressFirst", this.cookingProgressFirst);
        tag.m_128405_("CookingProgressSecond", this.cookingProgressSecond);
        tag.m_128405_("CookingDurationFirst", this.cookingDurationFirst);
        tag.m_128405_("CookingDurationSecond", this.cookingDurationSecond);
        tag.m_128359_("FireType", this.fireType.m_7912_());
        tag.m_128359_("FrontDirection", this.frontDirection.m_122433_());
        CompoundTag recipesUsed = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, integer) -> recipesUsed.m_128405_(resourceLocation.toString(), integer.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)recipesUsed);
        if (this.residuesStorage.shouldBeSaved()) {
            this.residuesStorage.save(tag);
        }
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.loadInventory(tag);
        this.soulTime = tag.m_128451_("SoulTime");
        this.burnTime = tag.m_128451_("BurnTime");
        this.burnDuration = this.getBurnDuration(this.getStack(2));
        this.cookingProgressFirst = tag.m_128451_("CookingProgressFirst");
        this.cookingProgressSecond = tag.m_128451_("CookingProgressSecond");
        this.cookingDurationFirst = tag.m_128451_("CookingDurationFirst");
        this.cookingDurationSecond = tag.m_128451_("CookingDurationSecond");
        this.fireType = ClibanoFireType.byName(tag.m_128461_("FireType")).orElse(ClibanoFireType.FIRE);
        this.frontDirection = Direction.m_122402_((String)tag.m_128461_("FrontDirection"));
        CompoundTag recipesUsed = tag.m_128469_("RecipesUsed");
        for (String recipe : recipesUsed.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(recipe), tag.m_128451_(recipe));
        }
        this.residuesStorage.load(tag);
    }

    public void setSoulTime(int duration) {
        this.soulTime = duration;
    }

    protected int getBurnDuration(ItemStack fuel) {
        if (fuel.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)fuel, RECIPE_TYPE);
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe == null) {
            return;
        }
        this.recipesUsed.addTo((Object)recipe.m_6423_(), 1);
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        player.m_7281_(this.getRecipesToAwardAndPopExperience(player.m_284548_(), player.m_20182_()));
        this.recipesUsed.clear();
    }

    public Collection<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 position) {
        ArrayList list = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add((Recipe<?>)recipe);
                ClibanoMainBlockEntity.createExperience(level, position, entry.getIntValue(), ((ClibanoRecipe)((Object)recipe)).m_43750_());
            });
        }
        return list;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.f_58859_ || this.f_58857_ == null) {
            return super.getCapability(cap, side);
        }
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER) && side != null) {
            if (side == Direction.DOWN) {
                return this.outputHandler.cast();
            }
            if (side == Direction.UP) {
                return this.topInputHandler.cast();
            }
            return this.sideInputHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

