/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.essence;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceModifier;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesStorage;
import java.util.List;
import java.util.function.BiConsumer;

public record EssencesDefinition(int aureal, int souls, int blood, int experience) {
    public static final Codec<EssencesDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("aureal").forGetter(EssencesDefinition::aureal), (App)Codec.INT.fieldOf("souls").forGetter(EssencesDefinition::souls), (App)Codec.INT.fieldOf("blood").forGetter(EssencesDefinition::blood), (App)Codec.INT.fieldOf("experience").forGetter(EssencesDefinition::experience)).apply((Applicative)instance, EssencesDefinition::new));

    public int get(EssenceType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EssenceType.AUREAL -> this.aureal;
            case EssenceType.SOULS -> this.souls;
            case EssenceType.BLOOD -> this.blood;
            case EssenceType.EXPERIENCE -> this.experience;
        };
    }

    public void forEach(BiConsumer<EssenceType, Integer> consumer) {
        for (EssenceType type : EssenceType.values()) {
            consumer.accept(type, this.get(type));
        }
    }

    public boolean hasMoreThan(EssencesDefinition definition) {
        for (EssenceType type : EssenceType.values()) {
            if (this.get(type) >= definition.get(type)) continue;
            return false;
        }
        return true;
    }

    public EssencesDefinition applyModifiers(List<EssenceModifier> modifiers) {
        EssencesStorage storage = this.mutable();
        storage.applyModifiers(modifiers);
        return storage.immutable();
    }

    public EssencesStorage mutable() {
        return new EssencesStorage(this.aureal, this.souls, this.blood, this.experience);
    }

    @Override
    public String toString() {
        return "EssencesDefinition{aureal=" + this.aureal + ", souls=" + this.souls + ", blood=" + this.blood + ", experience=" + this.experience + "}";
    }
}

