/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class ScreenWrapper
extends Screen
implements IScreenWrapper {
    private final BaseScreen wrappedGui;
    private final TooltipList tooltipList = new TooltipList();

    public ScreenWrapper(BaseScreen g) {
        super(g.getTitle());
        this.wrappedGui = g;
    }

    public void m_7856_() {
        super.m_7856_();
        this.wrappedGui.initGui();
    }

    public boolean m_7043_() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean m_6375_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        return this.wrappedGui.mousePressed(MouseButton.get(button)) || super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.m_6348_(x, y, button);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        return this.wrappedGui.mouseScrolled(scroll) || super.m_6050_(x, y, scroll);
    }

    public boolean m_7979_(double x, double y, int button, double dragX, double dragY) {
        return this.wrappedGui.mouseDragged(button, dragX, dragY) || super.m_7979_(x, y, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
            return true;
        }
        if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(true);
            return true;
        }
        if (Platform.isModLoaded((String)"jei")) {
            this.wrappedGui.getIngredientUnderMouse().ifPresent(underMouse -> this.handleIngredientKey(key, underMouse.ingredient()));
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.m_5534_(keyChar, (int)keyChar);
    }

    private void handleIngredientKey(Key key, Object object) {
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        this.m_280273_(graphics);
        GuiHelper.setupDrawing();
        int x = this.wrappedGui.getX();
        int y = this.wrappedGui.getY();
        int w = this.wrappedGui.width;
        int h = this.wrappedGui.height;
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.draw(graphics, theme, x, y, w, h);
        this.wrappedGui.drawForeground(graphics, theme, x, y, w, h);
        this.wrappedGui.getContextMenu().orElse(this.wrappedGui).addMouseOverText(this.tooltipList);
        if (!this.tooltipList.shouldRender()) {
            this.wrappedGui.getIngredientUnderMouse().ifPresent(underMouse -> {
                ItemStack stack;
                Object ingredient;
                if (underMouse.tooltip() && (ingredient = underMouse.ingredient()) instanceof ItemStack && !(stack = (ItemStack)ingredient).m_41619_()) {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(0.0f, 0.0f, (float)this.tooltipList.zOffsetItemTooltip);
                    graphics.m_280153_(theme.getFont(), (ItemStack)ingredient, mouseX, mouseY);
                    graphics.m_280168_().m_85849_();
                }
            });
        } else {
            this.tooltipList.render(graphics, mouseX, Math.max(mouseY, 18), this.wrappedGui.getScreen().m_85445_(), this.wrappedGui.getScreen().m_85446_(), theme.getFont());
        }
        this.tooltipList.reset();
    }

    public void m_280273_(GuiGraphics matrixStack) {
        if (this.wrappedGui.drawDefaultBackground(matrixStack)) {
            super.m_280273_(matrixStack);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.wrappedGui.tick();
    }

    @Override
    public BaseScreen getGui() {
        return this.wrappedGui;
    }

    public void m_7861_() {
        this.wrappedGui.onClosed();
        super.m_7861_();
    }
}

