/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestPositionableButton;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ChapterImageButton
extends Button
implements QuestPositionableButton,
Comparable<ChapterImageButton> {
    private static WeakReference<ChapterImage> clipboard = new WeakReference<Object>(null);
    private final QuestScreen questScreen;
    private final ChapterImage chapterImage;

    public ChapterImageButton(Panel panel, ChapterImage i) {
        super(panel, (Component)Component.m_237119_(), i.getImage());
        this.questScreen = (QuestScreen)panel.getGui();
        this.setSize(20, 20);
        this.chapterImage = i;
    }

    public static Optional<ChapterImage> getClipboard() {
        ChapterImage img = (ChapterImage)clipboard.get();
        if (img != null) {
            if (img.getChapter().isValid()) {
                return Optional.of(img);
            }
            clipboard = new WeakReference<Object>(null);
        }
        return Optional.empty();
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.questPanel.mouseOverQuest != null || this.questScreen.movingObjects || this.questScreen.viewQuestPanel.isMouseOver() || this.questScreen.chapterPanel.isMouseOver() || this.chapterImage.getClick().isEmpty() && !this.questScreen.file.canEdit()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void onClicked(MouseButton button) {
        if (this.questScreen.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> {
                String name = this.chapterImage.getImage() instanceof Color4I ? this.chapterImage.getColor().toString() : this.chapterImage.getImage().toString();
                ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
                    if (accepted) {
                        new EditObjectMessage(this.chapterImage.getChapter()).sendToServer();
                    }
                    this.run();
                }).setNameKey("Img: " + name);
                this.chapterImage.fillConfigGroup(group.getOrCreateSubgroup("chapter").getOrCreateSubgroup("image"));
                new EditConfigScreen(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.chapterImage.getChapter()), () -> this.questScreen.initiateMoving(this.chapterImage)){

                public void addMouseOverText(TooltipList list) {
                    list.add((Component)Component.m_237115_((String)"ftbquests.gui.move_tooltip").m_130940_(ChatFormatting.DARK_GRAY));
                }
            });
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"gui.copy"), Icons.INFO, () -> {
                clipboard = new WeakReference<ChapterImage>(this.chapterImage);
            }){

                public void addMouseOverText(TooltipList list) {
                    list.add((Component)Component.m_237113_((String)ChapterImageButton.this.chapterImage.getImage().toString()).m_130940_(ChatFormatting.DARK_GRAY));
                }
            });
            if (this.chapterImage.isAspectRatioOff()) {
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.fix_aspect_ratio_w"), Icons.ART, () -> this.chapterImage.fixupAspectRatio(true)));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.fix_aspect_ratio_h"), Icons.ART, () -> this.chapterImage.fixupAspectRatio(false)));
            }
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.chapterImage.getChapter().removeImage(this.chapterImage);
                new EditObjectMessage(this.chapterImage.getChapter()).sendToServer();
            }).setYesNoText((Component)Component.m_237110_((String)"delete_item", (Object[])new Object[]{this.chapterImage.getImage().toString()})));
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (Screen.m_96637_() && this.questScreen.file.canEdit()) {
                this.questScreen.toggleSelected(this.chapterImage);
            } else if (!this.chapterImage.getClick().isEmpty()) {
                this.playClickSound();
                this.handleClick(this.chapterImage.getClick());
            }
        } else if (this.questScreen.file.canEdit() && button.isMiddle()) {
            if (!this.questScreen.selectedObjects.contains(this.chapterImage)) {
                this.questScreen.toggleSelected(this.chapterImage);
            }
            this.questScreen.movingObjects = true;
        }
    }

    public void addMouseOverText(TooltipList list) {
        this.chapterImage.addHoverText(list);
    }

    public boolean shouldDraw() {
        return false;
    }

    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        boolean transparent;
        Icon image = this.chapterImage.getImage();
        boolean bl = transparent = !this.chapterImage.shouldShowImage(this.questScreen.file.selfTeamData);
        if (transparent) {
            image = image.withColor(Color4I.WHITE.withAlpha(100));
        } else if (!this.chapterImage.getColor().equals((Object)Color4I.WHITE) || this.chapterImage.getAlpha() < 255) {
            image = image.withColor(this.chapterImage.getColor().withAlpha(this.chapterImage.getAlpha()));
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        if (this.chapterImage.isAlignToCorner()) {
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.chapterImage.getRotation()));
            poseStack.m_85841_((float)w, (float)h, 1.0f);
            image.draw(graphics, 0, 0, 1, 1);
            if (this.questScreen.selectedObjects.contains(this.moveAndDeleteFocus())) {
                Color4I col = Color4I.WHITE.withAlpha((int)(128.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
                col.draw(graphics, 0, 0, 1, 1);
            }
        } else {
            poseStack.m_252880_((float)((int)((double)x + (double)w / 2.0)), (float)((int)((double)y + (double)h / 2.0)), 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.chapterImage.getRotation()));
            poseStack.m_85841_((float)w / 2.0f, (float)h / 2.0f, 1.0f);
            image.draw(graphics, -1, -1, 2, 2);
            if (this.questScreen.selectedObjects.contains(this.moveAndDeleteFocus())) {
                Color4I col = Color4I.WHITE.withAlpha((int)(128.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
                col.draw(graphics, -1, -1, 2, 2);
            }
        }
        poseStack.m_85849_();
    }

    @Override
    public QuestPositionableButton.Position getPosition() {
        return new QuestPositionableButton.Position(this.chapterImage.getX(), this.chapterImage.getY(), this.chapterImage.getWidth(), this.chapterImage.getHeight());
    }

    @Override
    public int compareTo(@NotNull ChapterImageButton o) {
        return Integer.compare(this.chapterImage.getOrder(), o.chapterImage.getOrder());
    }

    @Override
    public Movable moveAndDeleteFocus() {
        return this.chapterImage;
    }
}

