/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.fluid;

import com.buuz135.functionalstorage.fluid.HandlerTankSelector;
import com.buuz135.functionalstorage.inventory.ControllerInventoryHandler;
import com.buuz135.functionalstorage.util.ConnectedDrawers;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ControllerFluidHandler
implements IFluidHandler {
    HandlerTankSelector[] selectors;
    private int tanks = 0;

    public ControllerFluidHandler() {
        this.invalidateSlots();
    }

    public void invalidateSlots() {
        ArrayList<HandlerTankSelector> selectors = new ArrayList<HandlerTankSelector>();
        this.tanks = 0;
        for (IFluidHandler handler : this.getDrawers().getFluidHandlers()) {
            if (handler instanceof ControllerInventoryHandler) continue;
            int handlerTanks = handler.getTanks();
            for (int i = 0; i < handlerTanks; ++i) {
                selectors.add(new HandlerTankSelector(handler, i));
            }
            this.tanks += handlerTanks;
        }
        this.selectors = selectors.toArray(new HandlerTankSelector[selectors.size()]);
    }

    private HandlerTankSelector selectorForTank(int tank) {
        return tank >= 0 && tank < this.selectors.length ? this.selectors[tank] : null;
    }

    public int getTanks() {
        return this.tanks;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        HandlerTankSelector selector = this.selectorForTank(tank);
        return null != selector ? selector.getStackInSlot() : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        HandlerTankSelector selector = this.selectorForTank(tank);
        return null != selector ? selector.getCapacity() : 0;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        HandlerTankSelector selector = this.selectorForTank(tank);
        return null != selector && selector.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (HandlerTankSelector selector : this.selectors) {
            if (selector.getStackInSlot().isEmpty() || !selector.getStackInSlot().isFluidEqual(resource)) continue;
            return selector.fill(resource, action);
        }
        for (HandlerTankSelector selector : this.selectors) {
            if (!selector.getStackInSlot().isEmpty()) continue;
            return selector.fill(resource, action);
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (HandlerTankSelector selector : this.selectors) {
            if (selector.getStackInSlot().isEmpty() || !selector.getStackInSlot().isFluidEqual(resource)) continue;
            return selector.drain(resource, action);
        }
        for (HandlerTankSelector selector : this.selectors) {
            if (!selector.getStackInSlot().isEmpty()) continue;
            return selector.drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (HandlerTankSelector selector : this.selectors) {
            if (selector.getStackInSlot().isEmpty()) continue;
            return selector.drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    public abstract ConnectedDrawers getDrawers();
}

