/*
 * Decompiled with CFR 0.152.
 */
package lykrast.glassential.init;

import java.util.function.Supplier;
import lykrast.glassential.blocks.DarkEtherealGlassBlock;
import lykrast.glassential.blocks.EtherealGlassBlock;
import lykrast.glassential.blocks.RedstoneGlassBlock;
import lykrast.glassential.blocks.TooltipGlassBlock;
import lykrast.glassential.doors.GlassDoorBlock;
import lykrast.glassential.doors.GlassTrapDoorBlock;
import lykrast.glassential.init.GItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class GBlocks {
    public static final SoundEvent METAL_OPEN = SoundEvents.f_12056_;
    public static final SoundEvent METAL_CLOSE = SoundEvents.f_12055_;
    public static final SoundEvent WOOD_OPEN = SoundEvents.f_12627_;
    public static final SoundEvent WOOD_CLOSE = SoundEvents.f_12626_;
    public static final SoundEvent METAL_TRAP_OPEN = SoundEvents.f_12012_;
    public static final SoundEvent METAL_TRAP_CLOSE = SoundEvents.f_12011_;
    public static final SoundEvent WOOD_TRAP_OPEN = SoundEvents.f_12629_;
    public static final SoundEvent WOOD_TRAP_CLOSE = SoundEvents.f_12628_;
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"glassential");
    public static final RegistryObject<Block> GLASS_DARK_ETHEREAL = GBlocks.registerBlock("glass_dark_ethereal", () -> new DarkEtherealGlassBlock(GBlocks.glassProp().m_60910_(), false));
    public static final RegistryObject<Block> GLASS_DARK_ETHEREAL_REVERSE = GBlocks.registerBlock("glass_dark_ethereal_reverse", () -> new DarkEtherealGlassBlock(GBlocks.glassProp().m_60910_(), true));
    public static final RegistryObject<Block> GLASS_ETHEREAL = GBlocks.registerBlock("glass_ethereal", () -> new EtherealGlassBlock(GBlocks.glassProp().m_60910_(), false));
    public static final RegistryObject<Block> GLASS_ETHEREAL_REVERSE = GBlocks.registerBlock("glass_ethereal_reverse", () -> new EtherealGlassBlock(GBlocks.glassProp().m_60910_(), true));
    public static final RegistryObject<Block> GLASS_GHOSTLY = GBlocks.registerBlock("glass_ghostly", () -> new TooltipGlassBlock(GBlocks.glassProp().m_60910_(), "tooltip.glassential.ghostly"));
    public static final RegistryObject<Block> GLASS_LIGHT = GBlocks.registerBlock("glass_light", () -> new TooltipGlassBlock(GBlocks.glassProp().m_60953_(b -> 15), "tooltip.glassential.light"));
    public static final RegistryObject<Block> GLASS_REDSTONE = GBlocks.registerBlock("glass_redstone", () -> new RedstoneGlassBlock(GBlocks.glassProp()));
    public static final RegistryObject<Block> GLASS_DOOR = GBlocks.registerBlock("glass_door", () -> new GlassDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_), GBlocks.registerSound(Blocks.f_50058_, false)));
    public static final RegistryObject<Block> GLASS_TRAPDOOR = GBlocks.registerBlock("glass_trapdoor", () -> new GlassTrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_), GBlocks.registerSound(Blocks.f_50058_, false)));

    public static BlockSetType registerSound(Block block, Boolean isMetal) {
        SoundType soundGroup = block.m_49962_(null);
        if (isMetal.booleanValue()) {
            return BlockSetType.m_272115_((BlockSetType)new BlockSetType("blockset", false, soundGroup, METAL_CLOSE, METAL_OPEN, METAL_TRAP_CLOSE, METAL_TRAP_OPEN, SoundEvents.f_12066_, SoundEvents.f_12067_, SoundEvents.f_12443_, SoundEvents.f_12444_));
        }
        return BlockSetType.m_272115_((BlockSetType)new BlockSetType("blockset", true, soundGroup, WOOD_CLOSE, WOOD_OPEN, WOOD_TRAP_CLOSE, WOOD_TRAP_OPEN, SoundEvents.f_12636_, SoundEvents.f_12637_, SoundEvents.f_12631_, SoundEvents.f_12632_));
    }

    private static BlockBehaviour.Properties glassProp() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60922_(GBlocks::neverAllowSpawn).m_60924_(GBlocks::isntSolid).m_60960_(GBlocks::isntSolid).m_60971_(GBlocks::isntSolid);
    }

    private static Boolean neverAllowSpawn(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        GBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return GItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

