/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.chemical.material.IMaterialRegistryManager;
import com.gregtechceu.gtceu.api.registry.GTRegistry;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.Platform;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public class GTCEuAPI {
    public static GTCEu instance;
    public static IMaterialRegistryManager materialManager;
    private static boolean highTier;
    private static boolean highTierInitialized;

    @ApiStatus.Internal
    public static void initializeHighTier() {
        if (highTierInitialized) {
            throw new IllegalStateException("High-Tier is already initialized.");
        }
        highTier = ConfigHolder.INSTANCE.machines.highTierContent || AddonFinder.getAddons().stream().anyMatch(IGTAddon::requiresHighTier) || Platform.isDevEnv();
        highTierInitialized = true;
        if (GTCEuAPI.isHighTier()) {
            GTCEu.LOGGER.info("High-Tier is Enabled.");
        } else {
            GTCEu.LOGGER.info("High-Tier is Disabled.");
        }
    }

    public static boolean isHighTier() {
        return highTier;
    }

    public static class RegisterEvent<K, V>
    extends GenericEvent<V>
    implements IModBusEvent {
        private final GTRegistry<K, V> registry;

        public RegisterEvent(GTRegistry<K, V> registry, Class<V> clazz) {
            super(clazz);
            this.registry = registry;
        }

        public void register(K key, V value) {
            if (this.registry != null) {
                this.registry.register(key, value);
            }
        }

        public static class String<V>
        extends RegisterEvent<java.lang.String, V> {
            public String(GTRegistry<java.lang.String, V> registry, Class<V> clazz) {
                super(registry, clazz);
            }
        }

        public static class RL<V>
        extends RegisterEvent<ResourceLocation, V> {
            public RL(GTRegistry<ResourceLocation, V> registry, Class<V> clazz) {
                super(registry, clazz);
            }
        }
    }
}

