/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.client.renderer.block.MaterialBlockRenderer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.Platform;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MaterialBlock
extends AppearanceBlock {
    public final TagPrefix tagPrefix;
    public final Material material;

    public MaterialBlock(BlockBehaviour.Properties properties, TagPrefix tagPrefix, Material material, boolean registerModel) {
        super(properties);
        this.material = material;
        this.tagPrefix = tagPrefix;
        if (registerModel && Platform.isClient()) {
            MaterialBlockRenderer.create(this, tagPrefix.materialIconType(), material.getMaterialIconSet());
        }
    }

    public MaterialBlock(BlockBehaviour.Properties properties, TagPrefix tagPrefix, Material material) {
        this(properties, tagPrefix, material, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor tintedColor() {
        return (state, reader, pos, tintIndex) -> {
            Block patt2119$temp = state.m_60734_();
            if (patt2119$temp instanceof MaterialBlock) {
                MaterialBlock block = (MaterialBlock)patt2119$temp;
                return block.material.getLayerARGB(tintIndex);
            }
            return -1;
        };
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall) {
            level.m_186460_(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall) {
            level.m_186460_(currentPos, (Block)this, this.getDelayAfterPlace());
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_())) || pos.m_123342_() < level.m_141937_()) {
            return;
        }
        FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!(TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall)) {
            return;
        }
        if (random.m_188503_(16) == 0 && FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
            double d = (double)pos.m_123341_() + random.m_188500_();
            double e = (double)pos.m_123342_() - 0.05;
            double f = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public String m_7705_() {
        return this.tagPrefix.getUnlocalizedName(this.material);
    }

    public MutableComponent m_49954_() {
        return this.tagPrefix.getLocalizedName(this.material);
    }
}

