/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.blockentity;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.PipeCoverContainer;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAsyncAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoPersistBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class PipeBlockEntity<PipeType extends Enum<PipeType>, NodeDataType>
extends BlockEntity
implements IPipeNode<PipeType, NodeDataType>,
IEnhancedManaged,
IAsyncAutoSyncBlockEntity,
IAutoPersistBlockEntity,
IToolGridHighLight,
IToolable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PipeBlockEntity.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    private final long offset = GTValues.RNG.m_188503_(20);
    @DescSynced
    @Persisted(key="cover")
    protected final PipeCoverContainer coverContainer = new PipeCoverContainer(this);
    @DescSynced
    @Persisted
    @RequireRerender
    protected int connections = 0;
    @DescSynced
    @Persisted
    @RequireRerender
    private int blockedConnections = 0;
    private NodeDataType cachedNodeData;
    @Persisted
    @DescSynced
    @RequireRerender
    private int paintingColor = -1;
    @Persisted
    @DescSynced
    @RequireRerender
    private String frameMaterial;
    private final List<TickableSubscription> serverTicks = new ArrayList<TickableSubscription>();
    private final List<TickableSubscription> waitingToAdd = new ArrayList<TickableSubscription>();

    public PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public void scheduleRenderUpdate() {
        IPipeNode.super.scheduleRenderUpdate();
    }

    public IManagedStorage getRootStorage() {
        return this.syncStorage;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.m_58904_();
        if (level != null && !level.f_46443_ && level.m_7654_() != null) {
            level.m_7654_().execute(() -> ((PipeBlockEntity)this).m_6596_());
        }
    }

    @Override
    public long getOffsetTimer() {
        return this.f_58857_ == null ? this.offset : this.f_58857_.m_46467_() + this.offset;
    }

    public void m_7651_() {
        super.m_7651_();
        this.coverContainer.onUnload();
    }

    public void m_6339_() {
        super.m_6339_();
        this.coverContainer.onLoad();
    }

    @Override
    public int getNumConnections() {
        int count = 0;
        for (int connections = this.getConnections(); connections > 0; connections &= connections - 1) {
            ++count;
        }
        return count;
    }

    @Override
    public int getBlockedConnections() {
        return this.canHaveBlockedFaces() ? this.blockedConnections : 0;
    }

    @Override
    public NodeDataType getNodeData() {
        if (this.cachedNodeData == null) {
            this.cachedNodeData = this.getPipeBlock().createProperties(this);
        }
        return this.cachedNodeData;
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        if (!this.isRemote()) {
            Level level;
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            BlockState blockState = this.m_58900_();
            if (!((Boolean)blockState.m_61143_((Property)BlockProperties.SERVER_TICK)).booleanValue() && (level = this.m_58904_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                blockState = (BlockState)blockState.m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true));
                this.m_155250_(blockState);
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, () -> serverLevel.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true)))));
            }
            return subscription;
        }
        return null;
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        if (current != null) {
            current.unsubscribe();
        }
    }

    @Override
    public final void serverTick() {
        if (!this.waitingToAdd.isEmpty()) {
            this.serverTicks.addAll(this.waitingToAdd);
            this.waitingToAdd.clear();
        }
        Iterator<TickableSubscription> iter = this.serverTicks.iterator();
        while (iter.hasNext()) {
            TickableSubscription tickable = iter.next();
            if (tickable.isStillSubscribed()) {
                tickable.run();
            }
            if (tickable.isStillSubscribed()) continue;
            iter.remove();
        }
        if (this.serverTicks.isEmpty() && this.waitingToAdd.isEmpty() && !this.m_58901_()) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public void setBlocked(Direction side, boolean isBlocked) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canHaveBlockedFaces()) {
                this.blockedConnections = this.withSideConnection(this.blockedConnections, side, isBlocked);
                this.m_6596_();
                Object worldPipeNet = this.getPipeBlock().getWorldPipeNet(serverLevel);
                Object net = ((LevelPipeNet)((Object)worldPipeNet)).getNetFromPos(this.m_58899_());
                if (net != null) {
                    ((PipeNet)net).onPipeConnectionsUpdate();
                }
            }
        }
    }

    @Override
    public int getVisualConnections() {
        int visualConnections = this.connections;
        for (Direction side : GTUtil.DIRECTIONS) {
            CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
            if (cover == null || !cover.canPipePassThrough()) continue;
            visualConnections |= 1 << side.ordinal();
        }
        return visualConnections;
    }

    @Override
    public void setConnection(Direction side, boolean connected, boolean fromNeighbor) {
        if (!this.m_58904_().f_46443_) {
            IPipeNode pipeTile;
            if (this.isConnected(side) == connected) {
                return;
            }
            BlockEntity tile = this.getNeighbor(side);
            if (connected && tile instanceof IPipeNode && (pipeTile = (IPipeNode)tile).getPipeType().getClass() != this.getPipeType().getClass()) {
                return;
            }
            this.connections = this.withSideConnection(this.connections, side, connected);
            this.updateNetworkConnection(side, connected);
            this.m_6596_();
            if (!fromNeighbor && tile instanceof IPipeNode) {
                pipeTile = (IPipeNode)tile;
                this.syncPipeConnections(side, pipeTile);
            }
        }
    }

    private void syncPipeConnections(Direction side, IPipeNode<?, ?> pipe) {
        Direction oppositeSide = side.m_122424_();
        boolean neighbourOpen = pipe.isConnected(oppositeSide);
        if (this.isConnected(side) == neighbourOpen) {
            return;
        }
        if (!neighbourOpen || pipe.getCoverContainer().getCoverAtSide(oppositeSide) == null) {
            pipe.setConnection(oppositeSide, !neighbourOpen, true);
        }
    }

    private void updateNetworkConnection(Direction side, boolean connected) {
        Object worldPipeNet = this.getPipeBlock().getWorldPipeNet((ServerLevel)this.m_58904_());
        ((LevelPipeNet)((Object)worldPipeNet)).updateBlockedConnections(this.getPipePos(), side, !connected);
    }

    protected int withSideConnection(int blockedConnections, Direction side, boolean connected) {
        int index = 1 << side.ordinal();
        if (connected) {
            return blockedConnections | index;
        }
        return blockedConnections & ~index;
    }

    @Override
    public void notifyBlockUpdate() {
        this.m_58904_().m_46672_(this.m_58899_(), (Block)this.getPipeBlock());
        this.getPipeBlock().updateActiveNodeStatus(this.m_58904_(), this.m_58899_(), this);
    }

    public boolean m_7531_(int id, int para) {
        if (id == 1) {
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRenderGrid(Player player, ItemStack held, Set<GTToolType> toolTypes) {
        if (toolTypes.contains(this.getPipeTuneTool()) || toolTypes.contains(GTToolType.SCREWDRIVER)) {
            return true;
        }
        for (CoverBehavior cover : this.coverContainer.getCovers()) {
            if (!cover.shouldRenderGrid(player, held, toolTypes)) continue;
            return true;
        }
        return false;
    }

    public ResourceTexture getPipeTexture(boolean isBlock) {
        return isBlock ? GuiTextures.TOOL_PIPE_CONNECT : GuiTextures.TOOL_PIPE_BLOCK;
    }

    @Override
    public ResourceTexture sideTips(Player player, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(this.getPipeTuneTool())) {
            if (player.m_6144_() && this.canHaveBlockedFaces()) {
                return this.getPipeTexture(this.isBlocked(side));
            }
            return this.getPipeTexture(this.isConnected(side));
        }
        CoverBehavior cover = this.coverContainer.getCoverAtSide(side);
        if (cover != null) {
            return cover.sideTips(player, toolTypes, side);
        }
        return null;
    }

    @Override
    public Pair<GTToolType, InteractionResult> onToolClick(Set<GTToolType> toolTypes, ItemStack itemStack, UseOnContext context) {
        CoverBehavior coverBehavior;
        Player playerIn = context.m_43723_();
        if (playerIn == null) {
            return Pair.of(null, (Object)InteractionResult.PASS);
        }
        InteractionHand hand = context.m_43724_();
        BlockHitResult hitResult = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false);
        Direction gridSide = ICoverable.determineGridSideHit(hitResult);
        CoverBehavior coverBehavior2 = coverBehavior = gridSide == null ? null : this.coverContainer.getCoverAtSide(gridSide);
        if (gridSide == null) {
            gridSide = hitResult.m_82434_();
        }
        if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)coverBehavior.onSoftMalletClick(playerIn, hand, hitResult));
            }
        } else {
            if (toolTypes.contains(this.getPipeTuneTool())) {
                if (playerIn.m_6144_() && this.canHaveBlockedFaces()) {
                    boolean isBlocked = this.isBlocked(gridSide);
                    this.setBlocked(gridSide, !isBlocked);
                } else {
                    boolean isOpen = this.isConnected(gridSide);
                    this.setConnection(gridSide, !isOpen, false);
                }
                return Pair.of((Object)this.getPipeTuneTool(), (Object)InteractionResult.CONSUME);
            }
            if (toolTypes.contains(GTToolType.CROWBAR) && coverBehavior != null) {
                if (!this.isRemote()) {
                    this.getCoverContainer().removeCover(gridSide, playerIn);
                }
                return Pair.of((Object)GTToolType.CROWBAR, (Object)InteractionResult.CONSUME);
            }
        }
        return Pair.of(null, (Object)InteractionResult.PASS);
    }

    public GTToolType getPipeTuneTool() {
        return GTToolType.WRENCH;
    }

    @Override
    public int getDefaultPaintingColor() {
        int n;
        PipeBlock pipeBlock = this.getPipeBlock();
        if (pipeBlock instanceof MaterialPipeBlock) {
            MaterialPipeBlock materialPipeBlock = (MaterialPipeBlock)pipeBlock;
            n = materialPipeBlock.material.getMaterialRGB();
        } else {
            n = IPipeNode.super.getDefaultPaintingColor();
        }
        return n;
    }

    @Override
    @Nullable
    public Material getFrameMaterial() {
        return this.frameMaterial == null ? null : GTCEuAPI.materialManager.getMaterial(this.frameMaterial);
    }

    public void doExplosion(float explosionPower) {
        this.m_58904_().m_7471_(this.getPipePos(), false);
        if (!this.m_58904_().f_46443_) {
            ((ServerLevel)this.m_58904_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)this.getPipePos().m_123341_() + 0.5, (double)this.getPipePos().m_123342_() + 0.5, (double)this.getPipePos().m_123343_() + 0.5, 10, 0.2, 0.2, 0.2, 0.0);
        }
        this.m_58904_().m_254849_(null, (double)this.getPipePos().m_123341_() + 0.5, (double)this.getPipePos().m_123342_() + 0.5, (double)this.getPipePos().m_123343_() + 0.5, explosionPower, Level.ExplosionInteraction.NONE);
    }

    public static boolean isFaceBlocked(int blockedConnections, Direction side) {
        return (blockedConnections & 1 << side.ordinal()) > 0;
    }

    public static boolean isConnected(int connections, Direction side) {
        return (connections & 1 << side.ordinal()) > 0;
    }

    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    @Override
    public PipeCoverContainer getCoverContainer() {
        return this.coverContainer;
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    @Override
    public void setConnections(int connections) {
        this.connections = connections;
    }

    public void setBlockedConnections(int blockedConnections) {
        this.blockedConnections = blockedConnections;
    }

    @Override
    public int getPaintingColor() {
        return this.paintingColor;
    }

    @Override
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
    }
}

