/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability;

import com.gregtechceu.gtceu.api.block.IAppearance;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public interface ICoverable
extends ITickSubscription,
IAppearance {
    public Level getLevel();

    public BlockPos getPos();

    public long getOffsetTimer();

    public void markDirty();

    public boolean isInValid();

    public void notifyBlockUpdate();

    public void scheduleRenderUpdate();

    public void scheduleNeighborShapeUpdate();

    public boolean canPlaceCoverOnSide(CoverDefinition var1, Direction var2);

    public double getCoverPlateThickness();

    public Direction getFrontFacing();

    public boolean shouldRenderBackSide();

    public IItemTransfer getItemTransferCap(@Nullable Direction var1, boolean var2);

    public IFluidTransfer getFluidTransferCap(@Nullable Direction var1, boolean var2);

    public void setCoverAtSide(@Nullable CoverBehavior var1, Direction var2);

    @Nullable
    public CoverBehavior getCoverAtSide(Direction var1);

    default public boolean placeCoverOnSide(Direction side, ItemStack itemStack, CoverDefinition coverDefinition, ServerPlayer player) {
        CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, side);
        if (!this.canPlaceCoverOnSide(coverDefinition, side) || !coverBehavior.canAttach()) {
            return false;
        }
        if (this.getCoverAtSide(side) != null) {
            this.removeCover(side, (Player)player);
        }
        coverBehavior.onAttached(itemStack, player);
        coverBehavior.onLoad();
        this.setCoverAtSide(coverBehavior, side);
        this.notifyBlockUpdate();
        this.markDirty();
        this.scheduleNeighborShapeUpdate();
        return true;
    }

    default public boolean removeCover(boolean dropItself, Direction side, @Nullable Player player) {
        CoverBehavior coverBehavior = this.getCoverAtSide(side);
        if (coverBehavior == null) {
            return false;
        }
        List<ItemStack> drops = coverBehavior.getAdditionalDrops();
        if (dropItself) {
            drops.add(coverBehavior.getPickItem());
        }
        coverBehavior.onRemoved();
        this.setCoverAtSide(null, side);
        for (ItemStack dropStack : drops) {
            if (player != null && player.m_150109_().m_36054_(dropStack)) continue;
            Block.m_49840_((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)dropStack);
        }
        this.notifyBlockUpdate();
        this.markDirty();
        this.scheduleNeighborShapeUpdate();
        return true;
    }

    default public void dropAllCovers() {
        for (Direction side : GTUtil.DIRECTIONS) {
            this.removeCover(side, null);
        }
    }

    default public boolean removeCover(Direction side, @Nullable Player player) {
        return this.removeCover(true, side, player);
    }

    default public List<CoverBehavior> getCovers() {
        return Arrays.stream(GTUtil.DIRECTIONS).map(this::getCoverAtSide).filter(Objects::nonNull).collect(Collectors.toList());
    }

    default public void onLoad() {
        for (CoverBehavior cover : this.getCovers()) {
            cover.onLoad();
        }
    }

    default public void onUnload() {
        for (CoverBehavior cover : this.getCovers()) {
            cover.onUnload();
        }
    }

    default public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        for (CoverBehavior cover : this.getCovers()) {
            cover.onNeighborChanged(block, fromPos, isMoving);
        }
    }

    default public boolean hasAnyCover() {
        for (Direction facing : GTUtil.DIRECTIONS) {
            if (this.getCoverAtSide(facing) == null) continue;
            return true;
        }
        return false;
    }

    default public boolean hasCover(Direction facing) {
        return this.getCoverAtSide(facing) != null;
    }

    default public boolean isRemote() {
        return this.getLevel() == null ? LDLib.isRemote() : this.getLevel().f_46443_;
    }

    default public VoxelShape[] addCoverCollisionBoundingBox() {
        double plateThickness = this.getCoverPlateThickness();
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        if (plateThickness > 0.0) {
            for (Direction side : GTUtil.DIRECTIONS) {
                if (this.getCoverAtSide(side) == null) continue;
                VoxelShape coverBox = ICoverable.getCoverPlateBox(side, plateThickness);
                shapes.add(coverBox);
            }
        }
        return (VoxelShape[])shapes.toArray(VoxelShape[]::new);
    }

    public static boolean doesCoverCollide(Direction side, List<VoxelShape> collisionBox, double plateThickness) {
        if (side == null) {
            return false;
        }
        if (plateThickness > 0.0) {
            VoxelShape coverPlateBox = ICoverable.getCoverPlateBox(side, plateThickness);
            List aabbs = coverPlateBox.m_83299_();
            for (AABB aabb : aabbs) {
                if (!(Shapes.m_193135_((Direction.Axis)side.m_122434_(), (AABB)aabb, collisionBox, (double)plateThickness) < plateThickness)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Direction rayTraceCoverableSide(ICoverable coverable, Player player) {
        BlockHitResult rayTrace = (BlockHitResult)player.m_19907_(player.getBlockReach(), 0.0f, false);
        if (rayTrace.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        return ICoverable.traceCoverSide(rayTrace);
    }

    @Nullable
    public static Direction traceCoverSide(BlockHitResult result) {
        return ICoverable.determineGridSideHit(result);
    }

    @Nullable
    public static Direction determineGridSideHit(BlockHitResult result) {
        return GTUtil.determineWrenchingSide(result.m_82434_(), (float)(result.m_82450_().f_82479_ - (double)result.m_82425_().m_123341_()), (float)(result.m_82450_().f_82480_ - (double)result.m_82425_().m_123342_()), (float)(result.m_82450_().f_82481_ - (double)result.m_82425_().m_123343_()));
    }

    public static VoxelShape getCoverPlateBox(Direction side, double plateThickness) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Shapes.m_83048_((double)0.0, (double)(1.0 - plateThickness), (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            case Direction.DOWN -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)plateThickness, (double)1.0);
            case Direction.NORTH -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)plateThickness);
            case Direction.SOUTH -> Shapes.m_83048_((double)0.0, (double)0.0, (double)(1.0 - plateThickness), (double)1.0, (double)1.0, (double)1.0);
            case Direction.WEST -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)plateThickness, (double)1.0, (double)1.0);
            case Direction.EAST -> Shapes.m_83048_((double)(1.0 - plateThickness), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        };
    }

    public static boolean canPlaceCover(CoverDefinition coverDef, ICoverable coverable) {
        for (Direction facing : GTUtil.DIRECTIONS) {
            CoverBehavior cover;
            if (!coverable.canPlaceCoverOnSide(coverDef, facing) || !(cover = coverDef.createCoverBehavior(coverable, facing)).canAttach()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    default public BlockState getBlockAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState sourceState, BlockPos sourcePos) {
        if (this.hasCover(side)) {
            return this.getCoverAtSide(side).getAppearance(sourceState, sourcePos);
        }
        return null;
    }

    public static class PrimaryBoxData {
        public final boolean usePlacementGrid;

        public PrimaryBoxData(boolean usePlacementGrid) {
            this.usePlacementGrid = usePlacementGrid;
        }
    }
}

