/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapFluidTagIngredient;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class FluidRecipeCapability
extends RecipeCapability<FluidIngredient> {
    public static final FluidRecipeCapability CAP = new FluidRecipeCapability();

    protected FluidRecipeCapability() {
        super("fluid", -12816146, SerializerFluidIngredient.INSTANCE);
    }

    @Override
    public FluidIngredient copyInner(FluidIngredient content) {
        return content.copy();
    }

    @Override
    public FluidIngredient copyWithModifier(FluidIngredient content, ContentModifier modifier) {
        if (content.isEmpty()) {
            return content.copy();
        }
        FluidIngredient copy = content.copy();
        copy.setAmount(modifier.apply(copy.getAmount()).intValue());
        return copy;
    }

    @Override
    public List<AbstractMapIngredient> convertToMapIngredient(Object obj) {
        ObjectArrayList ingredients = new ObjectArrayList(1);
        if (obj instanceof FluidIngredient) {
            FluidIngredient ingredient = (FluidIngredient)obj;
            for (FluidIngredient.Value value : ingredient.values) {
                if (value instanceof FluidIngredient.TagValue) {
                    FluidIngredient.TagValue tagValue = (FluidIngredient.TagValue)value;
                    ingredients.add(new MapFluidTagIngredient(tagValue.getTag()));
                    continue;
                }
                Collection<Fluid> fluids = value.getFluids();
                for (Fluid fluid : fluids) {
                    ingredients.add(new MapFluidIngredient(FluidStack.create((Fluid)fluid, (long)ingredient.getAmount(), (CompoundTag)ingredient.getNbt())));
                }
            }
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            ingredients.add(new MapFluidIngredient(stack));
            stack.getFluid().m_205069_().m_203616_().forEach(arg_0 -> FluidRecipeCapability.lambda$convertToMapIngredient$0((List)ingredients, arg_0));
        }
        return ingredients;
    }

    @Override
    public List<Object> compressIngredients(Collection<Object> ingredients) {
        ObjectArrayList list = new ObjectArrayList(ingredients.size());
        for (Object item : ingredients) {
            FluidIngredient fluidIngredient;
            boolean isEqual;
            if (item instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)item;
                isEqual = false;
                for (Object obj : list) {
                    FluidStack fluidStack;
                    if (obj instanceof FluidIngredient) {
                        fluidIngredient = (FluidIngredient)obj;
                        if (!fluid.equals(fluidIngredient)) continue;
                        isEqual = true;
                        break;
                    }
                    if (!(obj instanceof FluidStack) || !fluid.test(fluidStack = (FluidStack)obj)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                list.add(fluid);
                continue;
            }
            if (!(item instanceof FluidStack)) continue;
            FluidStack fluidStack = (FluidStack)item;
            isEqual = false;
            for (Object obj : list) {
                FluidStack stack;
                if (obj instanceof FluidIngredient) {
                    fluidIngredient = (FluidIngredient)obj;
                    if (!fluidIngredient.test(fluidStack)) continue;
                    isEqual = true;
                    break;
                }
                if (!(obj instanceof FluidStack) || !fluidStack.isFluidEqual(stack = (FluidStack)obj)) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            list.add(fluidStack);
        }
        return list;
    }

    @Override
    public boolean isRecipeSearchFilter() {
        return true;
    }

    private static /* synthetic */ void lambda$convertToMapIngredient$0(List ingredients, TagKey tag) {
        ingredients.add(new MapFluidTagIngredient((TagKey<Fluid>)tag));
    }
}

