/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapIntersectionIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackNBTIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemTagIngredient;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import com.gregtechceu.gtceu.utils.IngredientEquality;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public class ItemRecipeCapability
extends RecipeCapability<Ingredient> {
    public static final ItemRecipeCapability CAP = new ItemRecipeCapability();

    protected ItemRecipeCapability() {
        super("item", -2531066, SerializerIngredient.INSTANCE);
    }

    @Override
    public Ingredient copyInner(Ingredient content) {
        return SizedIngredient.copy(content);
    }

    @Override
    public Ingredient copyWithModifier(Ingredient content, ContentModifier modifier) {
        SizedIngredient sizedIngredient;
        if (content instanceof SizedIngredient) {
            SizedIngredient sizedIngredient2 = (SizedIngredient)content;
            sizedIngredient = SizedIngredient.create(sizedIngredient2.getInner(), modifier.apply(sizedIngredient2.getAmount()).intValue());
        } else {
            sizedIngredient = SizedIngredient.create(content, modifier.apply(1).intValue());
        }
        return sizedIngredient;
    }

    @Override
    public List<AbstractMapIngredient> convertToMapIngredient(Object obj) {
        ObjectArrayList ingredients = new ObjectArrayList(1);
        if (obj instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)obj;
            if (ingredient instanceof StrictNBTIngredient) {
                StrictNBTIngredient nbt = (StrictNBTIngredient)ingredient;
                ingredients.addAll(MapItemStackNBTIngredient.from(nbt));
            } else if (ingredient instanceof SizedIngredient) {
                SizedIngredient sized = (SizedIngredient)ingredient;
                Ingredient ingredient2 = sized.getInner();
                if (ingredient2 instanceof StrictNBTIngredient) {
                    StrictNBTIngredient nbt = (StrictNBTIngredient)ingredient2;
                    ingredients.addAll(MapItemStackNBTIngredient.from(nbt));
                } else {
                    ingredient2 = sized.getInner();
                    if (ingredient2 instanceof IntersectionIngredient) {
                        IntersectionIngredient intersection = (IntersectionIngredient)ingredient2;
                        ingredients.add(new MapIntersectionIngredient(intersection));
                    } else {
                        for (Ingredient.Value value : ((IngredientAccessor)sized.getInner()).getValues()) {
                            if (value instanceof Ingredient.TagValue) {
                                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                                ingredients.add(new MapItemTagIngredient(((TagValueAccessor)tagValue).getTag()));
                                continue;
                            }
                            Collection stacks = value.m_6223_();
                            for (ItemStack stack : stacks) {
                                ingredients.add(new MapItemStackIngredient(stack, sized.getInner()));
                            }
                        }
                    }
                }
            } else if (ingredient instanceof IntersectionIngredient) {
                IntersectionIngredient intersection = (IntersectionIngredient)ingredient;
                ingredients.add(new MapIntersectionIngredient(intersection));
            } else {
                for (Ingredient.Value value : ((IngredientAccessor)ingredient).getValues()) {
                    if (value instanceof Ingredient.TagValue) {
                        Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                        ingredients.add(new MapItemTagIngredient(((TagValueAccessor)tagValue).getTag()));
                        continue;
                    }
                    Collection stacks = value.m_6223_();
                    for (ItemStack stack : stacks) {
                        ingredients.add(new MapItemStackIngredient(stack, ingredient));
                    }
                }
            }
        } else if (obj instanceof ItemStack) {
            TagPrefix prefix;
            ItemStack stack = (ItemStack)obj;
            ingredients.add(new MapItemStackIngredient(stack));
            stack.m_204131_().forEach(arg_0 -> ItemRecipeCapability.lambda$convertToMapIngredient$0((List)ingredients, arg_0));
            if (stack.m_41782_()) {
                ingredients.add(new MapItemStackNBTIngredient(stack, StrictNBTIngredient.of((ItemStack)stack)));
            }
            if ((prefix = ChemicalHelper.getPrefix((ItemLike)stack.m_41720_())) != null && TagPrefix.ORES.containsKey(prefix)) {
                Material material = ChemicalHelper.getMaterial((ItemLike)stack.m_41720_()).material();
                ingredients.add(new MapIntersectionIngredient((IntersectionIngredient)IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(prefix.getItemTags(material)[0]), Ingredient.m_204132_(prefix.getItemParentTags()[0])})));
            }
        }
        return ingredients;
    }

    @Override
    public List<Object> compressIngredients(Collection<Object> ingredients) {
        ObjectArrayList list = new ObjectArrayList(ingredients.size());
        for (Object item : ingredients) {
            boolean isEqual;
            if (item instanceof Ingredient) {
                SizedIngredient sized;
                Ingredient ingredient = (Ingredient)item;
                isEqual = false;
                for (Object obj : list) {
                    ItemStack stack;
                    if (obj instanceof Ingredient) {
                        Ingredient ingredient1 = (Ingredient)obj;
                        if (!IngredientEquality.ingredientEquals(ingredient, ingredient1)) continue;
                        isEqual = true;
                        break;
                    }
                    if (!(obj instanceof ItemStack) || !ingredient.test(stack = (ItemStack)obj)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                if (ingredient instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                if (ingredient instanceof SizedIngredient && (sized = (SizedIngredient)ingredient).getInner() instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                list.add(ingredient);
                continue;
            }
            if (!(item instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)item;
            isEqual = false;
            for (Object obj : list) {
                ItemStack stack1;
                if (obj instanceof Ingredient) {
                    Ingredient ingredient = (Ingredient)obj;
                    if (!ingredient.test(stack)) continue;
                    isEqual = true;
                    break;
                }
                if (!(obj instanceof ItemStack) || !ItemStack.m_41656_((ItemStack)stack, (ItemStack)(stack1 = (ItemStack)obj))) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            list.add(stack);
        }
        return list;
    }

    @Override
    public boolean isRecipeSearchFilter() {
        return true;
    }

    private static /* synthetic */ void lambda$convertToMapIngredient$0(List ingredients, TagKey tag) {
        ingredients.add(new MapItemTagIngredient((TagKey<Item>)tag));
    }
}

