/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public abstract class RecipeCapability<T> {
    public final String name;
    public final int color;
    public final IContentSerializer<T> serializer;

    protected RecipeCapability(String name, int color, IContentSerializer<T> serializer) {
        this.name = name;
        this.color = color;
        this.serializer = serializer;
    }

    public T copyInner(T content) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toNetwork(buf, content);
        return this.serializer.fromNetwork(buf);
    }

    public T copyWithModifier(T content, ContentModifier modifier) {
        return this.copyInner(content);
    }

    public final T copyContent(Object content) {
        return (T)this.copyInner(content);
    }

    public final T copyContent(Object content, ContentModifier modifier) {
        return (T)this.copyWithModifier(content, modifier);
    }

    public List<AbstractMapIngredient> convertToMapIngredient(Object ingredient) {
        return List.of();
    }

    public List<Object> compressIngredients(Collection<Object> ingredients) {
        return new ArrayList<Object>(ingredients);
    }

    public T of(Object o) {
        return this.serializer.of(o);
    }

    public String slotName(IO io) {
        return "%s_%s".formatted(this.name, io.name().toLowerCase(Locale.ROOT));
    }

    public String slotName(IO io, int index) {
        return "%s_%s_%s".formatted(this.name, io.name().toLowerCase(Locale.ROOT), index);
    }

    public Component getName() {
        return Component.m_237115_((String)"recipe.capability.%s.name".formatted(this.name));
    }

    public boolean isRecipeSearchFilter() {
        return false;
    }

    public boolean doAddGuiSlots() {
        return this.isRecipeSearchFilter();
    }

    public double calculateAmount(List<T> left) {
        return 1.0;
    }
}

