/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public abstract class VeinGenerator {
    public static final Codec<Codec<? extends VeinGenerator>> REGISTRY_CODEC = ResourceLocation.f_135803_.flatXmap(rl -> Optional.ofNullable((Codec)WorldGeneratorUtils.VEIN_GENERATORS.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No VeinGenerator with id " + rl + " registered")), obj -> Optional.ofNullable((ResourceLocation)WorldGeneratorUtils.VEIN_GENERATORS.inverse().get(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "VeinGenerator " + obj + " not registered")));
    public static final Codec<VeinGenerator> DIRECT_CODEC = REGISTRY_CODEC.dispatchStable(VeinGenerator::codec, Function.identity());
    protected GTOreDefinition entry;

    public VeinGenerator() {
    }

    public VeinGenerator(GTOreDefinition entry) {
        this.entry = entry;
    }

    public abstract List<Map.Entry<Either<BlockState, Material>, Integer>> getAllEntries();

    public List<BlockState> getAllBlocks() {
        return this.getAllEntries().stream().map(entry -> (BlockState)((Either)entry.getKey()).map(Function.identity(), material -> ChemicalHelper.getBlock(TagPrefix.ore, material).m_49966_())).toList();
    }

    public List<Material> getAllMaterials() {
        return this.getAllEntries().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).map(either -> (Material)either.map(state -> ChemicalHelper.getMaterial((ItemLike)state.m_60734_()) != null ? ChemicalHelper.getMaterial((ItemLike)state.m_60734_()).material() : null, Function.identity())).filter(Objects::nonNull).toList();
    }

    public List<Integer> getAllChances() {
        return this.getAllEntries().stream().map(Map.Entry::getValue).toList();
    }

    public List<Map.Entry<Integer, Material>> getValidMaterialsChances() {
        return this.getAllEntries().stream().filter(entry -> ((Either)entry.getKey()).map(state -> ChemicalHelper.getMaterial((ItemLike)state.m_60734_()) != null ? ChemicalHelper.getMaterial((ItemLike)state.m_60734_()).material() : null, Function.identity()) != null).map(entry -> Map.entry((Integer)entry.getValue(), (Material)((Either)entry.getKey()).map(state -> ChemicalHelper.getMaterial((ItemLike)state.m_60734_()) != null ? ChemicalHelper.getMaterial((ItemLike)state.m_60734_()).material() : null, Function.identity()))).collect(Collectors.toList());
    }

    @HideFromJS
    public abstract Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel var1, RandomSource var2, GTOreDefinition var3, BlockPos var4);

    @HideFromJS
    public abstract VeinGenerator build();

    public abstract VeinGenerator copy();

    @HideFromJS
    public GTOreDefinition parent() {
        return this.entry;
    }

    public abstract Codec<? extends VeinGenerator> codec();
}

