/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedIndicators;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreIndicatorPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class OreGenerator {
    public List<GeneratedVeinMetadata> generateMetadata(WorldGenLevel level, ChunkGenerator chunkGenerator, ChunkPos chunkPos) {
        return this.createConfigs(level, chunkGenerator, chunkPos).stream().map(OreGenerator::logVeinGeneration).map(entry -> entry.data).toList();
    }

    public List<GeneratedIndicators> generateIndicators(WorldGenLevel level, List<GeneratedVeinMetadata> metadata, ChunkPos chunkPos) {
        return metadata.stream().map(data -> new VeinConfiguration((GeneratedVeinMetadata)data, (RandomSource)new XoroshiroRandomSource(level.m_7328_() ^ chunkPos.m_45588_()))).map(config -> this.generateIndicators((VeinConfiguration)config, level, chunkPos)).toList();
    }

    private GeneratedIndicators generateIndicators(VeinConfiguration config, WorldGenLevel level, ChunkPos chunkPos) {
        GTOreDefinition definition = config.data.definition();
        Map<ChunkPos, List<OreIndicatorPlacer>> generatedIndicators = definition.indicatorGenerators().stream().flatMap(gen -> gen.generate(level, config.newRandom(), config.data).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, entry -> List.of((OreIndicatorPlacer)entry.getValue()), (a, b) -> Stream.of(a, b).flatMap(Collection::stream).toList()));
        return new GeneratedIndicators(chunkPos, generatedIndicators);
    }

    public List<GeneratedVein> generateOres(WorldGenLevel level, List<GeneratedVeinMetadata> metadata, ChunkPos chunkPos) {
        return metadata.stream().map(data -> new VeinConfiguration((GeneratedVeinMetadata)data, (RandomSource)new XoroshiroRandomSource(level.m_7328_() ^ chunkPos.m_45588_()))).flatMap(config -> this.generateOres((VeinConfiguration)config, level, chunkPos).stream()).toList();
    }

    private Optional<GeneratedVein> generateOres(VeinConfiguration config, WorldGenLevel level, ChunkPos chunkPos) {
        GTOreDefinition definition = config.data.definition();
        Map<BlockPos, OreBlockPlacer> generatedVeins = definition.veinGenerator().generate(level, config.newRandom(), definition, config.data.center());
        if (generatedVeins.isEmpty()) {
            OreGenerator.logEmptyVein(config);
            return Optional.empty();
        }
        OreGenerator.generateBedrockOreVein(config, level);
        return Optional.of(new GeneratedVein(chunkPos, definition.layer(), generatedVeins));
    }

    private static void generateBedrockOreVein(VeinConfiguration config, WorldGenLevel level) {
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            BedrockOreVeinSavedData.getOrCreate(level.m_6018_()).createVein(new ChunkPos(config.data.center()), config.data.definition());
        }
    }

    private List<VeinConfiguration> createConfigs(WorldGenLevel level, ChunkGenerator generator, ChunkPos chunkPos) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(level.m_7328_() ^ chunkPos.m_45588_());
        return OreVeinUtil.getVeinCenter(chunkPos, (RandomSource)random).stream().flatMap(veinCenter -> this.getEntries(level, (BlockPos)veinCenter, random).map(entry -> {
            ResourceLocation id = (ResourceLocation)GTRegistries.ORE_VEINS.getKey((GTOreDefinition)entry);
            if (entry == null) {
                return null;
            }
            BlockPos origin = OreGenerator.computeVeinOrigin(level, generator, (RandomSource)random, veinCenter, entry).orElseThrow(() -> new IllegalStateException("Cannot determine y coordinate for the vein at " + veinCenter));
            return new VeinConfiguration(new GeneratedVeinMetadata(id, chunkPos, origin, (GTOreDefinition)entry), (RandomSource)random);
        })).toList();
    }

    private Stream<GTOreDefinition> getEntries(WorldGenLevel level, BlockPos veinCenter, XoroshiroRandomSource random) {
        return WorldGeneratorUtils.WORLD_GEN_LAYERS.values().stream().filter(layer -> layer.isApplicableForLevel(level.m_6018_().m_46472_().m_135782_())).map(layer -> this.getEntry(level, (Holder<Biome>)level.m_204166_(veinCenter), (RandomSource)random, (IWorldGenLayer)layer)).filter(Objects::nonNull);
    }

    @Nullable
    private GTOreDefinition getEntry(WorldGenLevel level, Holder<Biome> biome, RandomSource random, IWorldGenLayer layer) {
        List<Map.Entry> veins = WorldGeneratorUtils.getCachedBiomeVeins(level.m_6018_(), biome, random).stream().filter(vein -> ((GTOreDefinition)vein.getValue()).layer().equals(layer)).toList();
        int randomEntryIndex = GTUtil.getRandomItem(random, veins, veins.size());
        return randomEntryIndex == -1 ? null : (GTOreDefinition)veins.get(randomEntryIndex).getValue();
    }

    @NotNull
    private static Optional<BlockPos> computeVeinOrigin(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos veinCenter, GTOreDefinition entry) {
        int layerSeed = WorldGeneratorUtils.getWorldGenLayerKey(entry.layer()).map(String::hashCode).orElse(0);
        XoroshiroRandomSource layeredRandom = new XoroshiroRandomSource(random.m_188505_() ^ (long)layerSeed);
        return entry.range().m_213676_(new PlacementContext(level, generator, Optional.empty()), (RandomSource)layeredRandom, veinCenter).findFirst();
    }

    private static VeinConfiguration logVeinGeneration(VeinConfiguration config) {
        if (ConfigHolder.INSTANCE.dev.debugWorldgen) {
            GTCEu.LOGGER.debug("Generating vein " + config.data.id() + " at " + config.data.center());
        }
        return config;
    }

    private static void logEmptyVein(VeinConfiguration config) {
        if (ConfigHolder.INSTANCE.dev.debugWorldgen) {
            GTCEu.LOGGER.debug("No blocks generated for vein " + config.data.id() + " at " + config.data.center());
        }
    }

    private record VeinConfiguration(GeneratedVeinMetadata data, RandomSource random) {
        public RandomSource newRandom() {
            return new XoroshiroRandomSource(this.random.m_188505_());
        }
    }
}

