/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids.store;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FluidStorage {
    private final Map<FluidStorageKey, FluidEntry> map = new Object2ObjectOpenHashMap();
    private Map<FluidStorageKey, FluidBuilder> toRegister = new Object2ObjectOpenHashMap();
    private boolean registered = false;

    public void enqueueRegistration(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
        if (this.registered) {
            throw new IllegalStateException("Cannot enqueue a builder after registration");
        }
        if (this.toRegister.containsKey(key)) {
            throw new IllegalArgumentException("FluidStorageKey " + key + " is already queued");
        }
        this.toRegister.put(key, builder);
    }

    @Nullable
    public FluidBuilder getQueuedBuilder(@NotNull FluidStorageKey key) {
        if (this.registered) {
            throw new IllegalArgumentException("FluidStorage has already been registered");
        }
        return this.toRegister.get(key);
    }

    @ApiStatus.Internal
    public void registerFluids(@NotNull Material material, GTRegistrate registrate) {
        if (this.registered) {
            throw new IllegalStateException("FluidStorage has already been registered");
        }
        if (this.toRegister.isEmpty() && this.map.isEmpty()) {
            this.enqueueRegistration(FluidStorageKeys.LIQUID, new FluidBuilder());
        }
        this.toRegister.entrySet().stream().sorted(Comparator.comparingInt(e -> -((FluidStorageKey)e.getKey()).getRegistrationPriority())).forEach(entry -> {
            if (this.map.containsKey(entry.getKey())) {
                GTCEu.LOGGER.warn("{} already has an associated fluid for material {}", entry.getKey(), (Object)material);
                return;
            }
            Supplier<? extends Fluid> fluid = ((FluidBuilder)entry.getValue()).build(material.getModid(), material, (FluidStorageKey)entry.getKey(), registrate);
            this.store((FluidStorageKey)entry.getKey(), fluid, (FluidBuilder)entry.getValue());
        });
        this.toRegister = null;
        this.registered = true;
    }

    @Nullable
    public Fluid get(@NotNull FluidStorageKey key) {
        return this.map.containsKey(key) ? this.map.get(key).getFluid().get() : null;
    }

    @Nullable
    public FluidEntry getEntry(@NotNull FluidStorageKey key) {
        return this.map.getOrDefault(key, null);
    }

    public boolean storeNoOverwrites(@NotNull FluidStorageKey key, @NotNull Supplier<? extends Fluid> fluid, @Nullable FluidBuilder builder) {
        if (this.map.containsKey(key)) {
            return false;
        }
        this.store(key, fluid, builder);
        return true;
    }

    public void store(@NotNull FluidStorageKey key, @NotNull Supplier<? extends Fluid> fluid, @Nullable FluidBuilder builder) {
        if (this.map.containsKey(key)) {
            throw new IllegalArgumentException(key + " already has an associated fluid");
        }
        if (builder != null) {
            this.map.put(key, new FluidEntry(fluid, builder));
        } else {
            this.map.put(key, new FluidEntry(fluid, null));
        }
    }

    public static class FluidEntry {
        private Supplier<? extends Fluid> fluid;
        @Nullable
        private FluidBuilder builder;

        public FluidEntry(Supplier<? extends Fluid> fluid, @Nullable FluidBuilder builder) {
            this.fluid = fluid;
            this.builder = builder;
        }

        public Supplier<? extends Fluid> getFluid() {
            return this.fluid;
        }

        @Nullable
        public FluidBuilder getBuilder() {
            return this.builder;
        }

        public void setBuilder(@Nullable FluidBuilder builder) {
            this.builder = builder;
        }
    }
}

