/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import javax.annotation.Nonnull;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MaterialBlockItem
extends BlockItem
implements IItemRendererProvider {
    protected MaterialBlockItem(MaterialBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public static MaterialBlockItem create(MaterialBlock block, Item.Properties properties) {
        return new MaterialBlockItem(block, properties);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.getItemBurnTime();
    }

    public void onRegister() {
    }

    @Nonnull
    public MaterialBlock getBlock() {
        return (MaterialBlock)super.m_40614_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintColor() {
        return (itemStack, index) -> {
            Item patt1810$temp = itemStack.m_41720_();
            if (patt1810$temp instanceof MaterialBlockItem) {
                MaterialBlockItem materialBlockItem = (MaterialBlockItem)patt1810$temp;
                return materialBlockItem.getBlock().material.getLayerARGB(index);
            }
            return -1;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public IRenderer getRenderer(ItemStack stack) {
        MaterialBlock materialBlock = this.getBlock();
        if (materialBlock instanceof IBlockRendererProvider) {
            IBlockRendererProvider provider = (IBlockRendererProvider)materialBlock;
            return provider.getRenderer(this.getBlock().m_49966_());
        }
        return null;
    }

    public String m_5524_() {
        return this.getBlock().m_7705_();
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public Component m_41466_() {
        return this.getBlock().m_49954_();
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    public int getItemBurnTime() {
        DustProperty property;
        Material material = this.getBlock().material;
        DustProperty dustProperty = property = material == null ? null : material.getProperty(PropertyKey.DUST);
        if (property != null) {
            return (int)((long)property.getBurnTime() * this.getBlock().tagPrefix.getMaterialAmount(material) / 3628800L);
        }
        return -1;
    }
}

