/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PipeBlockItem
extends BlockItem {
    public PipeBlockItem(PipeBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public PipeBlock getBlock() {
        return (PipeBlock)super.m_40614_();
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        boolean superVal;
        Direction sideAttach;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        BlockPos realPos = pos.m_121945_(side.m_122424_());
        IPipeNode baseNode = this.getBlock().getPipeTile((BlockGetter)level, realPos);
        if (baseNode != null && (sideAttach = ICoverable.traceCoverSide(new BlockHitResult(context.m_43720_(), side, realPos, false))) != null && context.m_43725_().m_46859_(realPos.m_121945_(sideAttach))) {
            pos = realPos.m_121945_(sideAttach);
            side = sideAttach;
            context = new BlockPlaceContext(level, context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), sideAttach, realPos, false));
        }
        if ((superVal = super.m_7429_(context, state)) && !level.f_46443_) {
            IPipeNode selfTile = this.getBlock().getPipeTile((BlockGetter)level, pos);
            if (selfTile == null) {
                return true;
            }
            if (selfTile.getPipeBlock().canConnect(selfTile, side.m_122424_())) {
                selfTile.setConnection(side.m_122424_(), true, false);
            }
            for (Direction facing : GTUtil.DIRECTIONS) {
                BlockEntity te = selfTile.getNeighbor(facing);
                if (te instanceof IPipeNode) {
                    IPipeNode otherPipe = (IPipeNode)te;
                    if (!otherPipe.isConnected(facing.m_122424_())) continue;
                    if (otherPipe.getPipeBlock().canPipesConnect(otherPipe, facing.m_122424_(), selfTile)) {
                        selfTile.setConnection(facing, true, true);
                        continue;
                    }
                    otherPipe.setConnection(facing.m_122424_(), false, true);
                    continue;
                }
                if (ConfigHolder.INSTANCE.machines.gt6StylePipesCables || !selfTile.getPipeBlock().canPipeConnectToBlock(selfTile, facing, te)) continue;
                selfTile.setConnection(facing, true, false);
            }
        }
        return superVal;
    }
}

