/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;

public class MultiblockMachineDefinition
extends MachineDefinition {
    @NonNull
    private Supplier<BlockPattern> patternFactory;
    private Supplier<List<MultiblockShapeInfo>> shapes;
    @Nullable
    private Supplier<ItemStack[]> recoveryItems;
    private Comparator<IMultiPart> partSorter;
    private TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance;
    private BiConsumer<IMultiController, List<Component>> additionalDisplay;

    protected MultiblockMachineDefinition(ResourceLocation id) {
        super(id);
    }

    public static MultiblockMachineDefinition createDefinition(ResourceLocation id) {
        return new MultiblockMachineDefinition(id);
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        List<MultiblockShapeInfo> designs = this.shapes.get();
        if (!designs.isEmpty()) {
            return designs;
        }
        BlockPattern structurePattern = this.patternFactory.get();
        int[][] aisleRepetitions = structurePattern.aisleRepetitions;
        return this.repetitionDFS(structurePattern, new ArrayList<MultiblockShapeInfo>(), aisleRepetitions, new Stack<Integer>());
    }

    private List<MultiblockShapeInfo> repetitionDFS(BlockPattern pattern, List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, Stack<Integer> repetitionStack) {
        if (repetitionStack.size() == aisleRepetitions.length) {
            int[] repetition = new int[repetitionStack.size()];
            for (int i = 0; i < repetitionStack.size(); ++i) {
                repetition[i] = (Integer)repetitionStack.get(i);
            }
            pages.add(new MultiblockShapeInfo(pattern.getPreview(repetition)));
        } else {
            for (int i = aisleRepetitions[repetitionStack.size()][0]; i <= aisleRepetitions[repetitionStack.size()][1]; ++i) {
                repetitionStack.push(i);
                this.repetitionDFS(pattern, pages, aisleRepetitions, repetitionStack);
                repetitionStack.pop();
            }
        }
        return pages;
    }

    public void setPatternFactory(@NonNull Supplier<BlockPattern> patternFactory) {
        if (patternFactory == null) {
            throw new NullPointerException("patternFactory is marked non-null but is null");
        }
        this.patternFactory = patternFactory;
    }

    @NonNull
    public Supplier<BlockPattern> getPatternFactory() {
        return this.patternFactory;
    }

    public void setShapes(Supplier<List<MultiblockShapeInfo>> shapes) {
        this.shapes = shapes;
    }

    public Supplier<List<MultiblockShapeInfo>> getShapes() {
        return this.shapes;
    }

    public void setRecoveryItems(@Nullable Supplier<ItemStack[]> recoveryItems) {
        this.recoveryItems = recoveryItems;
    }

    @Nullable
    public Supplier<ItemStack[]> getRecoveryItems() {
        return this.recoveryItems;
    }

    public void setPartSorter(Comparator<IMultiPart> partSorter) {
        this.partSorter = partSorter;
    }

    public Comparator<IMultiPart> getPartSorter() {
        return this.partSorter;
    }

    public TriFunction<IMultiController, IMultiPart, Direction, BlockState> getPartAppearance() {
        return this.partAppearance;
    }

    public void setPartAppearance(TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance) {
        this.partAppearance = partAppearance;
    }

    public BiConsumer<IMultiController, List<Component>> getAdditionalDisplay() {
        return this.additionalDisplay;
    }

    public void setAdditionalDisplay(BiConsumer<IMultiController, List<Component>> additionalDisplay) {
        this.additionalDisplay = additionalDisplay;
    }
}

