/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public interface IMufflerMachine
extends IMultiPart {
    public void recoverItemsTable(ItemStack ... var1);

    default public boolean isFrontFaceFree() {
        BlockPos frontPos = this.self().getPos().m_121945_(this.self().getFrontFacing());
        return this.self().getLevel().m_8055_(frontPos).m_60795_();
    }

    default public void emitPollutionParticles() {
        float zSpd;
        float xSpd;
        BlockPos pos = this.self().getPos();
        Direction facing = this.self().getFrontFacing();
        float xPos = (float)facing.m_122429_() * 0.76f + (float)pos.m_123341_() + 0.25f;
        float yPos = (float)facing.m_122430_() * 0.76f + (float)pos.m_123342_() + 0.25f;
        float zPos = (float)facing.m_122431_() * 0.76f + (float)pos.m_123343_() + 0.25f;
        float ySpd = (float)facing.m_122430_() * 0.1f + 0.2f + 0.1f * GTValues.RNG.m_188501_();
        if (facing.m_122430_() == -1) {
            float temp = GTValues.RNG.m_188501_() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
        } else {
            xSpd = (float)facing.m_122429_() * (0.1f + 0.2f * GTValues.RNG.m_188501_());
            zSpd = (float)facing.m_122431_() * (0.1f + 0.2f * GTValues.RNG.m_188501_());
        }
        this.self().getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)(xPos + GTValues.RNG.m_188501_() * 0.5f), (double)(yPos + GTValues.RNG.m_188501_() * 0.5f), (double)(zPos + GTValues.RNG.m_188501_() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
    }

    @Override
    default public GTRecipe modifyRecipe(GTRecipe recipe) {
        if (!this.isFrontFaceFree()) {
            return null;
        }
        return IMultiPart.super.modifyRecipe(recipe);
    }

    @Override
    default public void afterWorking(IWorkableMultiController controller) {
        Supplier<ItemStack[]> supplier = controller.self().getDefinition().getRecoveryItems();
        if (supplier != null) {
            this.recoverItemsTable(supplier.get());
        }
    }

    @Override
    default public void attachFancyTooltipsToController(IMultiController controller, TooltipsPanel tooltipsPanel) {
        this.attachTooltips(tooltipsPanel);
    }

    @Override
    default public void attachTooltips(TooltipsPanel tooltipsPanel) {
        tooltipsPanel.attachTooltips(new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(Component.m_237115_((String)"gtceu.multiblock.universal.muffler_obstructed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))), () -> !this.isFrontFaceFree(), () -> null));
    }
}

