/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.lowdragmc.lowdraglib.misc.FluidTransferList;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class IOFluidTransferList
extends FluidTransferList {
    private final IO io;

    public IOFluidTransferList(List<IFluidTransfer> transfers, IO io, Predicate<FluidStack> filter) {
        super(transfers);
        this.io = io;
        this.setFilter(filter);
    }

    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (this.io != IO.IN && this.io != IO.BOTH) {
            return 0L;
        }
        return super.fill(tank, resource, simulate, notifyChanges);
    }

    public long fill(FluidStack resource, boolean simulate, boolean notifyChanged) {
        if (this.io != IO.IN && this.io != IO.BOTH) {
            return 0L;
        }
        return super.fill(resource, simulate, notifyChanged);
    }

    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (this.io != IO.OUT && this.io != IO.BOTH) {
            return FluidStack.empty();
        }
        return super.drain(tank, resource, simulate, notifyChanges);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate, boolean notifyChanged) {
        if (this.io != IO.OUT && this.io != IO.BOTH) {
            return FluidStack.empty();
        }
        return super.drain(resource, simulate, notifyChanged);
    }

    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate, boolean notifyChanged) {
        if (this.io != IO.OUT && this.io != IO.BOTH) {
            return FluidStack.empty();
        }
        return super.drain(maxDrain, simulate, notifyChanged);
    }

    public boolean supportsFill(int tank) {
        return this.io == IO.IN || this.io == IO.BOTH;
    }

    public boolean supportsDrain(int tank) {
        return this.io == IO.OUT || this.io == IO.BOTH;
    }

    public IO getIo() {
        return this.io;
    }
}

