/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.predicates.PredicateBlocks;
import com.gregtechceu.gtceu.api.pattern.predicates.PredicateFluids;
import com.gregtechceu.gtceu.api.pattern.predicates.PredicateStates;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.block.BatteryBlock;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.PowerSubstationMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.ArrayUtils;

public class Predicates {
    public static TraceabilityPredicate controller(TraceabilityPredicate predicate) {
        return predicate.setController();
    }

    public static TraceabilityPredicate states(BlockState ... allowedStates) {
        ArrayList<BlockState> candidates = new ArrayList<BlockState>();
        for (BlockState state : allowedStates) {
            ActiveBlock block;
            candidates.add(state);
            Block block2 = state.m_60734_();
            if (!(block2 instanceof ActiveBlock)) continue;
            candidates.add(block.changeActive(state, !(block = (ActiveBlock)block2).isActive(state)));
        }
        return new TraceabilityPredicate(new PredicateStates((BlockState[])candidates.toArray(BlockState[]::new)));
    }

    public static TraceabilityPredicate blocks(Block ... blocks) {
        return new TraceabilityPredicate(new PredicateBlocks(blocks));
    }

    public static TraceabilityPredicate blocks(IMachineBlock ... blocks) {
        return new TraceabilityPredicate(new PredicateBlocks((Block[])Arrays.stream(blocks).map(IMachineBlock::self).toArray(Block[]::new)));
    }

    public static TraceabilityPredicate fluids(Fluid ... fluids) {
        return new TraceabilityPredicate(new PredicateFluids(fluids));
    }

    public static TraceabilityPredicate custom(Predicate<MultiblockState> predicate, Supplier<BlockInfo[]> candidates) {
        return new TraceabilityPredicate(predicate, candidates);
    }

    public static TraceabilityPredicate any() {
        return new TraceabilityPredicate(SimplePredicate.ANY);
    }

    public static TraceabilityPredicate air() {
        return new TraceabilityPredicate(SimplePredicate.AIR);
    }

    public static TraceabilityPredicate abilities(PartAbility ... abilities) {
        return Predicates.blocks((Block[])Arrays.stream(abilities).map(PartAbility::getAllBlocks).flatMap(Collection::stream).toArray(Block[]::new));
    }

    public static TraceabilityPredicate ability(PartAbility ability, int ... tiers) {
        return Predicates.blocks((Block[])(tiers.length == 0 ? ability.getAllBlocks() : ability.getBlocks(tiers)).toArray(Block[]::new));
    }

    public static TraceabilityPredicate autoAbilities(GTRecipeType ... recipeType) {
        return Predicates.autoAbilities(recipeType, true, true, true, true, true, true);
    }

    public static TraceabilityPredicate autoAbilities(GTRecipeType[] recipeType, boolean checkEnergyIn, boolean checkEnergyOut, boolean checkItemIn, boolean checkItemOut, boolean checkFluidIn, boolean checkFluidOut) {
        TraceabilityPredicate predicate = new TraceabilityPredicate();
        if (checkEnergyIn) {
            for (GTRecipeType type : recipeType) {
                if (type.getMaxInputs(EURecipeCapability.CAP) <= 0) continue;
                predicate = predicate.or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMaxGlobalLimited(3).setPreviewCount(1));
                break;
            }
        }
        if (checkEnergyOut) {
            for (GTRecipeType type : recipeType) {
                if (type.getMaxOutputs(EURecipeCapability.CAP) <= 0) continue;
                predicate = predicate.or(Predicates.abilities(PartAbility.OUTPUT_ENERGY).setMaxGlobalLimited(3).setPreviewCount(1));
                break;
            }
        }
        if (checkItemIn) {
            for (GTRecipeType type : recipeType) {
                if (type.getMaxInputs(ItemRecipeCapability.CAP) <= 0) continue;
                predicate = predicate.or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setPreviewCount(1));
                break;
            }
        }
        if (checkItemOut) {
            for (GTRecipeType type : recipeType) {
                if (type.getMaxOutputs(ItemRecipeCapability.CAP) <= 0) continue;
                predicate = predicate.or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setPreviewCount(1));
                break;
            }
        }
        if (checkFluidIn) {
            for (GTRecipeType type : recipeType) {
                if (type.getMaxInputs(FluidRecipeCapability.CAP) <= 0) continue;
                predicate = predicate.or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setPreviewCount(1));
                break;
            }
        }
        if (checkFluidOut) {
            for (GTRecipeType type : recipeType) {
                if (type.getMaxOutputs(FluidRecipeCapability.CAP) <= 0) continue;
                predicate = predicate.or(Predicates.abilities(PartAbility.EXPORT_FLUIDS).setPreviewCount(1));
                break;
            }
        }
        return predicate;
    }

    public static TraceabilityPredicate autoAbilities(boolean checkMaintenance, boolean checkMuffler, boolean checkParallel) {
        TraceabilityPredicate predicate = new TraceabilityPredicate();
        if (checkMaintenance) {
            predicate = predicate.or(Predicates.abilities(PartAbility.MAINTENANCE).setMinGlobalLimited(ConfigHolder.INSTANCE.machines.enableMaintenance ? 1 : 0).setMaxGlobalLimited(1));
        }
        if (checkMuffler) {
            predicate = predicate.or(Predicates.abilities(PartAbility.MUFFLER).setMinGlobalLimited(1).setMaxGlobalLimited(1));
        }
        if (checkParallel) {
            predicate = predicate.or(Predicates.abilities(PartAbility.PARALLEL_HATCH).setMaxGlobalLimited(1).setPreviewCount(1));
        }
        return predicate;
    }

    public static TraceabilityPredicate heatingCoils() {
        return new TraceabilityPredicate(blockWorldState -> {
            BlockState blockState = blockWorldState.getBlockState();
            for (Map.Entry<ICoilType, Supplier<CoilBlock>> entry : GTBlocks.ALL_COILS.entrySet()) {
                if (!blockState.m_60713_((Block)entry.getValue().get())) continue;
                ICoilType stats = entry.getKey();
                ICoilType currentCoil = blockWorldState.getMatchContext().getOrPut("CoilType", stats);
                if (!currentCoil.equals(stats)) {
                    blockWorldState.setError(new PatternStringError("gtceu.multiblock.pattern.error.coils"));
                    return false;
                }
                return true;
            }
            return false;
        }, () -> (BlockInfo[])GTBlocks.ALL_COILS.entrySet().stream().sorted(Comparator.comparingInt(value -> ((ICoilType)value.getKey()).getTier())).map(coil -> BlockInfo.fromBlockState((BlockState)((CoilBlock)((Supplier)coil.getValue()).get()).m_49966_())).toArray(BlockInfo[]::new)).addTooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.pattern.error.coils")});
    }

    public static TraceabilityPredicate cleanroomFilters() {
        return new TraceabilityPredicate(blockWorldState -> {
            BlockState blockState = blockWorldState.getBlockState();
            for (Map.Entry<IFilterType, Supplier<Block>> entry : GTBlocks.ALL_FILTERS.entrySet()) {
                if (!blockState.m_60713_(entry.getValue().get())) continue;
                IFilterType stats = entry.getKey();
                IFilterType currentCoil = blockWorldState.getMatchContext().getOrPut("FilterType", stats);
                if (!currentCoil.equals(stats)) {
                    blockWorldState.setError(new PatternStringError("gtceu.multiblock.pattern.error.filters"));
                    return false;
                }
                return true;
            }
            return false;
        }, () -> (BlockInfo[])GTBlocks.ALL_FILTERS.values().stream().map(blockSupplier -> BlockInfo.fromBlockState((BlockState)((Block)blockSupplier.get()).m_49966_())).toArray(BlockInfo[]::new)).addTooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.pattern.error.filters")});
    }

    public static TraceabilityPredicate powerSubstationBatteries() {
        return new TraceabilityPredicate(blockWorldState -> {
            BlockState state = blockWorldState.getBlockState();
            for (Map.Entry<IBatteryData, Supplier<BatteryBlock>> entry : GTBlocks.PSS_BATTERIES.entrySet()) {
                if (!state.m_60713_((Block)entry.getValue().get())) continue;
                IBatteryData battery = entry.getKey();
                if (battery.getTier() != -1 && battery.getCapacity() > 0L) {
                    String key = "PSSBattery_" + battery.getBatteryName();
                    PowerSubstationMachine.BatteryMatchWrapper wrapper = (PowerSubstationMachine.BatteryMatchWrapper)blockWorldState.getMatchContext().get(key);
                    if (wrapper == null) {
                        wrapper = new PowerSubstationMachine.BatteryMatchWrapper(battery);
                    }
                    blockWorldState.getMatchContext().set(key, wrapper.increment());
                }
                return true;
            }
            return false;
        }, () -> (BlockInfo[])GTBlocks.PSS_BATTERIES.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IBatteryData)entry.getKey()).getTier())).map(entry -> new BlockInfo(((BatteryBlock)((Supplier)entry.getValue()).get()).m_49966_(), null)).toArray(BlockInfo[]::new)).addTooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.pattern.error.batteries")});
    }

    public static TraceabilityPredicate frames(Material ... frameMaterials) {
        return Predicates.blocks((Block[])Arrays.stream(frameMaterials).map(m -> (BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, m)).filter(Objects::nonNull).filter(RegistryEntry::isPresent).map(RegistryEntry::get).toArray(Block[]::new)).or(new TraceabilityPredicate(blockWorldState -> {
            BlockEntity tileEntity = blockWorldState.getTileEntity();
            if (!(tileEntity instanceof IPipeNode)) {
                return false;
            }
            IPipeNode pipeNode = (IPipeNode)tileEntity;
            return ArrayUtils.contains((Object[])frameMaterials, (Object)pipeNode.getFrameMaterial());
        }, () -> (BlockInfo[])Arrays.stream(frameMaterials).map(m -> (BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, m)).filter(Objects::nonNull).filter(RegistryEntry::isPresent).map(RegistryEntry::get).map(BlockInfo::fromBlock).toArray(BlockInfo[]::new)));
    }
}

