/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class GTRecipeSerializer
implements RecipeSerializer<GTRecipe> {
    public static final GTRecipeSerializer SERIALIZER = new GTRecipeSerializer();

    public Map<RecipeCapability<?>, List<Content>> capabilitiesFromJson(JsonObject json) {
        HashMap capabilities = new HashMap();
        for (String key : json.keySet()) {
            JsonArray contentsJson = json.getAsJsonArray(key);
            RecipeCapability capability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(key);
            if (capability == null) continue;
            ArrayList<Content> contents = new ArrayList<Content>();
            for (JsonElement contentJson : contentsJson) {
                contents.add(capability.serializer.fromJsonContent(contentJson));
            }
            capabilities.put(capability, contents);
        }
        return capabilities;
    }

    @NotNull
    public GTRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        String recipeType = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        int duration = json.has("duration") ? GsonHelper.m_13927_((JsonObject)json, (String)"duration") : 100;
        CompoundTag data = new CompoundTag();
        if (json.has("data")) {
            data = CraftingHelper.getNBT((JsonElement)json.get("data"));
        }
        Map<RecipeCapability<?>, List<Content>> inputs = this.capabilitiesFromJson(json.has("inputs") ? json.getAsJsonObject("inputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> tickInputs = this.capabilitiesFromJson(json.has("tickInputs") ? json.getAsJsonObject("tickInputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> outputs = this.capabilitiesFromJson(json.has("outputs") ? json.getAsJsonObject("outputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> tickOutputs = this.capabilitiesFromJson(json.has("tickOutputs") ? json.getAsJsonObject("tickOutputs") : new JsonObject());
        ArrayList<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
        JsonArray conditionsJson = json.has("recipeConditions") ? json.getAsJsonArray("recipeConditions") : new JsonArray();
        for (JsonElement jsonElement : conditionsJson) {
            RecipeCondition condition;
            JsonObject jsonObject;
            String conditionKey;
            Class clazz;
            if (!(jsonElement instanceof JsonObject) || (clazz = (Class)GTRegistries.RECIPE_CONDITIONS.get(conditionKey = GsonHelper.m_13851_((JsonObject)(jsonObject = (JsonObject)jsonElement), (String)"type", (String)""))) == null || (condition = RecipeCondition.create(clazz)) == null) continue;
            conditions.add(condition.deserialize(GsonHelper.m_13841_((JsonObject)jsonObject, (String)"data", (JsonObject)new JsonObject())));
        }
        boolean isFuel = GsonHelper.m_13855_((JsonObject)json, (String)"isFuel", (boolean)false);
        return new GTRecipe((GTRecipeType)BuiltInRegistries.f_256990_.m_7745_(new ResourceLocation(recipeType)), id, inputs, outputs, tickInputs, tickOutputs, conditions, data, duration, isFuel);
    }

    public static Tuple<RecipeCapability<?>, List<Content>> entryReader(FriendlyByteBuf buf) {
        RecipeCapability capability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf.m_130277_());
        List contents = buf.m_236845_(capability.serializer::fromNetworkContent);
        return new Tuple((Object)capability, (Object)contents);
    }

    public static void entryWriter(FriendlyByteBuf buf, Map.Entry<RecipeCapability<?>, ? extends List<Content>> entry) {
        RecipeCapability<?> capability = entry.getKey();
        List<Content> contents = entry.getValue();
        buf.m_130070_((String)GTRegistries.RECIPE_CAPABILITIES.getKey(capability));
        buf.m_236828_(contents, capability.serializer::toNetworkContent);
    }

    public static RecipeCondition conditionReader(FriendlyByteBuf buf) {
        RecipeCondition condition = RecipeCondition.create((Class)GTRegistries.RECIPE_CONDITIONS.get(buf.m_130277_()));
        return condition.fromNetwork(buf);
    }

    public static void conditionWriter(FriendlyByteBuf buf, RecipeCondition condition) {
        buf.m_130070_((String)GTRegistries.RECIPE_CONDITIONS.getKey(condition.getClass()));
        condition.toNetwork(buf);
    }

    public static Map<RecipeCapability<?>, List<Content>> tuplesToMap(List<Tuple<RecipeCapability<?>, List<Content>>> entries) {
        HashMap map = new HashMap();
        entries.forEach(entry -> map.put((RecipeCapability)entry.m_14418_(), (List)entry.m_14419_()));
        return map;
    }

    @NotNull
    public GTRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        String recipeType = buf.m_130277_();
        int duration = buf.m_130242_();
        Map<RecipeCapability<?>, List<Content>> inputs = GTRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> tickInputs = GTRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> outputs = GTRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> tickOutputs = GTRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        List conditions = (List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::conditionReader);
        CompoundTag data = buf.m_130260_();
        boolean isFuel = buf.readBoolean();
        return new GTRecipe((GTRecipeType)BuiltInRegistries.f_256990_.m_7745_(new ResourceLocation(recipeType)), id, inputs, outputs, tickInputs, tickOutputs, conditions, data, duration, isFuel);
    }

    public void toNetwork(FriendlyByteBuf buf, GTRecipe recipe) {
        buf.m_130070_(recipe.recipeType == null ? "dummy" : recipe.recipeType.toString());
        buf.m_130130_(recipe.duration);
        buf.m_236828_(recipe.inputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.tickInputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.outputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.tickOutputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.conditions, GTRecipeSerializer::conditionWriter);
        buf.m_130079_(recipe.data);
        buf.writeBoolean(recipe.isFuel);
    }
}

