/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.gui.SteamTexture;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.lookup.GTRecipeLookup;
import com.gregtechceu.gtceu.api.recipe.ui.GTRecipeTypeUI;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.core.mixins.RecipeManagerInvoker;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GTRecipeType
implements RecipeType<GTRecipe> {
    public final ResourceLocation registryName;
    public final String group;
    public final Object2IntMap<RecipeCapability<?>> maxInputs = new Object2IntOpenHashMap();
    public final Object2IntMap<RecipeCapability<?>> maxOutputs = new Object2IntOpenHashMap();
    private GTRecipeBuilder recipeBuilder;
    private GTRecipeTypeUI recipeUI = new GTRecipeTypeUI(this);
    private final Byte2ObjectMap<IGuiTexture> slotOverlays = new Byte2ObjectArrayMap();
    private GTRecipeType smallRecipeMap;
    @Nullable
    private Supplier<ItemStack> iconSupplier;
    @Nullable
    protected SoundEntry sound;
    protected List<Function<CompoundTag, String>> dataInfos = new ArrayList<Function<CompoundTag, String>>();
    protected int maxTooltips = 3;
    protected boolean isFuelRecipeType;
    protected final Map<RecipeType<?>, List<GTRecipe>> proxyRecipes;
    private CompoundTag customUICache;
    private final GTRecipeLookup lookup = new GTRecipeLookup(this);

    public GTRecipeType(ResourceLocation registryName, String group, RecipeType<?> ... proxyRecipes) {
        this.registryName = registryName;
        this.group = group;
        this.recipeBuilder = new GTRecipeBuilder(registryName, this);
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (RecipeType<?> proxyRecipe : proxyRecipes) {
            map.put(proxyRecipe, new ArrayList());
        }
        this.proxyRecipes = map;
    }

    public GTRecipeType setMaxIOSize(int maxInputs, int maxOutputs, int maxFluidInputs, int maxFluidOutputs) {
        return this.setMaxSize(IO.IN, ItemRecipeCapability.CAP, maxInputs).setMaxSize(IO.IN, FluidRecipeCapability.CAP, maxFluidInputs).setMaxSize(IO.OUT, ItemRecipeCapability.CAP, maxOutputs).setMaxSize(IO.OUT, FluidRecipeCapability.CAP, maxFluidOutputs);
    }

    public GTRecipeType setEUIO(IO io) {
        if (io.support(IO.IN)) {
            this.setMaxSize(IO.IN, EURecipeCapability.CAP, 1);
        }
        if (io.support(IO.OUT)) {
            this.setMaxSize(IO.OUT, EURecipeCapability.CAP, 1);
        }
        return this;
    }

    public GTRecipeType setMaxSize(IO io, RecipeCapability<?> cap, int max) {
        if (io == IO.IN || io == IO.BOTH) {
            this.maxInputs.put(cap, max);
        }
        if (io == IO.OUT || io == IO.BOTH) {
            this.maxOutputs.put(cap, max);
        }
        return this;
    }

    public GTRecipeType setSlotOverlay(boolean isOutput, boolean isFluid, IGuiTexture slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    public GTRecipeType setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, IGuiTexture slotOverlay) {
        this.recipeUI.setSlotOverlay(isOutput, isFluid, isLast, slotOverlay);
        return this;
    }

    public GTRecipeType setProgressBar(ResourceTexture progressBar, ProgressTexture.FillDirection moveType) {
        this.recipeUI.setProgressBar(progressBar, moveType);
        return this;
    }

    public GTRecipeType setSteamProgressBar(SteamTexture progressBar, ProgressTexture.FillDirection moveType) {
        this.recipeUI.setSteamProgressBarTexture(progressBar);
        this.recipeUI.setSteamMoveType(moveType);
        return this;
    }

    public GTRecipeType setUiBuilder(BiConsumer<GTRecipe, WidgetGroup> uiBuilder) {
        this.recipeUI.setUiBuilder(uiBuilder);
        return this;
    }

    public GTRecipeType addDataInfo(Function<CompoundTag, String> dataInfo) {
        this.dataInfos.add(dataInfo);
        return this;
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Nullable
    public GTRecipe getRecipe(RecipeManager recipeManager, ResourceLocation id) {
        Map recipes = ((RecipeManagerInvoker)recipeManager).getRecipeFromType(this);
        Recipe recipe = recipes.get(id);
        if (recipe instanceof GTRecipe) {
            GTRecipe recipe2 = (GTRecipe)recipe;
            return recipe2;
        }
        return null;
    }

    @Nullable
    public Iterator<GTRecipe> searchFuelRecipe(RecipeManager recipeManager, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies() || !this.isFuelRecipeType()) {
            return null;
        }
        return this.getLookup().getRecipeIterator(holder, recipe -> recipe.isFuel && recipe.matchRecipe(holder).isSuccess() && recipe.matchTickRecipe(holder).isSuccess());
    }

    @Nullable
    public Iterator<GTRecipe> searchRecipe(RecipeManager recipeManager, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies()) {
            return null;
        }
        return this.getLookup().getRecipeIterator(holder, recipe -> !recipe.isFuel && recipe.matchRecipe(holder).isSuccess() && recipe.matchTickRecipe(holder).isSuccess());
    }

    public int getMaxInputs(RecipeCapability<?> cap) {
        return this.maxInputs.getOrDefault(cap, 0);
    }

    public int getMaxOutputs(RecipeCapability<?> cap) {
        return this.maxOutputs.getOrDefault(cap, 0);
    }

    public GTRecipeType prepareBuilder(Consumer<GTRecipeBuilder> onPrepare) {
        onPrepare.accept(this.recipeBuilder);
        return this;
    }

    public GTRecipeBuilder recipeBuilder(ResourceLocation id, Object ... append) {
        if (append.length > 0) {
            return this.recipeBuilder.copy(new ResourceLocation(id.m_135827_(), id.m_135815_() + Arrays.stream(append).map(Object::toString).map(FormattingUtil::toLowerCaseUnder).reduce("", (a, b) -> a + "_" + b)));
        }
        return this.recipeBuilder.copy(id);
    }

    public GTRecipeBuilder recipeBuilder(String id, Object ... append) {
        return this.recipeBuilder(GTCEu.id(id), append);
    }

    public GTRecipeBuilder recipeBuilder(UnificationEntry entry, Object ... append) {
        return this.recipeBuilder(GTCEu.id(entry.tagPrefix + (String)(entry.material == null ? "" : "_" + entry.material.getName())), append);
    }

    public GTRecipeBuilder recipeBuilder(Supplier<? extends ItemLike> item, Object ... append) {
        return this.recipeBuilder(item.get(), append);
    }

    public GTRecipeBuilder recipeBuilder(ItemLike itemLike, Object ... append) {
        return this.recipeBuilder(new ResourceLocation(itemLike.m_5456_().m_5524_()), append);
    }

    public GTRecipeBuilder copyFrom(GTRecipeBuilder builder) {
        return this.recipeBuilder.copyFrom(builder);
    }

    public GTRecipeType onRecipeBuild(BiConsumer<GTRecipeBuilder, Consumer<FinishedRecipe>> onBuild) {
        this.recipeBuilder.onSave(onBuild);
        return this;
    }

    public GTRecipe toGTrecipe(ResourceLocation id, Recipe<?> recipe) {
        GTRecipeBuilder builder = this.recipeBuilder(id, new Object[0]);
        for (Ingredient ingredient : recipe.m_7527_()) {
            builder.inputItems(ingredient);
        }
        builder.outputItems(recipe.m_8043_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_)));
        if (recipe instanceof SmeltingRecipe) {
            SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
            builder.duration(smeltingRecipe.m_43753_());
        }
        return GTRecipeSerializer.SERIALIZER.fromJson(id, builder.build().m_125966_());
    }

    public GTRecipeType setRecipeBuilder(GTRecipeBuilder recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        return this;
    }

    public GTRecipeTypeUI getRecipeUI() {
        return this.recipeUI;
    }

    public GTRecipeType setRecipeUI(GTRecipeTypeUI recipeUI) {
        this.recipeUI = recipeUI;
        return this;
    }

    public Byte2ObjectMap<IGuiTexture> getSlotOverlays() {
        return this.slotOverlays;
    }

    public GTRecipeType setSmallRecipeMap(GTRecipeType smallRecipeMap) {
        this.smallRecipeMap = smallRecipeMap;
        return this;
    }

    public GTRecipeType getSmallRecipeMap() {
        return this.smallRecipeMap;
    }

    public GTRecipeType setIconSupplier(@Nullable Supplier<ItemStack> iconSupplier) {
        this.iconSupplier = iconSupplier;
        return this;
    }

    @Nullable
    public Supplier<ItemStack> getIconSupplier() {
        return this.iconSupplier;
    }

    public GTRecipeType setSound(@Nullable SoundEntry sound) {
        this.sound = sound;
        return this;
    }

    @Nullable
    public SoundEntry getSound() {
        return this.sound;
    }

    public List<Function<CompoundTag, String>> getDataInfos() {
        return this.dataInfos;
    }

    public GTRecipeType setMaxTooltips(int maxTooltips) {
        this.maxTooltips = maxTooltips;
        return this;
    }

    public int getMaxTooltips() {
        return this.maxTooltips;
    }

    public GTRecipeType setFuelRecipeType(boolean isFuelRecipeType) {
        this.isFuelRecipeType = isFuelRecipeType;
        return this;
    }

    public boolean isFuelRecipeType() {
        return this.isFuelRecipeType;
    }

    public Map<RecipeType<?>, List<GTRecipe>> getProxyRecipes() {
        return this.proxyRecipes;
    }

    public GTRecipeLookup getLookup() {
        return this.lookup;
    }
}

