/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Content {
    public Object content;
    public float chance;
    public float tierChanceBoost;
    @Nullable
    public String slotName;
    @Nullable
    public String uiName;

    public Content(Object content, float chance, float tierChanceBoost, @Nullable String slotName, @Nullable String uiName) {
        this.content = content;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.slotName = slotName;
        this.uiName = uiName;
    }

    public Content copy(RecipeCapability<?> capability, @Nullable ContentModifier modifier) {
        if (modifier == null || this.chance == 0.0f) {
            return new Content(capability.copyContent(this.content), this.chance, this.tierChanceBoost, this.slotName, this.uiName);
        }
        return new Content(capability.copyContent(this.content, modifier), this.chance, this.tierChanceBoost, this.slotName, this.uiName);
    }

    public IGuiTexture createOverlay(final boolean perTick) {
        return new IGuiTexture(){

            @OnlyIn(value=Dist.CLIENT)
            public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
                Content.this.drawChance(graphics, x, y, width, height);
                if (perTick) {
                    Content.this.drawTick(graphics, x, y, width, height);
                }
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawChance(GuiGraphics graphics, float x, float y, int width, int height) {
        if (this.chance == 1.0f) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        String s = this.chance == 0.0f ? LocalizationUtils.format((String)"gtceu.gui.content.chance_0_short", (Object[])new Object[0]) : String.format("%.2f", Float.valueOf(this.chance * 100.0f)) + "%";
        int color = this.chance == 0.0f ? 0xFF0000 : 0xFFFF00;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        graphics.m_280056_(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 23.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f - (float)height), color, true);
        graphics.m_280168_().m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTick(GuiGraphics graphics, float x, float y, int width, int height) {
        graphics.m_280168_().m_85836_();
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        String s = LocalizationUtils.format((String)"gtceu.gui.content.tips.per_tick_short", (Object[])new Object[0]);
        int color = 0xFFFF00;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        graphics.m_280488_(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 23.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f - (float)height + (float)(this.chance == 1.0f ? 0 : 10)), color);
        graphics.m_280168_().m_85849_();
    }

    public Object getContent() {
        return this.content;
    }
}

