/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.gregtechceu.gtceu.GTCEu;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import org.jetbrains.annotations.NotNull;

public abstract class GTRegistry<K, V>
implements Iterable<V> {
    public static final Map<ResourceLocation, GTRegistry<?, ?>> REGISTERED = new HashMap();
    protected final BiMap<K, V> registry = this.initRegistry();
    protected final ResourceLocation registryName;
    protected boolean frozen = true;

    public GTRegistry(ResourceLocation registryName) {
        this.registryName = registryName;
        REGISTERED.put(registryName, this);
    }

    protected BiMap<K, V> initRegistry() {
        return HashBiMap.create();
    }

    public boolean containKey(K key) {
        return this.registry.containsKey(key);
    }

    public boolean containValue(V value) {
        return this.registry.containsValue(value);
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen!");
        }
        if (!GTRegistry.checkActiveModContainerIsGregtech()) {
            return;
        }
        this.frozen = true;
    }

    public void unfreeze() {
        if (!this.frozen) {
            throw new IllegalStateException("Registry is already unfrozen!");
        }
        if (!GTRegistry.checkActiveModContainerIsGregtech()) {
            return;
        }
        this.frozen = false;
    }

    private static boolean checkActiveModContainerIsGregtech() {
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        return container != null && container.getModId().equals("gtceu") || container.getModId().equals("minecraft");
    }

    public void register(K key, V value) {
        if (this.frozen) {
            throw new IllegalStateException("[register] registry %s has been frozen".formatted(this.registryName));
        }
        if (this.containKey(key)) {
            throw new IllegalStateException("[register] registry %s contains key %s already".formatted(this.registryName, key));
        }
        this.registry.put(key, value);
    }

    @Nullable
    public V replace(K key, V value) {
        if (this.frozen) {
            throw new IllegalStateException("[replace] registry %s has been frozen".formatted(this.registryName));
        }
        if (!this.containKey(key)) {
            GTCEu.LOGGER.warn("[replace] couldn't find key %s in registry %s".formatted(this.registryName, key));
        }
        return (V)this.registry.put(key, value);
    }

    public V registerOrOverride(K key, V value) {
        if (this.frozen) {
            throw new IllegalStateException("[register] registry %s has been frozen".formatted(this.registryName));
        }
        return (V)this.registry.put(key, value);
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.registry.values().iterator();
    }

    public Set<V> values() {
        return this.registry.values();
    }

    public Set<K> keys() {
        return this.registry.keySet();
    }

    public Set<Map.Entry<K, V>> entries() {
        return this.registry.entrySet();
    }

    public Map<K, V> registry() {
        return this.registry;
    }

    @Nullable
    public V get(K key) {
        return (V)this.registry.get(key);
    }

    public V getOrDefault(K key, V defaultValue) {
        return (V)this.registry.getOrDefault(key, defaultValue);
    }

    public K getKey(V value) {
        return (K)this.registry.inverse().get(value);
    }

    public K getOrDefaultKey(V key, K defaultKey) {
        return (K)this.registry.inverse().getOrDefault(key, defaultKey);
    }

    public abstract void writeBuf(V var1, FriendlyByteBuf var2);

    @Nullable
    public abstract V readBuf(FriendlyByteBuf var1);

    public abstract Tag saveToNBT(V var1);

    @Nullable
    public abstract V loadFromNBT(Tag var1);

    public boolean remove(K name) {
        return this.registry.remove(name) != null;
    }

    public abstract Codec<V> codec();

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public static class RL<V>
    extends GTRegistry<ResourceLocation, V> {
        public RL(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public void writeBuf(V value, FriendlyByteBuf buf) {
            buf.writeBoolean(this.containValue(value));
            if (this.containValue(value)) {
                buf.m_130070_(((ResourceLocation)this.getKey(value)).toString());
            }
        }

        @Override
        public V readBuf(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return this.get(new ResourceLocation(buf.m_130277_()));
            }
            return null;
        }

        @Override
        public Tag saveToNBT(V value) {
            if (this.containValue(value)) {
                return StringTag.m_129297_((java.lang.String)((ResourceLocation)this.getKey(value)).toString());
            }
            return new CompoundTag();
        }

        @Override
        public V loadFromNBT(Tag tag) {
            return this.get(new ResourceLocation(tag.m_7916_()));
        }

        @Override
        public Codec<V> codec() {
            return ResourceLocation.f_135803_.flatXmap(rl -> Optional.ofNullable(this.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.registryName + ": " + rl)), obj -> Optional.ofNullable((ResourceLocation)this.getKey(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + this.registryName + ": " + obj)));
        }
    }

    public static class String<V>
    extends GTRegistry<java.lang.String, V> {
        public String(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public void writeBuf(V value, FriendlyByteBuf buf) {
            buf.writeBoolean(this.containValue(value));
            if (this.containValue(value)) {
                buf.m_130070_((java.lang.String)this.getKey(value));
            }
        }

        @Override
        public V readBuf(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return this.get(buf.m_130277_());
            }
            return null;
        }

        @Override
        public Tag saveToNBT(V value) {
            if (this.containValue(value)) {
                return StringTag.m_129297_((java.lang.String)((java.lang.String)this.getKey(value)));
            }
            return new CompoundTag();
        }

        @Override
        public V loadFromNBT(Tag tag) {
            return this.get(tag.m_7916_());
        }

        @Override
        public Codec<V> codec() {
            return Codec.STRING.flatXmap(str -> Optional.ofNullable(this.get(str)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.registryName + ": " + str)), obj -> Optional.ofNullable((java.lang.String)this.getKey(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + this.registryName + ": " + obj)));
        }
    }
}

