/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.model.WorkableOverlayModel;
import com.gregtechceu.gtceu.client.renderer.machine.ISplitShaftRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.SplitShaftTieredHullMachineRenderer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KineticWorkableTieredHullMachineRenderer
extends SplitShaftTieredHullMachineRenderer
implements ISplitShaftRenderer {
    protected final WorkableOverlayModel overlayModel;

    public KineticWorkableTieredHullMachineRenderer(int tier, ResourceLocation modelLocation, ResourceLocation overlayModel) {
        super(tier, modelLocation);
        this.overlayModel = new WorkableOverlayModel(overlayModel);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (machine instanceof IWorkable) {
            IWorkable workable = (IWorkable)((Object)machine);
            quads.addAll(this.overlayModel.bakeQuads(side, frontFacing, workable.isActive(), workable.isWorkingEnabled()));
        } else {
            quads.addAll(this.overlayModel.bakeQuads(side, frontFacing, false, false));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            this.overlayModel.registerTextureAtlas(register);
        }
    }
}

