/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleFluidFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.LongInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.NumberInputWidget;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.data.BucketMode;
import com.gregtechceu.gtceu.common.cover.data.TransferMode;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Map;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;

public class FluidRegulatorCover
extends PumpCover {
    private static final long MAX_STACK_SIZE = 2048000000L;
    @Persisted
    @DescSynced
    private TransferMode transferMode = TransferMode.TRANSFER_ANY;
    @Persisted
    @DescSynced
    private BucketMode transferBucketMode = BucketMode.MILLI_BUCKET;
    @Persisted
    @DescSynced
    protected long globalTransferSizeMillibuckets;
    protected long fluidTransferBuffered = 0L;
    private NumberInputWidget<Long> transferSizeInput;
    private EnumSelectorWidget<BucketMode> transferBucketModeInput;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidRegulatorCover.class, PumpCover.MANAGED_FIELD_HOLDER);

    public FluidRegulatorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier) {
        super(definition, coverHolder, attachedSide, tier);
    }

    @Override
    protected long doTransferFluidsInternal(IFluidTransfer source, IFluidTransfer destination, long platformTransferLimit) {
        return switch (this.transferMode) {
            default -> throw new IncompatibleClassChangeError();
            case TransferMode.TRANSFER_ANY -> this.transferAny(source, destination, platformTransferLimit);
            case TransferMode.TRANSFER_EXACT -> this.transferExact(source, destination, platformTransferLimit);
            case TransferMode.KEEP_EXACT -> this.keepExact(source, destination, platformTransferLimit);
        };
    }

    private long transferExact(IFluidTransfer source, IFluidTransfer destination, long platformTransferLimit) {
        long fluidLeftToTransfer = platformTransferLimit;
        for (int slot = 0; slot < source.getTanks() && fluidLeftToTransfer > 0L; ++slot) {
            long insertableAmount;
            FluidStack sourceFluid = source.getFluidInTank(slot).copy();
            long supplyAmount = this.getFilteredFluidAmount(sourceFluid) * MILLIBUCKET_SIZE;
            if (fluidLeftToTransfer + this.fluidTransferBuffered < supplyAmount) {
                this.fluidTransferBuffered += fluidLeftToTransfer;
                fluidLeftToTransfer = 0L;
                break;
            }
            if (sourceFluid.isEmpty() || supplyAmount <= 0L) continue;
            sourceFluid.setAmount(supplyAmount);
            FluidStack drained = source.drain(sourceFluid, true);
            if (drained.isEmpty() || drained.getAmount() < supplyAmount || (insertableAmount = destination.fill(drained.copy(), true)) <= 0L) continue;
            drained.setAmount(insertableAmount);
            drained = source.drain(drained, false);
            if (!drained.isEmpty()) {
                destination.fill(drained, false);
                fluidLeftToTransfer -= drained.getAmount() - this.fluidTransferBuffered;
            }
            this.fluidTransferBuffered = 0L;
        }
        return platformTransferLimit - fluidLeftToTransfer;
    }

    private long keepExact(IFluidTransfer source, IFluidTransfer destination, long platformTransferLimit) {
        long fluidLeftToTransfer = platformTransferLimit;
        Map<FluidStack, Long> sourceAmounts = this.enumerateDistinctFluids(source, PumpCover.TransferDirection.EXTRACT);
        Map<FluidStack, Long> destinationAmounts = this.enumerateDistinctFluids(destination, PumpCover.TransferDirection.INSERT);
        for (FluidStack fluidStack : sourceAmounts.keySet()) {
            FluidStack drained;
            long fillableAmount;
            if (fluidLeftToTransfer <= 0L) break;
            long amountToKeep = this.getFilteredFluidAmount(fluidStack) * MILLIBUCKET_SIZE;
            long amountInDest = destinationAmounts.getOrDefault(fluidStack, 0L);
            if (amountInDest >= amountToKeep) continue;
            FluidStack fluidToMove = fluidStack.copy();
            fluidToMove.setAmount(Math.min(fluidLeftToTransfer, amountToKeep - amountInDest));
            if (fluidToMove.getAmount() <= 0L || (fillableAmount = destination.fill(drained = source.drain(fluidToMove, true), true)) <= 0L) continue;
            fluidToMove.setAmount(Math.min(fluidToMove.getAmount(), fillableAmount));
            drained = source.drain(fluidToMove, false);
            long movedAmount = destination.fill(drained, false);
            fluidLeftToTransfer -= movedAmount;
        }
        return platformTransferLimit - fluidLeftToTransfer;
    }

    private void setTransferBucketMode(BucketMode transferBucketMode) {
        long oldMultiplier = this.transferBucketMode.multiplier;
        long newMultiplier = transferBucketMode.multiplier;
        this.transferBucketMode = transferBucketMode;
        if (this.transferSizeInput == null) {
            return;
        }
        if (oldMultiplier > newMultiplier) {
            this.transferSizeInput.setValue(this.getCurrentBucketModeTransferSize());
        }
        this.transferSizeInput.setMax(2048000000L / this.transferBucketMode.multiplier);
        if (newMultiplier > oldMultiplier) {
            this.transferSizeInput.setValue(this.getCurrentBucketModeTransferSize());
        }
    }

    private void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.configureTransferSizeInput();
        if (!this.isRemote()) {
            this.configureFilter();
        }
    }

    @Override
    protected void configureFilter() {
        Object f = this.filterHandler.getFilter();
        if (f instanceof SimpleFluidFilter) {
            SimpleFluidFilter filter = (SimpleFluidFilter)f;
            filter.setMaxStackSize(this.transferMode == TransferMode.TRANSFER_ANY ? 1L : 2048000000L);
        }
        this.configureTransferSizeInput();
    }

    private long getFilteredFluidAmount(FluidStack fluidStack) {
        if (!this.filterHandler.isFilterPresent()) {
            return this.globalTransferSizeMillibuckets;
        }
        FluidFilter filter = (FluidFilter)this.filterHandler.getFilter();
        return (filter.supportsAmounts() ? filter.testFluidAmount(fluidStack) : this.globalTransferSizeMillibuckets) * MILLIBUCKET_SIZE;
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.fluid_regulator.title";
    }

    @Override
    protected void buildAdditionalUI(WidgetGroup group) {
        group.addWidget((Widget)new EnumSelectorWidget(146, 45, 20, 20, (Enum[])TransferMode.values(), (Enum)this.transferMode, this::setTransferMode));
        this.transferSizeInput = new LongInputWidget(35, 45, 84, 20, this::getCurrentBucketModeTransferSize, this::setCurrentBucketModeTransferSize).setMin(0L).setMax(Long.MAX_VALUE);
        this.configureTransferSizeInput();
        group.addWidget(this.transferSizeInput);
        this.transferBucketModeInput = new EnumSelectorWidget(121, 45, 20, 20, (Enum[])BucketMode.values(), (Enum)this.transferBucketMode, this::setTransferBucketMode);
        group.addWidget(this.transferBucketModeInput);
    }

    private long getCurrentBucketModeTransferSize() {
        return this.globalTransferSizeMillibuckets / this.transferBucketMode.multiplier;
    }

    private void setCurrentBucketModeTransferSize(long transferSize) {
        this.globalTransferSizeMillibuckets = Math.min(Math.max(transferSize * this.transferBucketMode.multiplier, 0L), 2048000000L);
    }

    private void configureTransferSizeInput() {
        if (this.transferSizeInput == null || this.transferBucketModeInput == null) {
            return;
        }
        this.transferSizeInput.setVisible(this.shouldShowTransferSize());
        this.transferBucketModeInput.setVisible(this.shouldShowTransferSize());
    }

    private boolean shouldShowTransferSize() {
        if (this.transferMode == TransferMode.TRANSFER_ANY) {
            return false;
        }
        if (!this.filterHandler.isFilterPresent()) {
            return true;
        }
        return !((FluidFilter)this.filterHandler.getFilter()).supportsAmounts();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public BucketMode getTransferBucketMode() {
        return this.transferBucketMode;
    }

    public long getGlobalTransferSizeMillibuckets() {
        return this.globalTransferSizeMillibuckets;
    }
}

