/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.common.cover.data.ControllerMode;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MachineControllerCover
extends CoverBehavior
implements IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MachineControllerCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    private ItemStackTransfer sideCoverSlot;
    private ButtonWidget modeButton;
    @Persisted
    private boolean isInverted = false;
    @Persisted
    private int minRedstoneStrength = 1;
    @Persisted
    @DescSynced
    private ControllerMode controllerMode = ControllerMode.MACHINE;

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public MachineControllerCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return !this.getAllowedModes().isEmpty();
    }

    @Override
    public void onAttached(ItemStack itemStack, ServerPlayer player) {
        super.onAttached(itemStack, player);
        this.setControllerMode(this.getAllowedModes().get(0));
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.resetCurrentControllable();
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateInput();
    }

    public void setControllerMode(ControllerMode controllerMode) {
        this.resetCurrentControllable();
        this.controllerMode = controllerMode;
        this.updateAll();
    }

    public void setMinRedstoneStrength(int minRedstoneStrength) {
        this.minRedstoneStrength = minRedstoneStrength;
        this.updateAll();
    }

    public void setInverted(boolean inverted) {
        this.isInverted = inverted;
        this.updateAll();
    }

    private void updateAll() {
        this.updateInput();
        this.updateUI();
    }

    @Nullable
    private IControllable getControllable(@Nullable Direction side) {
        if (side == null) {
            return GTCapabilityHelper.getControllable(this.coverHolder.getLevel(), this.coverHolder.getPos(), null);
        }
        CoverBehavior coverBehavior = this.coverHolder.getCoverAtSide(side);
        if (coverBehavior instanceof IControllable) {
            IControllable cover = (IControllable)((Object)coverBehavior);
            return cover;
        }
        return null;
    }

    private void updateInput() {
        if (this.controllerMode == null) {
            return;
        }
        IControllable controllable = this.getControllable(this.controllerMode.side);
        if (controllable != null) {
            controllable.setWorkingEnabled(this.shouldAllowWorking() && this.doOthersAllowWorking());
        }
    }

    private void resetCurrentControllable() {
        if (this.controllerMode == null) {
            return;
        }
        IControllable controllable = this.getControllable(this.controllerMode.side);
        if (controllable != null) {
            controllable.setWorkingEnabled(this.doOthersAllowWorking());
        }
    }

    private boolean shouldAllowWorking() {
        boolean shouldAllowWorking = this.getInputSignal() < this.minRedstoneStrength;
        return this.isInverted != shouldAllowWorking;
    }

    private boolean doOthersAllowWorking() {
        return this.coverHolder.getCovers().stream().filter(cover -> this.attachedSide != cover.attachedSide).filter(cover -> cover instanceof MachineControllerCover).filter(cover -> ((MachineControllerCover)cover).controllerMode == this.controllerMode).allMatch(cover -> ((MachineControllerCover)cover).shouldAllowWorking());
    }

    public List<ControllerMode> getAllowedModes() {
        return Arrays.stream(ControllerMode.values()).filter(mode -> mode.side != this.attachedSide).filter(mode -> this.getControllable(mode.side) != null).collect(Collectors.toList());
    }

    private int getInputSignal() {
        Level level = this.coverHolder.getLevel();
        BlockPos sourcePos = this.coverHolder.getPos().m_121945_(this.attachedSide);
        return level.m_8055_(sourcePos).m_60746_((BlockGetter)level, sourcePos, this.attachedSide);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 75);
        group.addWidget((Widget)new LabelWidget(10, 5, "cover.machine_controller.title"));
        group.addWidget(new IntInputWidget(10, 20, 131, 20, this::getMinRedstoneStrength, this::setMinRedstoneStrength).setMin(1).setMax(15));
        this.modeButton = new ButtonWidget(10, 45, 131, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON}), cd -> this.selectNextMode());
        group.addWidget((Widget)this.modeButton);
        group.addWidget((Widget)new ToggleButtonWidget(146, 20, 20, 20, (IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON, this::isInverted, this::setInverted){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(List.copyOf(LangHandler.getMultiLang("cover.machine_controller.invert." + (this.isPressed ? "enabled" : "disabled"))));
            }
        });
        this.sideCoverSlot = new ItemStackTransfer(1);
        group.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)this.sideCoverSlot, 0, 147, 46){

            public ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickTypeIn, ItemStack stackHeld) {
                return MachineControllerCover.this.sideCoverSlot.getStackInSlot(0);
            }
        });
        this.updateUI();
        return group;
    }

    private void selectNextMode() {
        List<ControllerMode> allowedModes = this.getAllowedModes();
        this.setControllerMode(allowedModes.stream().dropWhile(mode -> mode != this.controllerMode).skip(1L).findFirst().orElseGet(() -> (ControllerMode)((Object)((Object)allowedModes.get(0)))));
        this.updateAll();
    }

    private void updateUI() {
        this.updateModeButton();
        this.updateCoverSlot();
    }

    private void updateModeButton() {
        if (this.modeButton == null) {
            return;
        }
        this.modeButton.setButtonTexture(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, new TextTexture(this.controllerMode.localeName)})});
    }

    private void updateCoverSlot() {
        if (this.sideCoverSlot == null) {
            return;
        }
        Optional.ofNullable(this.controllerMode.side).map(this.coverHolder::getCoverAtSide).map(CoverBehavior::getAttachItem).map(ItemStack::m_41777_).ifPresentOrElse(item -> {
            this.sideCoverSlot.setStackInSlot(0, item);
            this.sideCoverSlot.onContentsChanged(0);
        }, () -> {
            this.sideCoverSlot.setStackInSlot(0, ItemStack.f_41583_);
            this.sideCoverSlot.onContentsChanged(0);
        });
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public int getMinRedstoneStrength() {
        return this.minRedstoneStrength;
    }

    public ControllerMode getControllerMode() {
        return this.controllerMode;
    }
}

