/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.events.MaterialCasingCollectionEvent;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.block.IFusionCasingType;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.block.OreBlock;
import com.gregtechceu.gtceu.api.block.RendererBlock;
import com.gregtechceu.gtceu.api.block.RendererGlassBlock;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.LaserPipeBlockItem;
import com.gregtechceu.gtceu.api.item.MaterialBlockItem;
import com.gregtechceu.gtceu.api.item.MaterialPipeBlockItem;
import com.gregtechceu.gtceu.api.item.RendererBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeBlock;
import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.client.renderer.block.CTMModelRenderer;
import com.gregtechceu.gtceu.client.renderer.block.TextureOverrideRenderer;
import com.gregtechceu.gtceu.common.block.BatteryBlock;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.block.CleanroomFilterType;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import com.gregtechceu.gtceu.common.block.FluidPipeBlock;
import com.gregtechceu.gtceu.common.block.FusionCasingBlock;
import com.gregtechceu.gtceu.common.block.ItemPipeBlock;
import com.gregtechceu.gtceu.common.block.LaserPipeBlock;
import com.gregtechceu.gtceu.common.block.MinerPipeBlock;
import com.gregtechceu.gtceu.common.block.RubberLogBlock;
import com.gregtechceu.gtceu.common.block.SurfaceRockBlock;
import com.gregtechceu.gtceu.common.data.GCyMBlocks;
import com.gregtechceu.gtceu.common.data.GTCompassNodes;
import com.gregtechceu.gtceu.common.data.GTCompassSections;
import com.gregtechceu.gtceu.common.data.GTConfiguredFeatures;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTModels;
import com.gregtechceu.gtceu.common.data.GTSoundTypes;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemPipeType;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeType;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.core.mixins.BlockPropertiesAccessor;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.SupplierMemoizer;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GTBlocks {
    private static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<? extends MaterialBlock>> MATERIAL_BLOCKS_BUILDER = ImmutableTable.builder();
    private static ImmutableMap.Builder<Material, BlockEntry<SurfaceRockBlock>> SURFACE_ROCK_BLOCKS_BUILDER = ImmutableMap.builder();
    private static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<CableBlock>> CABLE_BLOCKS_BUILDER = ImmutableTable.builder();
    private static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<FluidPipeBlock>> FLUID_PIPE_BLOCKS_BUILDER = ImmutableTable.builder();
    private static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<ItemPipeBlock>> ITEM_PIPE_BLOCKS_BUILDER = ImmutableTable.builder();
    public static Table<TagPrefix, Material, BlockEntry<? extends MaterialBlock>> MATERIAL_BLOCKS;
    public static Map<Material, BlockEntry<SurfaceRockBlock>> SURFACE_ROCK_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<CableBlock>> CABLE_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<FluidPipeBlock>> FLUID_PIPE_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<ItemPipeBlock>> ITEM_PIPE_BLOCKS;
    public static final BlockEntry<LaserPipeBlock>[] LASER_PIPES;
    public static final BlockEntry<LongDistancePipeBlock> LD_ITEM_PIPE;
    public static final BlockEntry<LongDistancePipeBlock> LD_FLUID_PIPE;
    public static final BlockEntry<Block> CASING_COKE_BRICKS;
    public static final BlockEntry<Block> CASING_PRIMITIVE_BRICKS;
    public static final BlockEntry<Block> CASING_BRONZE_BRICKS;
    public static final BlockEntry<Block> CASING_INVAR_HEATPROOF;
    public static final BlockEntry<Block> CASING_ALUMINIUM_FROSTPROOF;
    public static final BlockEntry<Block> CASING_STEEL_SOLID;
    public static final BlockEntry<Block> CASING_STAINLESS_CLEAN;
    public static final BlockEntry<Block> CASING_TITANIUM_STABLE;
    public static final BlockEntry<Block> CASING_TUNGSTENSTEEL_ROBUST;
    public static final BlockEntry<Block> CASING_PTFE_INERT;
    public static final BlockEntry<Block> CASING_HSSE_STURDY;
    public static final BlockEntry<Block> CASING_PALLADIUM_SUBSTATION;
    public static final BlockEntry<Block> CASING_TEMPERED_GLASS;
    public static final ImmutableMap<Material, BlockEntry<Block>> MATERIALS_TO_CASINGS;
    public static final BlockEntry<Block> CASING_GRATE;
    public static final BlockEntry<Block> CASING_ASSEMBLY_CONTROL;
    public static final BlockEntry<Block> CASING_LAMINATED_GLASS;
    public static final BlockEntry<ActiveBlock> CASING_ASSEMBLY_LINE;
    public static final BlockEntry<Block> CASING_BRONZE_GEARBOX;
    public static final BlockEntry<Block> CASING_STEEL_GEARBOX;
    public static final BlockEntry<Block> CASING_STAINLESS_STEEL_GEARBOX;
    public static final BlockEntry<Block> CASING_TITANIUM_GEARBOX;
    public static final BlockEntry<Block> CASING_TUNGSTENSTEEL_GEARBOX;
    public static final BlockEntry<Block> CASING_STEEL_TURBINE;
    public static final BlockEntry<Block> CASING_TITANIUM_TURBINE;
    public static final BlockEntry<Block> CASING_STAINLESS_TURBINE;
    public static final BlockEntry<Block> CASING_TUNGSTENSTEEL_TURBINE;
    public static final BlockEntry<Block> CASING_BRONZE_PIPE;
    public static final BlockEntry<Block> CASING_STEEL_PIPE;
    public static final BlockEntry<Block> CASING_TITANIUM_PIPE;
    public static final BlockEntry<Block> CASING_TUNGSTENSTEEL_PIPE;
    public static final BlockEntry<Block> CASING_POLYTETRAFLUOROETHYLENE_PIPE;
    public static final BlockEntry<MinerPipeBlock> MINER_PIPE;
    public static final BlockEntry<Block> CASING_PUMP_DECK;
    public static final BlockEntry<Block> MACHINE_CASING_ULV;
    public static final BlockEntry<Block> MACHINE_CASING_LV;
    public static final BlockEntry<Block> MACHINE_CASING_MV;
    public static final BlockEntry<Block> MACHINE_CASING_HV;
    public static final BlockEntry<Block> MACHINE_CASING_EV;
    public static final BlockEntry<Block> MACHINE_CASING_IV;
    public static final BlockEntry<Block> MACHINE_CASING_LuV;
    public static final BlockEntry<Block> MACHINE_CASING_ZPM;
    public static final BlockEntry<Block> MACHINE_CASING_UV;
    public static final BlockEntry<Block> MACHINE_CASING_UHV;
    public static final BlockEntry<Block> MACHINE_CASING_UEV;
    public static final BlockEntry<Block> MACHINE_CASING_UIV;
    public static final BlockEntry<Block> MACHINE_CASING_UXV;
    public static final BlockEntry<Block> MACHINE_CASING_OpV;
    public static final BlockEntry<Block> MACHINE_CASING_MAX;
    public static final BlockEntry<Block> HERMETIC_CASING_LV;
    public static final BlockEntry<Block> HERMETIC_CASING_MV;
    public static final BlockEntry<Block> HERMETIC_CASING_HV;
    public static final BlockEntry<Block> HERMETIC_CASING_EV;
    public static final BlockEntry<Block> HERMETIC_CASING_IV;
    public static final BlockEntry<Block> HERMETIC_CASING_LuV;
    public static final BlockEntry<Block> HERMETIC_CASING_ZPM;
    public static final BlockEntry<Block> HERMETIC_CASING_UV;
    public static final BlockEntry<Block> HERMETIC_CASING_UHV;
    public static final BlockEntry<Block> BRONZE_HULL;
    public static final BlockEntry<Block> BRONZE_BRICKS_HULL;
    public static final BlockEntry<Block> STEEL_HULL;
    public static final BlockEntry<Block> STEEL_BRICKS_HULL;
    public static final Map<ICoilType, Supplier<CoilBlock>> ALL_COILS;
    public static final BlockEntry<CoilBlock> COIL_CUPRONICKEL;
    public static final BlockEntry<CoilBlock> COIL_KANTHAL;
    public static final BlockEntry<CoilBlock> COIL_NICHROME;
    public static final BlockEntry<CoilBlock> COIL_RTMALLOY;
    public static final BlockEntry<CoilBlock> COIL_HSSG;
    public static final BlockEntry<CoilBlock> COIL_NAQUADAH;
    public static final BlockEntry<CoilBlock> COIL_TRINIUM;
    public static final BlockEntry<CoilBlock> COIL_TRITANIUM;
    public static final Map<IBatteryData, Supplier<BatteryBlock>> PSS_BATTERIES;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_I;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_EV;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_IV;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_II;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_LuV;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_ZPM;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_III;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_UV;
    public static final BlockEntry<BatteryBlock> BATTERY_ULTIMATE_UHV;
    public static final BlockEntry<ActiveBlock> CASING_ENGINE_INTAKE;
    public static final BlockEntry<ActiveBlock> CASING_EXTREME_ENGINE_INTAKE;
    public static final Map<IFusionCasingType, Supplier<FusionCasingBlock>> ALL_FUSION_CASINGS;
    public static final BlockEntry<FusionCasingBlock> SUPERCONDUCTING_COIL;
    public static final BlockEntry<FusionCasingBlock> FUSION_COIL;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING_MK2;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING_MK3;
    public static final BlockEntry<Block> FUSION_GLASS;
    public static final Map<IFilterType, Supplier<Block>> ALL_FILTERS;
    public static final BlockEntry<Block> PLASTCRETE;
    public static final BlockEntry<Block> FILTER_CASING;
    public static final BlockEntry<Block> FILTER_CASING_STERILE;
    public static final BlockEntry<Block> CLEANROOM_GLASS;
    public static final Map<BoilerFireboxType, BlockEntry<ActiveBlock>> ALL_FIREBOXES;
    public static final BlockEntry<ActiveBlock> FIREBOX_BRONZE;
    public static final BlockEntry<ActiveBlock> FIREBOX_STEEL;
    public static final BlockEntry<ActiveBlock> FIREBOX_TITANIUM;
    public static final BlockEntry<ActiveBlock> FIREBOX_TUNGSTENSTEEL;
    public static final BlockEntry<Block> HIGH_POWER_CASING;
    public static final BlockEntry<SaplingBlock> RUBBER_SAPLING;
    public static final BlockEntry<RubberLogBlock> RUBBER_LOG;
    public static final float[] RUBBER_LEAVES_DROPPING_CHANCE;
    public static final BlockEntry<LeavesBlock> RUBBER_LEAVES;
    public static final BlockEntry<Block> RUBBER_PLANK;
    public static final BlockEntry<Block> TREATED_WOOD_PLANK;

    private static void generateMaterialBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Material Blocks...");
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            if (TagPrefix.ORES.containsKey(tagPrefix) || !tagPrefix.doGenerateBlock()) continue;
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!tagPrefix.doGenerateBlock(material)) continue;
                    MATERIAL_BLOCKS_BUILDER.put((Object)tagPrefix, (Object)material, (Object)((BlockBuilder)((ItemBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(tagPrefix.idPattern().formatted(material.getName()), properties -> new MaterialBlock((BlockBehaviour.Properties)properties, tagPrefix, material)).initialProperties(() -> Blocks.f_50075_).properties(p -> ((BlockBehaviour.Properties)tagPrefix.blockProperties().properties().apply((BlockBehaviour.Properties)p)).m_222994_()).transform(GTBlocks.unificationBlock(tagPrefix, material))).addLayer(tagPrefix.blockProperties().renderType()).setData(ProviderType.BLOCKSTATE, NonNullBiConsumer.noop())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).color(() -> MaterialBlock::tintedColor).item(MaterialBlockItem::create).onRegister(MaterialBlockItem::onRegister)).model(NonNullBiConsumer.noop()).color(() -> MaterialBlockItem::tintColor).onRegister(item -> CompassNode.getOrCreate(GTCompassSections.MATERIALS, FormattingUtil.toLowerCaseUnderscore(tagPrefix.name)).iconIfNull(() -> new ItemStackTexture(new Item[]{item})).addTag(tagPrefix.getItemParentTags()))).build()).register());
                }
            }
        }
        GTCEu.LOGGER.debug("Generating GTCEu Material Blocks... Complete!");
    }

    private static void generateOreBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Ore Blocks...");
        for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
            GTRegistrate registrate = registry.getRegistrate();
            for (Material material : registry.getAllMaterials()) {
                if (!GTBlocks.allowOreBlock(material)) continue;
                GTBlocks.registerOreBlock(material, registrate);
            }
        }
        GTCEu.LOGGER.debug("Generating GTCEu Ore Blocks... Complete!");
    }

    private static boolean allowOreBlock(Material material) {
        return material.hasProperty(PropertyKey.ORE);
    }

    private static void registerOreBlock(Material material, GTRegistrate registrate) {
        for (Map.Entry<TagPrefix, TagPrefix.OreType> ore : TagPrefix.ORES.entrySet()) {
            if (ore.getKey().isIgnored(material)) continue;
            TagPrefix oreTag = ore.getKey();
            TagPrefix.OreType oreType = ore.getValue();
            BlockEntry entry = ((BlockBuilder)((ItemBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s%s_ore".formatted(oreTag != TagPrefix.ore ? FormattingUtil.toLowerCaseUnder(oreTag.name) + "_" : "", material.getName()), properties -> new OreBlock((BlockBehaviour.Properties)properties, oreTag, material, true)).initialProperties(() -> {
                if (oreType.stoneType().get().m_60795_()) {
                    return Blocks.f_49996_;
                }
                return oreType.stoneType().get().m_60734_();
            }).properties(properties -> GTBlocks.copy(oreType.template().get(), properties).m_222994_()).transform(GTBlocks.unificationBlock(oreTag, material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).color(() -> MaterialBlock::tintedColor).item(MaterialBlockItem::create).onRegister(MaterialBlockItem::onRegister)).model(NonNullBiConsumer.noop()).color(() -> MaterialBlockItem::tintColor).onRegister(GTBlocks.compassNodeExist(GTCompassSections.GENERATIONS, oreTag.name, GTCompassNodes.ORE))).build()).register();
            MATERIAL_BLOCKS_BUILDER.put((Object)oreTag, (Object)material, (Object)entry);
        }
    }

    private static void generateOreIndicators() {
        GTCEu.LOGGER.debug("Generating GTCEu Surface Rock Indicator Blocks...");
        for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
            GTRegistrate registrate = registry.getRegistrate();
            for (Material material : registry.getAllMaterials()) {
                if (!GTBlocks.allowOreIndicator(material)) continue;
                GTBlocks.registerOreIndicator(material, registrate);
            }
        }
        SURFACE_ROCK_BLOCKS = SURFACE_ROCK_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.debug("Generating GTCEu Surface Rock Indicator Blocks... Complete!");
    }

    private static boolean allowOreIndicator(Material material) {
        return material.hasProperty(PropertyKey.ORE);
    }

    private static void registerOreIndicator(Material material, GTRegistrate registrate) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)registrate.block("%s_indicator".formatted(material.getName()), p -> new SurfaceRockBlock((BlockBehaviour.Properties)p, material)).initialProperties(() -> Blocks.f_49994_).properties(p -> p.m_222994_().m_60978_(0.25f)).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).color(() -> SurfaceRockBlock::tintedColor).register();
        SURFACE_ROCK_BLOCKS_BUILDER.put((Object)material, (Object)entry);
    }

    private static void generateCableBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Cable/Wire Blocks...");
        for (Insulation insulation : Insulation.values()) {
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!GTBlocks.allowCableBlock(material, insulation)) continue;
                    GTBlocks.registerCableBlock(material, insulation, registrate);
                }
            }
        }
        CABLE_BLOCKS = CABLE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.debug("Generating GTCEu Cable/Wire Blocks... Complete!");
    }

    private static boolean allowCableBlock(Material material, Insulation insulation) {
        return material.hasProperty(PropertyKey.WIRE) && !insulation.tagPrefix.isIgnored(material) && (!insulation.isCable || !material.getProperty(PropertyKey.WIRE).isSuperconductor());
    }

    private static void registerCableBlock(Material material, Insulation insulation, GTRegistrate registrate) {
        BlockEntry entry = ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s_%s".formatted(material.getName(), insulation.name), p -> new CableBlock((BlockBehaviour.Properties)p, insulation, material)).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60988_().m_60955_().m_222994_()).transform(GTBlocks.unificationBlock(insulation.tagPrefix, material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).onRegister(GTBlocks.compassNodeExist(GTCompassSections.MATERIALS, "wire_and_cable", new CompassNode[0]))).build()).register();
        CABLE_BLOCKS_BUILDER.put((Object)insulation.tagPrefix, (Object)material, (Object)entry);
    }

    private static void generateFluidPipeBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Fluid Pipe Blocks...");
        for (FluidPipeType fluidPipeType : FluidPipeType.values()) {
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!GTBlocks.allowFluidPipeBlock(material, fluidPipeType)) continue;
                    GTBlocks.registerFluidPipeBlock(material, fluidPipeType, registrate);
                }
            }
        }
        FLUID_PIPE_BLOCKS = FLUID_PIPE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.debug("Generating GTCEu Fluid Pipe Blocks... Complete!");
    }

    private static boolean allowFluidPipeBlock(Material material, FluidPipeType fluidPipeType) {
        return material.hasProperty(PropertyKey.FLUID_PIPE) && !fluidPipeType.tagPrefix.isIgnored(material);
    }

    private static void registerFluidPipeBlock(Material material, FluidPipeType fluidPipeType, GTRegistrate registrate) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s_%s_fluid_pipe".formatted(material.getName(), fluidPipeType.name), p -> new FluidPipeBlock((BlockBehaviour.Properties)p, fluidPipeType, material)).initialProperties(() -> Blocks.f_50075_).properties(p -> {
            if (GTBlocks.doMetalPipe(material)) {
                p.m_60918_(GTSoundTypes.METAL_PIPE);
            }
            return p.m_60988_().m_60955_().m_222994_();
        }).transform(GTBlocks.unificationBlock(fluidPipeType.tagPrefix, material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).build()).register();
        FLUID_PIPE_BLOCKS_BUILDER.put((Object)fluidPipeType.tagPrefix, (Object)material, (Object)entry);
    }

    private static void generateItemPipeBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Item Pipe Blocks...");
        for (ItemPipeType itemPipeType : ItemPipeType.values()) {
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!GTBlocks.allowItemPipeBlock(material, itemPipeType)) continue;
                    GTBlocks.registerItemPipeBlock(material, itemPipeType, registrate);
                }
            }
        }
        ITEM_PIPE_BLOCKS = ITEM_PIPE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.debug("Generating GTCEu Item Pipe Blocks... Complete!");
    }

    private static boolean allowItemPipeBlock(Material material, ItemPipeType itemPipeType) {
        return material.hasProperty(PropertyKey.ITEM_PIPE) && !itemPipeType.getTagPrefix().isIgnored(material);
    }

    private static void registerItemPipeBlock(Material material, ItemPipeType itemPipeType, GTRegistrate registrate) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s_%s_item_pipe".formatted(material.getName(), itemPipeType.name), p -> new ItemPipeBlock((BlockBehaviour.Properties)p, itemPipeType, material)).initialProperties(() -> Blocks.f_50075_).properties(p -> {
            if (GTBlocks.doMetalPipe(material)) {
                p.m_60918_(GTSoundTypes.METAL_PIPE);
            }
            return p.m_60988_().m_60955_().m_222994_();
        }).transform(GTBlocks.unificationBlock(itemPipeType.getTagPrefix(), material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).build()).register();
        ITEM_PIPE_BLOCKS_BUILDER.put((Object)itemPipeType.getTagPrefix(), (Object)material, (Object)entry);
    }

    private static void generateLaserPipeBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Laser Pipe Blocks...");
        for (int i = 0; i < LaserPipeType.values().length; ++i) {
            GTBlocks.registerLaserPipeBlock(i);
        }
        GTCEu.LOGGER.debug("Generating GTCEu Laser Pipe Blocks... Complete!");
    }

    private static void registerLaserPipeBlock(int slot) {
        BlockEntry entry;
        LaserPipeType type = LaserPipeType.values()[slot];
        GTBlocks.LASER_PIPES[slot] = entry = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_laser_pipe".formatted(type.m_7912_()), p -> new LaserPipeBlock((BlockBehaviour.Properties)p, type)).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60988_().m_60955_().m_222994_()).blockstate(NonNullBiConsumer.noop()).defaultLoot().tag(new TagKey[]{GTToolType.WIRE_CUTTER.harvestTags.get(0)}).addLayer(() -> RenderType::m_110457_).color(() -> LaserPipeBlock::tintedColor).item(LaserPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> LaserPipeBlockItem::tintColor).build()).register();
    }

    private static BlockEntry<Block> createPipeCasingBlock(String name, ResourceLocation texture) {
        return GTBlocks.createPipeCasingBlock(name, texture, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50075_));
    }

    private static BlockEntry<Block> createPipeCasingBlock(String name, ResourceLocation texture, NonNullSupplier<? extends Block> properties) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_pipe_casing".formatted(name.toLowerCase(Locale.ROOT)), p -> new RendererBlock((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new ResourceLocation("block/cube_all"), Map.of("all", texture)) : null))).lang("%s Pipe Casing".formatted(name)).initialProperties(properties).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    public static BlockEntry<Block> createCasingBlock(String name, ResourceLocation texture) {
        return GTBlocks.createCasingBlock(name, RendererBlock::new, texture, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50075_), () -> RenderType::m_110457_);
    }

    private static BlockEntry<Block> createGlassCasingBlock(String name, ResourceLocation texture, Supplier<Supplier<RenderType>> type) {
        return GTBlocks.createCasingBlock(name, RendererGlassBlock::new, texture, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50058_), type);
    }

    public static BlockEntry<Block> createCasingBlock(String name, BiFunction<BlockBehaviour.Properties, IRenderer, ? extends RendererBlock> blockSupplier, ResourceLocation texture, NonNullSupplier<? extends Block> properties, Supplier<Supplier<RenderType>> type) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(name, p -> (Block)blockSupplier.apply((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new ResourceLocation("block/cube_all"), Map.of("all", texture)) : null))).initialProperties(properties).addLayer(type).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static BlockEntry<Block> createMachineCasingBlock(int tier) {
        String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
        BlockEntry entry = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_machine_casing".formatted(tierName), p -> new RendererBlock((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(GTCEu.id("block/cube_bottom_top_tintindex"), Map.of("bottom", GTCEu.id("block/casings/voltage/%s/bottom".formatted(tierName)), "top", GTCEu.id("block/casings/voltage/%s/top".formatted(tierName)), "side", GTCEu.id("block/casings/voltage/%s/side".formatted(tierName)))) : null))).lang("%s Machine Casing".formatted(GTValues.VN[tier])).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        if (!GTCEuAPI.isHighTier() && tier > 9) {
            GTRegistration.REGISTRATE.setCreativeTab((RegistryEntry<?>)entry, null);
        }
        return entry;
    }

    private static BlockEntry<Block> createHermeticCasing(int tier) {
        String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
        BlockEntry entry = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_hermetic_casing".formatted(tierName), p -> new RendererBlock((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(GTCEu.id("block/hermetic_casing"), Map.of("bot_bottom", GTCEu.id("block/casings/voltage/%s/bottom".formatted(tierName)), "bot_top", GTCEu.id("block/casings/voltage/%s/top".formatted(tierName)), "bot_side", GTCEu.id("block/casings/voltage/%s/side".formatted(tierName)), "top_side", GTCEu.id("block/casings/hermetic_casing/hermetic_casing_overlay"))) : null))).lang("Hermetic Casing %s".formatted(GTValues.LVT[tier])).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        if (!GTCEuAPI.isHighTier() && tier > 9) {
            GTRegistration.REGISTRATE.setCreativeTab((RegistryEntry<?>)entry, null);
        }
        return entry;
    }

    private static BlockEntry<Block> createSteamCasing(String name, String material) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(name, p -> new RendererBlock((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new ResourceLocation("block/cube_bottom_top"), Map.of("bottom", GTCEu.id("block/casings/steam/%s/bottom".formatted(material)), "top", GTCEu.id("block/casings/steam/%s/top".formatted(material)), "side", GTCEu.id("block/casings/steam/%s/side".formatted(material)))) : null))).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static BlockEntry<CoilBlock> createCoilBlock(ICoilType coilType) {
        BlockEntry coilBlock = ((BlockBuilder)((ItemBuilder)GTRegistration.REGISTRATE.block("%s_coil_block".formatted(coilType.getName()), p -> new CoilBlock((BlockBehaviour.Properties)p, coilType)).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).onRegister(GTBlocks.compassNodeExist(GTCompassSections.BLOCKS, "coil_block", new CompassNode[0]))).build()).register();
        ALL_COILS.put(coilType, (Supplier<CoilBlock>)coilBlock);
        return coilBlock;
    }

    private static BlockEntry<BatteryBlock> createBatteryBlock(IBatteryData batteryData) {
        BlockEntry batteryBlock = ((BlockBuilder)((ItemBuilder)GTRegistration.REGISTRATE.block("%s_battery".formatted(batteryData.getBatteryName()), p -> new BatteryBlock((BlockBehaviour.Properties)p, batteryData, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new ResourceLocation("block/cube_bottom_top"), Map.of("bottom", GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/top"), "top", GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/top"), "side", GTCEu.id("block/casings/battery/" + batteryData.getBatteryName() + "/side"))) : null))).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).onRegister(GTBlocks.compassNodeExist(GTCompassSections.BLOCKS, "pss_battery", new CompassNode[0]))).build()).register();
        PSS_BATTERIES.put(batteryData, (Supplier<BatteryBlock>)batteryBlock);
        return batteryBlock;
    }

    private static BlockEntry<FusionCasingBlock> createFusionCasing(IFusionCasingType casingType) {
        BlockEntry casingBlock = ((BlockBuilder)GTRegistration.REGISTRATE.block(casingType.m_7912_(), p -> new FusionCasingBlock((BlockBehaviour.Properties)p, casingType)).initialProperties(() -> Blocks.f_50075_).properties(properties -> properties.m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56743_)).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), CustomTags.TOOL_TIERS[casingType.getHarvestLevel()]}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        ALL_FUSION_CASINGS.put(casingType, (Supplier<FusionCasingBlock>)casingBlock);
        return casingBlock;
    }

    private static BlockEntry<Block> createCleanroomFilter(IFilterType filterType) {
        BlockEntry filterBlock = ((BlockBuilder)GTRegistration.REGISTRATE.block(filterType.m_7912_(), p -> new RendererBlock((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new ResourceLocation("block/cube_all"), Map.of("all", GTCEu.id("block/casings/cleanroom/" + filterType))) : null))).initialProperties(() -> Blocks.f_50075_).properties(properties -> properties.m_60913_(2.0f, 8.0f).m_60918_(SoundType.f_56743_).m_60922_((blockState, blockGetter, blockPos, entityType) -> false)).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), CustomTags.TOOL_TIERS[1]}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        ALL_FILTERS.put(filterType, (Supplier<Block>)filterBlock);
        return filterBlock;
    }

    private static BlockEntry<ActiveBlock> createActiveCasing(String name, String baseModelPath) {
        String finalName = "%s".formatted(name);
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(finalName, p -> new ActiveBlock((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new CTMModelRenderer(GTCEu.id(baseModelPath)) : null), (IRenderer)(Platform.isClient() ? new CTMModelRenderer(GTCEu.id("%s_active".formatted(baseModelPath))) : null))).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static BlockEntry<ActiveBlock> createFireboxCasing(BoilerFireboxType type) {
        BlockEntry block = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_casing".formatted(type.name()), p -> new ActiveBlock((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new ResourceLocation("block/cube_bottom_top"), Map.of("bottom", type.bottom(), "top", type.top(), "side", type.side())) : null), (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(GTCEu.id("block/fire_box_active"), Map.of("bottom", type.bottom(), "top", type.top(), "side", type.side())) : null))).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        ALL_FIREBOXES.put(type, (BlockEntry<ActiveBlock>)block);
        return block;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor leavesBlockColor() {
        return (state, reader, pos, tintIndex) -> {
            if (reader != null && pos != null) {
                return BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos);
            }
            return FoliageColor.m_46113_();
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor leavesItemColor() {
        return (stack, tintIndex) -> FoliageColor.m_46113_();
    }

    public static <P, T extends Block, S2 extends BlockBuilder<T, P>> NonNullFunction<S2, S2> unificationBlock(@Nonnull TagPrefix tagPrefix, @Nonnull Material mat) {
        return builder -> {
            builder.onRegister(block -> {
                Supplier<Block> blockSupplier = SupplierMemoizer.memoizeBlockSupplier(() -> block);
                UnificationEntry entry = new UnificationEntry(tagPrefix, mat);
                GTItems.toUnify.put(entry, blockSupplier);
                ChemicalHelper.registerUnificationItems(entry, blockSupplier);
            });
            return builder;
        };
    }

    public static <T extends ItemLike> NonNullConsumer<T> compassNode(CompassSection section, CompassNode ... preNodes) {
        return item -> CompassNode.getOrCreate(section, () -> ((ItemLike)item).m_5456_()).addPreNode(preNodes);
    }

    public static <T extends ItemLike> NonNullConsumer<T> compassNodeExist(CompassSection section, String node, CompassNode ... preNodes) {
        return item -> CompassNode.getOrCreate(section, node).addPreNode(preNodes).addItem(() -> ((ItemLike)item).m_5456_());
    }

    public static void init() {
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_BLOCK);
        GTBlocks.generateMaterialBlocks();
        GTBlocks.generateOreBlocks();
        GTBlocks.generateOreIndicators();
        MATERIAL_BLOCKS = MATERIAL_BLOCKS_BUILDER.build();
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_PIPE);
        GTBlocks.generateCableBlocks();
        GTBlocks.generateFluidPipeBlocks();
        GTBlocks.generateItemPipeBlocks();
        GTBlocks.generateLaserPipeBlocks();
        MATERIAL_BLOCKS_BUILDER = null;
        SURFACE_ROCK_BLOCKS_BUILDER = null;
        CABLE_BLOCKS_BUILDER = null;
        FLUID_PIPE_BLOCKS_BUILDER = null;
        ITEM_PIPE_BLOCKS_BUILDER = null;
        GCyMBlocks.init();
    }

    public static boolean doMetalPipe(Material material) {
        return GTValues.FOOLS.get() != false && material.hasProperty(PropertyKey.INGOT) && !material.hasProperty(PropertyKey.POLYMER) && !material.hasProperty(PropertyKey.WOOD);
    }

    public static BlockBehaviour.Properties copy(BlockBehaviour.Properties props, BlockBehaviour.Properties newProps) {
        if (props == null) {
            return newProps;
        }
        newProps.m_155954_(((BlockPropertiesAccessor)props).getDestroyTime());
        newProps.m_155956_(((BlockPropertiesAccessor)props).getExplosionResistance());
        if (!((BlockPropertiesAccessor)props).isHasCollision()) {
            newProps.m_60910_();
        }
        if (((BlockPropertiesAccessor)props).isIsRandomlyTicking()) {
            newProps.m_60977_();
        }
        newProps.m_60953_(((BlockPropertiesAccessor)props).getLightEmission());
        newProps.m_284495_(((BlockPropertiesAccessor)props).getMapColor());
        newProps.m_60918_(((BlockPropertiesAccessor)props).getSoundType());
        newProps.m_60911_(((BlockPropertiesAccessor)props).getFriction());
        newProps.m_60956_(((BlockPropertiesAccessor)props).getSpeedFactor());
        if (((BlockPropertiesAccessor)props).isDynamicShape()) {
            newProps.m_60988_();
        }
        if (!((BlockPropertiesAccessor)props).isCanOcclude()) {
            newProps.m_60955_();
        }
        if (((BlockPropertiesAccessor)props).isIsAir()) {
            newProps.m_60996_();
        }
        if (((BlockPropertiesAccessor)props).isIgnitedByLava()) {
            newProps.m_278183_();
        }
        if (((BlockPropertiesAccessor)props).isLiquid()) {
            newProps.m_278788_();
        }
        if (((BlockPropertiesAccessor)props).isForceSolidOff()) {
            newProps.m_280574_();
        }
        if (((BlockPropertiesAccessor)props).isForceSolidOn()) {
            newProps.m_280606_();
        }
        newProps.m_278166_(((BlockPropertiesAccessor)props).getPushReaction());
        if (((BlockPropertiesAccessor)props).isRequiresCorrectToolForDrops()) {
            newProps.m_60999_();
        }
        ((BlockPropertiesAccessor)newProps).setOffsetFunction(((BlockPropertiesAccessor)props).getOffsetFunction());
        if (!((BlockPropertiesAccessor)props).isSpawnParticlesOnBreak()) {
            newProps.m_246721_();
        }
        ((BlockPropertiesAccessor)newProps).setRequiredFeatures(((BlockPropertiesAccessor)props).getRequiredFeatures());
        newProps.m_60991_(((BlockPropertiesAccessor)props).getEmissiveRendering());
        newProps.m_280658_(((BlockPropertiesAccessor)props).getInstrument());
        if (((BlockPropertiesAccessor)props).isReplaceable()) {
            newProps.m_280170_();
        }
        return newProps;
    }

    static {
        LASER_PIPES = new BlockEntry[LaserPipeType.values().length];
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_PIPE);
        LD_ITEM_PIPE = GTRegistration.REGISTRATE.block("long_distance_item_pipeline", properties -> new LongDistancePipeBlock((BlockBehaviour.Properties)properties, LDItemPipeType.INSTANCE)).initialProperties(() -> Blocks.f_50075_).blockstate(GTModels::longDistanceItemPipeModel).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_, BlockTags.f_144286_}).simpleItem().register();
        LD_FLUID_PIPE = GTRegistration.REGISTRATE.block("long_distance_fluid_pipeline", properties -> new LongDistancePipeBlock((BlockBehaviour.Properties)properties, LDFluidPipeType.INSTANCE)).initialProperties(() -> Blocks.f_50075_).blockstate(GTModels::longDistanceFluidPipeModel).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144282_, BlockTags.f_144286_}).simpleItem().register();
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.DECORATION);
        CASING_COKE_BRICKS = GTBlocks.createCasingBlock("coke_oven_bricks", GTCEu.id("block/casings/solid/machine_coke_bricks"));
        CASING_PRIMITIVE_BRICKS = GTBlocks.createCasingBlock("firebricks", GTCEu.id("block/casings/solid/machine_primitive_bricks"));
        CASING_BRONZE_BRICKS = GTBlocks.createCasingBlock("steam_machine_casing", GTCEu.id("block/casings/solid/machine_casing_bronze_plated_bricks"));
        CASING_INVAR_HEATPROOF = GTBlocks.createCasingBlock("heatproof_machine_casing", GTCEu.id("block/casings/solid/machine_casing_heatproof"));
        CASING_ALUMINIUM_FROSTPROOF = GTBlocks.createCasingBlock("frostproof_machine_casing", GTCEu.id("block/casings/solid/machine_casing_frost_proof"));
        CASING_STEEL_SOLID = GTBlocks.createCasingBlock("solid_machine_casing", GTCEu.id("block/casings/solid/machine_casing_solid_steel"));
        CASING_STAINLESS_CLEAN = GTBlocks.createCasingBlock("clean_machine_casing", GTCEu.id("block/casings/solid/machine_casing_clean_stainless_steel"));
        CASING_TITANIUM_STABLE = GTBlocks.createCasingBlock("stable_machine_casing", GTCEu.id("block/casings/solid/machine_casing_stable_titanium"));
        CASING_TUNGSTENSTEEL_ROBUST = GTBlocks.createCasingBlock("robust_machine_casing", GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"));
        CASING_PTFE_INERT = GTBlocks.createCasingBlock("inert_machine_casing", GTCEu.id("block/casings/solid/machine_casing_inert_ptfe"));
        CASING_HSSE_STURDY = GTBlocks.createCasingBlock("sturdy_machine_casing", GTCEu.id("block/casings/solid/machine_casing_sturdy_hsse"));
        CASING_PALLADIUM_SUBSTATION = GTBlocks.createCasingBlock("palladium_substation", GTCEu.id("block/casings/solid/machine_casing_palladium_substation"));
        CASING_TEMPERED_GLASS = GTBlocks.createGlassCasingBlock("tempered_glass", GTCEu.id("block/casings/transparent/tempered_glass"), () -> RenderType::m_110466_);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)GTMaterials.Bronze, CASING_BRONZE_BRICKS);
        builder.put((Object)GTMaterials.Invar, CASING_INVAR_HEATPROOF);
        builder.put((Object)GTMaterials.Aluminium, CASING_ALUMINIUM_FROSTPROOF);
        builder.put((Object)GTMaterials.Steel, CASING_STEEL_SOLID);
        builder.put((Object)GTMaterials.StainlessSteel, CASING_STAINLESS_CLEAN);
        builder.put((Object)GTMaterials.Titanium, CASING_TITANIUM_STABLE);
        builder.put((Object)GTMaterials.TungstenSteel, CASING_TUNGSTENSTEEL_ROBUST);
        builder.put((Object)GTMaterials.Polytetrafluoroethylene, CASING_PTFE_INERT);
        builder.put((Object)GTMaterials.HSSE, CASING_HSSE_STURDY);
        builder.put((Object)GTMaterials.HSLASteel, GCyMBlocks.CASING_NONCONDUCTING);
        builder.put((Object)GTMaterials.IncoloyMA956, GCyMBlocks.CASING_VIBRATION_SAFE);
        builder.put((Object)GTMaterials.WatertightSteel, GCyMBlocks.CASING_WATERTIGHT);
        builder.put((Object)GTMaterials.Zeron100, GCyMBlocks.CASING_SECURE_MACERATION);
        builder.put((Object)GTMaterials.TungstenCarbide, GCyMBlocks.CASING_HIGH_TEMPERATURE_SMELTING);
        builder.put((Object)GTMaterials.TitaniumTungstenCarbide, GCyMBlocks.CASING_LASER_SAFE_ENGRAVING);
        builder.put((Object)GTMaterials.Stellite100, GCyMBlocks.CASING_LARGE_SCALE_ASSEMBLING);
        builder.put((Object)GTMaterials.HastelloyC276, GCyMBlocks.CASING_SHOCK_PROOF);
        MaterialCasingCollectionEvent event = new MaterialCasingCollectionEvent((ImmutableMap.Builder<Material, BlockEntry<Block>>)builder);
        AddonFinder.getAddons().forEach(addon -> addon.collectMaterialCasings(event));
        MATERIALS_TO_CASINGS = builder.build();
        CASING_GRATE = GTBlocks.createCasingBlock("assembly_line_grating", GTCEu.id("block/casings/pipe/machine_casing_grate"));
        CASING_ASSEMBLY_CONTROL = GTBlocks.createCasingBlock("assembly_line_casing", GTCEu.id("block/casings/mechanic/machine_casing_assembly_control"));
        CASING_LAMINATED_GLASS = GTBlocks.createGlassCasingBlock("laminated_glass", GTCEu.id("block/casings/transparent/laminated_glass"), () -> RenderType::m_110457_);
        CASING_ASSEMBLY_LINE = GTBlocks.createActiveCasing("assembly_line_unit", "block/variant/assembly_line");
        CASING_BRONZE_GEARBOX = GTBlocks.createCasingBlock("bronze_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_bronze"));
        CASING_STEEL_GEARBOX = GTBlocks.createCasingBlock("steel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_steel"));
        CASING_STAINLESS_STEEL_GEARBOX = GTBlocks.createCasingBlock("stainless_steel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_stainless_steel"));
        CASING_TITANIUM_GEARBOX = GTBlocks.createCasingBlock("titanium_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_titanium"));
        CASING_TUNGSTENSTEEL_GEARBOX = GTBlocks.createCasingBlock("tungstensteel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_tungstensteel"));
        CASING_STEEL_TURBINE = GTBlocks.createCasingBlock("steel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_steel"));
        CASING_TITANIUM_TURBINE = GTBlocks.createCasingBlock("titanium_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_titanium"));
        CASING_STAINLESS_TURBINE = GTBlocks.createCasingBlock("stainless_steel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_stainless_steel"));
        CASING_TUNGSTENSTEEL_TURBINE = GTBlocks.createCasingBlock("tungstensteel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_tungstensteel"));
        CASING_BRONZE_PIPE = GTBlocks.createCasingBlock("bronze_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_bronze"));
        CASING_STEEL_PIPE = GTBlocks.createCasingBlock("steel_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_steel"));
        CASING_TITANIUM_PIPE = GTBlocks.createCasingBlock("titanium_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_titanium"));
        CASING_TUNGSTENSTEEL_PIPE = GTBlocks.createCasingBlock("tungstensteel_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_tungstensteel"));
        CASING_POLYTETRAFLUOROETHYLENE_PIPE = GTBlocks.createPipeCasingBlock("ptfe", GTCEu.id("block/casings/pipe/machine_casing_pipe_polytetrafluoroethylene"));
        MINER_PIPE = GTRegistration.REGISTRATE.block("miner_pipe", MinerPipeBlock::new).initialProperties(() -> Blocks.f_50752_).properties(BlockBehaviour.Properties::m_60955_).addLayer(() -> RenderType::m_110457_).blockstate((ctx, prov) -> GTModels.createModelBlockState((DataGenContext<Block, ? extends Block>)ctx, prov, GTCEu.id("block/miner_pipe"))).tag(new TagKey[]{BlockTags.f_13069_, BlockTags.f_13070_, BlockTags.f_13060_, BlockTags.f_144287_, BlockTags.f_144289_}).register();
        CASING_PUMP_DECK = ((BlockBuilder)GTRegistration.REGISTRATE.block("pump_deck", p -> new RendererBlock((BlockBehaviour.Properties)p, (IRenderer)(Platform.isClient() ? new TextureOverrideRenderer(new ResourceLocation("block/cube_bottom_top"), Map.of("bottom", GTCEu.id("block/casings/pump_deck/bottom"), "top", GTCEu.id("block/casings/pump_deck/top"), "side", GTCEu.id("block/casings/pump_deck/side"))) : null))).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283825_)).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).tag(new TagKey[]{GTToolType.WRENCH.harvestTags.get(0), BlockTags.f_144280_}).item(RendererBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
        MACHINE_CASING_ULV = GTBlocks.createMachineCasingBlock(0);
        MACHINE_CASING_LV = GTBlocks.createMachineCasingBlock(1);
        MACHINE_CASING_MV = GTBlocks.createMachineCasingBlock(2);
        MACHINE_CASING_HV = GTBlocks.createMachineCasingBlock(3);
        MACHINE_CASING_EV = GTBlocks.createMachineCasingBlock(4);
        MACHINE_CASING_IV = GTBlocks.createMachineCasingBlock(5);
        MACHINE_CASING_LuV = GTBlocks.createMachineCasingBlock(6);
        MACHINE_CASING_ZPM = GTBlocks.createMachineCasingBlock(7);
        MACHINE_CASING_UV = GTBlocks.createMachineCasingBlock(8);
        MACHINE_CASING_UHV = GTBlocks.createMachineCasingBlock(9);
        MACHINE_CASING_UEV = GTBlocks.createMachineCasingBlock(10);
        MACHINE_CASING_UIV = GTBlocks.createMachineCasingBlock(11);
        MACHINE_CASING_UXV = GTBlocks.createMachineCasingBlock(12);
        MACHINE_CASING_OpV = GTBlocks.createMachineCasingBlock(13);
        MACHINE_CASING_MAX = GTBlocks.createMachineCasingBlock(14);
        HERMETIC_CASING_LV = GTBlocks.createHermeticCasing(1);
        HERMETIC_CASING_MV = GTBlocks.createHermeticCasing(2);
        HERMETIC_CASING_HV = GTBlocks.createHermeticCasing(3);
        HERMETIC_CASING_EV = GTBlocks.createHermeticCasing(4);
        HERMETIC_CASING_IV = GTBlocks.createHermeticCasing(5);
        HERMETIC_CASING_LuV = GTBlocks.createHermeticCasing(6);
        HERMETIC_CASING_ZPM = GTBlocks.createHermeticCasing(7);
        HERMETIC_CASING_UV = GTBlocks.createHermeticCasing(8);
        HERMETIC_CASING_UHV = GTBlocks.createHermeticCasing(9);
        BRONZE_HULL = GTBlocks.createSteamCasing("bronze_machine_casing", "bronze");
        BRONZE_BRICKS_HULL = GTBlocks.createSteamCasing("bronze_brick_casing", "bricked_bronze");
        STEEL_HULL = GTBlocks.createSteamCasing("steel_machine_casing", "steel");
        STEEL_BRICKS_HULL = GTBlocks.createSteamCasing("steel_brick_casing", "bricked_steel");
        ALL_COILS = new HashMap<ICoilType, Supplier<CoilBlock>>();
        COIL_CUPRONICKEL = GTBlocks.createCoilBlock(CoilBlock.CoilType.CUPRONICKEL);
        COIL_KANTHAL = GTBlocks.createCoilBlock(CoilBlock.CoilType.KANTHAL);
        COIL_NICHROME = GTBlocks.createCoilBlock(CoilBlock.CoilType.NICHROME);
        COIL_RTMALLOY = GTBlocks.createCoilBlock(CoilBlock.CoilType.RTMALLOY);
        COIL_HSSG = GTBlocks.createCoilBlock(CoilBlock.CoilType.HSSG);
        COIL_NAQUADAH = GTBlocks.createCoilBlock(CoilBlock.CoilType.NAQUADAH);
        COIL_TRINIUM = GTBlocks.createCoilBlock(CoilBlock.CoilType.TRINIUM);
        COIL_TRITANIUM = GTBlocks.createCoilBlock(CoilBlock.CoilType.TRITANIUM);
        PSS_BATTERIES = new HashMap<IBatteryData, Supplier<BatteryBlock>>();
        BATTERY_EMPTY_TIER_I = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_I);
        BATTERY_LAPOTRONIC_EV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EV_LAPOTRONIC);
        BATTERY_LAPOTRONIC_IV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.IV_LAPOTRONIC);
        BATTERY_EMPTY_TIER_II = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_II);
        BATTERY_LAPOTRONIC_LuV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.LuV_LAPOTRONIC);
        BATTERY_LAPOTRONIC_ZPM = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.ZPM_LAPOTRONIC);
        BATTERY_EMPTY_TIER_III = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_III);
        BATTERY_LAPOTRONIC_UV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.UV_LAPOTRONIC);
        BATTERY_ULTIMATE_UHV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.UHV_ULTIMATE);
        CASING_ENGINE_INTAKE = GTBlocks.createActiveCasing("engine_intake_casing", "block/variant/engine_intake");
        CASING_EXTREME_ENGINE_INTAKE = GTBlocks.createActiveCasing("extreme_engine_intake_casing", "block/variant/extreme_engine_intake");
        ALL_FUSION_CASINGS = new HashMap<IFusionCasingType, Supplier<FusionCasingBlock>>();
        SUPERCONDUCTING_COIL = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.SUPERCONDUCTING_COIL);
        FUSION_COIL = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_COIL);
        FUSION_CASING = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING);
        FUSION_CASING_MK2 = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING_MK2);
        FUSION_CASING_MK3 = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING_MK3);
        FUSION_GLASS = GTBlocks.createGlassCasingBlock("fusion_glass", GTCEu.id("block/casings/transparent/fusion_glass"), () -> RenderType::m_110457_);
        ALL_FILTERS = new HashMap<IFilterType, Supplier<Block>>();
        PLASTCRETE = GTBlocks.createCasingBlock("plascrete", GTCEu.id("block/casings/cleanroom/plascrete"));
        FILTER_CASING = GTBlocks.createCleanroomFilter(CleanroomFilterType.FILTER_CASING);
        FILTER_CASING_STERILE = GTBlocks.createCleanroomFilter(CleanroomFilterType.FILTER_CASING_STERILE);
        CLEANROOM_GLASS = GTBlocks.createGlassCasingBlock("cleanroom_glass", GTCEu.id("block/casings/transparent/cleanroom_glass"), () -> RenderType::m_110457_);
        ALL_FIREBOXES = new HashMap<BoilerFireboxType, BlockEntry<ActiveBlock>>();
        FIREBOX_BRONZE = GTBlocks.createFireboxCasing(BoilerFireboxType.BRONZE_FIREBOX);
        FIREBOX_STEEL = GTBlocks.createFireboxCasing(BoilerFireboxType.STEEL_FIREBOX);
        FIREBOX_TITANIUM = GTBlocks.createFireboxCasing(BoilerFireboxType.TITANIUM_FIREBOX);
        FIREBOX_TUNGSTENSTEEL = GTBlocks.createFireboxCasing(BoilerFireboxType.TUNGSTENSTEEL_FIREBOX);
        HIGH_POWER_CASING = GTBlocks.createCasingBlock("high_power_casing", GTCEu.id("block/casings/hpca/high_power_casing"));
        RUBBER_SAPLING = ((BlockBuilder)((ItemBuilder)GTRegistration.REGISTRATE.block("rubber_sapling", properties -> new SaplingBlock(new AbstractTreeGrower(){

            protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(@Nonnull RandomSource random, boolean largeHive) {
                return GTConfiguredFeatures.RUBBER;
            }
        }, properties)).initialProperties(() -> Blocks.f_50746_).lang("Rubber Sapling").blockstate(GTModels::createCrossBlockState).addLayer(() -> RenderType::m_110457_).tag(new TagKey[]{BlockTags.f_13104_}).item().model(GTModels::rubberTreeSaplingModel).tag(new TagKey[]{ItemTags.f_13180_}).onRegister(GTBlocks.compassNode(GTCompassSections.GENERATIONS, new CompassNode[0]))).build()).register();
        RUBBER_LOG = ((BlockBuilder)((ItemBuilder)GTRegistration.REGISTRATE.block("rubber_log", RubberLogBlock::new).properties(p -> p.m_60978_(2.0f).m_60918_(SoundType.f_56736_)).loot((table, block) -> table.m_247577_((Block)block, LootTable.m_79147_().m_79161_(((LootPool.Builder)table.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block))).m_79161_(((LootPool.Builder)table.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GTItems.STICKY_RESIN.get())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)RubberLogBlock.NATURAL, true)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.85f)))))).lang("Rubber Log").tag(new TagKey[]{BlockTags.f_13105_}).blockstate((ctx, provider) -> provider.logBlock((RotatedPillarBlock)ctx.get())).item().tag(new TagKey[]{ItemTags.f_13181_}).onRegister(GTBlocks.compassNode(GTCompassSections.GENERATIONS, new CompassNode[0]))).build()).register();
        RUBBER_LEAVES_DROPPING_CHANCE = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        RUBBER_LEAVES = ((BlockBuilder)((ItemBuilder)GTRegistration.REGISTRATE.block("rubber_leaves", LeavesBlock::new).initialProperties(() -> Blocks.f_50050_).lang("Rubber Leaves").blockstate((ctx, prov) -> GTModels.createModelBlockState((DataGenContext<Block, ? extends Block>)ctx, prov, GTCEu.id("block/rubber_leaves"))).loot((table, block) -> table.m_247577_((Block)block, table.m_246047_((Block)block, (Block)RUBBER_SAPLING.get(), RUBBER_LEAVES_DROPPING_CHANCE))).tag(new TagKey[]{BlockTags.f_13035_, BlockTags.f_144281_}).color(() -> GTBlocks::leavesBlockColor).item().color(() -> GTBlocks::leavesItemColor).tag(new TagKey[]{ItemTags.f_13143_}).onRegister(GTBlocks.compassNode(GTCompassSections.GENERATIONS, new CompassNode[0]))).build()).register();
        RUBBER_PLANK = ((BlockBuilder)((ItemBuilder)GTRegistration.REGISTRATE.block("rubber_planks", Block::new).initialProperties(() -> Blocks.f_50705_).lang("Rubber Planks").properties(p -> p.m_284180_(MapColor.f_283861_)).tag(new TagKey[]{BlockTags.f_13090_}).item().tag(new TagKey[]{ItemTags.f_13168_}).onRegister(GTBlocks.compassNode(GTCompassSections.GENERATIONS, new CompassNode[0]))).build()).register();
        TREATED_WOOD_PLANK = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_planks", Block::new).initialProperties(() -> Blocks.f_50705_).lang("Treated Wood Planks").properties(p -> p.m_284180_(MapColor.f_283861_)).tag(new TagKey[]{BlockTags.f_13090_}).item().tag(new TagKey[]{TagUtil.createItemTag("treated_wood")}).build()).register();
    }
}

