/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.gui.widget.ProspectingMapWidget;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ProspectorScannerBehavior
implements IItemUIFactory,
IInteractionItem,
IAddInformation {
    private final int radius;
    private final long cost;
    private final ProspectorMode<?>[] modes;

    public ProspectorScannerBehavior(int radius, long cost, ProspectorMode<?> ... modes) {
        this.radius = radius + 1;
        this.modes = (ProspectorMode[])Arrays.stream(modes).filter(Objects::nonNull).toArray(ProspectorMode[]::new);
        this.cost = cost;
    }

    @Nonnull
    public ProspectorMode<?> getMode(ItemStack stack) {
        if (stack == ItemStack.f_41583_) {
            return this.modes[0];
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return this.modes[0];
        }
        return this.modes[tag.m_128451_("Mode") % this.modes.length];
    }

    public void setNextMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Mode", (tag.m_128451_("Mode") + 1) % this.modes.length);
    }

    public boolean drainEnergy(@Nonnull ItemStack stack, boolean simulate) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(this.cost, Integer.MAX_VALUE, true, false, simulate) >= this.cost;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack heldItem = player.m_21120_(usedHand);
        if (player.m_6144_() && this.modes.length > 1) {
            if (!level.f_46443_) {
                this.setNextMode(heldItem);
                ProspectorMode<?> mode = this.getMode(heldItem);
                player.m_213846_((Component)Component.m_237115_((String)mode.unlocalizedName));
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        if (!player.m_7500_() && !this.drainEnergy(heldItem, true)) {
            player.m_213846_((Component)Component.m_237115_((String)"behavior.prospector.not_enough_energy"));
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return IItemUIFactory.super.use(item, level, player, usedHand);
    }

    @Override
    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder holder, Player entityPlayer) {
        ProspectorMode<?> mode = this.getMode(entityPlayer.m_21120_(InteractionHand.MAIN_HAND));
        ProspectingMapWidget map = new ProspectingMapWidget(4, 4, 324, 192, this.radius, mode, 1);
        return new ModularUI(332, 200, (IUIHolder)holder, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)map).widget((Widget)new SwitchWidget(-20, 4, 18, 18, (cd, pressed) -> map.setDarkMode((boolean)pressed)).setSupplier(map::isDarkMode).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.5, 1.0, 0.5).scale(0.8f)}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.0, 1.0, 0.5).scale(0.8f)})));
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.prospector.tooltip.radius", (Object[])new Object[]{this.radius}));
        tooltipComponents.add((Component)Component.m_237115_((String)"metaitem.prospector.tooltip.modes"));
        for (ProspectorMode<?> mode : this.modes) {
            tooltipComponents.add((Component)Component.m_237113_((String)" -").m_7220_((Component)Component.m_237115_((String)mode.unlocalizedName)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
    }
}

