/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.RotorProperty;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IMaterialPartItem;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TurbineRotorBehaviour
implements IMaterialPartItem,
ISubItemHandler {
    @Override
    public void fillItemCategory(ComponentItem item, CreativeModeTab category, NonNullList<ItemStack> items) {
        TagPrefix.turbineBlade.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> {
            ItemStack rotorStack = new ItemStack((ItemLike)item);
            TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(rotorStack);
            if (behavior != null) {
                behavior.setPartMaterial(rotorStack, (Material)material);
                items.add((Object)rotorStack);
            }
        });
    }

    @Override
    public int getPartMaxDurability(ItemStack itemStack) {
        RotorProperty property = this.getPartMaterial(itemStack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : 800 * (int)Math.pow(property.getDurability(), 0.65);
    }

    public int getRotorEfficiency(ItemStack stack) {
        RotorProperty property = this.getPartMaterial(stack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : (int)(60.0f + property.getSpeed() * 8.0f) / 5 * 5;
    }

    public int getRotorDurabilityPercent(ItemStack itemStack) {
        return 100 - 100 * this.getPartDamage(itemStack) / this.getPartMaxDurability(itemStack);
    }

    public void applyRotorDamage(ItemStack itemStack, int damageApplied) {
        int rotorDurability = this.getPartMaxDurability(itemStack);
        int resultDamage = this.getPartDamage(itemStack) + damageApplied;
        if (resultDamage >= rotorDurability) {
            itemStack.m_41774_(1);
        } else {
            this.setPartDamage(itemStack, resultDamage);
        }
    }

    public int getRotorPower(ItemStack stack) {
        RotorProperty property = this.getPartMaterial(stack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : (int)(40.0f + property.getDamage() * 30.0f);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        IMaterialPartItem.super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.tool.tooltip.rotor.efficiency", (Object[])new Object[]{this.getRotorEfficiency(stack)}));
        tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.tool.tooltip.rotor.power", (Object[])new Object[]{this.getRotorPower(stack)}));
    }

    @javax.annotation.Nullable
    public static TurbineRotorBehaviour getBehaviour(@Nonnull ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ComponentItem) {
            ComponentItem componentItem = (ComponentItem)item;
            for (IItemComponent component : componentItem.getComponents()) {
                if (!(component instanceof TurbineRotorBehaviour)) continue;
                TurbineRotorBehaviour behaviour = (TurbineRotorBehaviour)component;
                return behaviour;
            }
        }
        return null;
    }
}

