/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="gtceu")
public class ToolEventHandlers {
    public static void onPlayerDestroyItem(ItemStack original, InteractionHand hand, Player player) {
        Item item = original.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool def = (IGTTool)item;
            ItemStack brokenStack = def.getToolStats().getBrokenStack();
            if (GTCapabilityHelper.getElectricItem(brokenStack) != null && def.isElectric()) {
                long remainingCharge = def.getCharge(original);
                IElectricItem electricStack = GTCapabilityHelper.getElectricItem(brokenStack);
                if (electricStack != null) {
                    if (electricStack instanceof ElectricItem) {
                        ElectricItem electricItem = (ElectricItem)electricStack;
                        electricItem.setMaxChargeOverride(def.getMaxCharge(original));
                    }
                    electricStack.charge(Math.min(remainingCharge, def.getMaxCharge(original)), def.getElectricTier(), true, false);
                }
            }
            if (!brokenStack.m_41619_()) {
                if (hand == null) {
                    if (!player.m_36356_(brokenStack)) {
                        player.m_36176_(brokenStack, true);
                    }
                } else {
                    player.m_21008_(hand, brokenStack);
                }
            }
        }
    }

    public static InteractionResult onPlayerEntityInteract(Player player, InteractionHand hand, Entity target) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool def = (IGTTool)item;
            if (target instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)target;
                ItemStack brokenStack = def.getToolStats().getBrokenStack();
                if (!brokenStack.m_41619_()) {
                    itemFrame.m_6096_(player, hand);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static ObjectArrayList<ItemStack> onHarvestDrops(@Nullable Player player, ItemStack tool, Level world, BlockPos pos, BlockState state, boolean isSilkTouch, int fortuneLevel, ObjectArrayList<ItemStack> drops, float dropChance) {
        if (player != null && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (tool.m_41619_() || !tool.m_41782_() || !(tool.m_41720_() instanceof IGTTool)) {
                return drops;
            }
            if (!isSilkTouch) {
                ToolHelper.applyHammerDropConversion(serverLevel, pos, tool, state, drops, fortuneLevel, dropChance, player.m_217043_());
            }
            if (!ToolHelper.hasBehaviorsTag(tool)) {
                return drops;
            }
            CompoundTag behaviorTag = ToolHelper.getBehaviorsTag(tool);
            Block block = state.m_60734_();
            if (!isSilkTouch && state.m_204336_(BlockTags.f_13047_) && behaviorTag.m_128471_("HarvestIce")) {
                Item iceBlock = block.m_5456_();
                if (drops.stream().noneMatch(drop -> drop.m_41720_() == iceBlock)) {
                    drops.add((Object)new ItemStack((ItemLike)iceBlock));
                    world.m_7654_().m_6937_((Runnable)new TickTask(0, () -> {
                        FluidState flowingState = world.m_6425_(pos);
                        if (flowingState == Fluids.f_76192_.m_76145_()) {
                            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        }
                    }));
                    ((IGTTool)tool.m_41720_()).playSound(player);
                }
            }
            if (behaviorTag.m_128471_("RelocateMinedBlocks")) {
                ObjectListIterator dropItr = drops.iterator();
                while (dropItr.hasNext()) {
                    ItemStack dropStack = (ItemStack)dropItr.next();
                    ItemEntity drop2 = new ItemEntity(EntityType.f_20461_, world);
                    drop2.m_32045_(dropStack);
                    if (ToolEventHandlers.fireItemPickupEvent(drop2, player) != -1 && !player.m_36356_(dropStack)) continue;
                    dropItr.remove();
                }
            }
        }
        return drops;
    }

    public static int fireItemPickupEvent(ItemEntity drop, Player player) {
        return ForgeEventFactory.onItemPickup((ItemEntity)drop, (Player)player);
    }

    public static boolean onAnvilUpdateEvent(ItemStack left, ItemStack right) {
        Item item = left.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool leftTool = (IGTTool)item;
            item = right.m_41720_();
            if (item instanceof IGTTool) {
                IGTTool rightTool = (IGTTool)item;
                if (leftTool.getToolMaterial(left) != rightTool.getToolMaterial(right)) {
                    return false;
                }
                if (leftTool.isElectric() || rightTool.isElectric()) {
                    return false;
                }
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void onPlayerDestroyItem(@NotNull PlayerDestroyItemEvent event) {
        ToolEventHandlers.onPlayerDestroyItem(event.getOriginal(), event.getHand(), event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerEntityInteract(@NotNull PlayerInteractEvent.EntityInteract event) {
        InteractionResult result = ToolEventHandlers.onPlayerEntityInteract(event.getEntity(), event.getHand(), event.getTarget());
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        if (!ToolEventHandlers.onAnvilUpdateEvent(event.getLeft(), event.getRight())) {
            event.setCanceled(true);
        }
    }
}

