/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMufflerMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.machine.electric.HullMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DiodePartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.CokeOvenMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveBlastFurnaceMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitivePumpMachine;
import com.gregtechceu.gtceu.common.machine.trait.CleanroomLogic;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CleanroomMachine
extends WorkableElectricMultiblockMachine
implements ICleanroomProvider,
IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CleanroomMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    public static final int CLEAN_AMOUNT_THRESHOLD = 90;
    public static final int MIN_CLEAN_AMOUNT = 0;
    public static final int MIN_RADIUS = 2;
    public static final int MIN_DEPTH = 4;
    @Persisted
    private int lDist = 0;
    @Persisted
    private int rDist = 0;
    @Persisted
    private int bDist = 0;
    @Persisted
    private int fDist = 0;
    @Persisted
    private int hDist = 0;
    @Nullable
    private CleanroomType cleanroomType = null;
    @Persisted
    private int cleanAmount;
    @Nullable
    private EnergyContainerList inputEnergyContainers;
    @Nullable
    private Collection<ICleanroomReceiver> cleanroomReceivers;

    public CleanroomMachine(IMachineBlockEntity metaTileEntityId) {
        super(metaTileEntityId, new Object[0]);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new CleanroomLogic(this);
    }

    @Override
    @Nonnull
    public CleanroomLogic getRecipeLogic() {
        return (CleanroomLogic)super.getRecipeLogic();
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.initializeAbilities();
        IFilterType filterType = (IFilterType)this.getMultiblockState().getMatchContext().get("FilterType");
        this.cleanroomType = filterType != null ? filterType.getCleanroomType() : CleanroomType.CLEANROOM;
        if (this.cleanroomReceivers != null) {
            this.cleanroomReceivers.forEach(receiver -> receiver.setCleanroom(null));
            this.cleanroomReceivers = null;
        }
        Set receivers = this.getMultiblockState().getMatchContext().getOrCreate("cleanroomReceiver", Sets::newHashSet);
        this.cleanroomReceivers = ImmutableSet.copyOf((Collection)receivers);
        this.cleanroomReceivers.forEach(receiver -> receiver.setCleanroom(this));
        this.getRecipeLogic().setDuration(Math.max(100, (this.lDist + this.rDist + 1) * (this.bDist + this.fDist + 1) * this.hDist - (this.lDist + this.rDist + 1) * (this.bDist + this.fDist + 1)));
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.inputEnergyContainers = null;
        this.cleanAmount = 0;
        if (this.cleanroomReceivers != null) {
            this.cleanroomReceivers.forEach(receiver -> receiver.setCleanroom(null));
            this.cleanroomReceivers = null;
        }
    }

    @Override
    public boolean shouldAddPartToController(IMultiPart part) {
        Collection<BlockPos> cache = this.getMultiblockState().getCache();
        for (Direction side : GTUtil.DIRECTIONS) {
            if (cache.contains(part.self().getPos().m_121945_(side))) continue;
            return true;
        }
        return false;
    }

    protected void initializeAbilities() {
        ArrayList<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io;
            if (CleanroomMachine.isPartIgnored(part) || (io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH)) == IO.NONE || io == IO.OUT) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                if (io != IO.BOTH && handler.getHandlerIO() != IO.BOTH && io != handler.getHandlerIO() || handler.getCapability() != EURecipeCapability.CAP || !(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)((Object)handler);
                energyContainers.add(container);
            }
            if (!(part instanceof IMaintenanceMachine)) continue;
            IMaintenanceMachine maintenanceMachine = (IMaintenanceMachine)part;
            this.getRecipeLogic().setMaintenanceMachine(maintenanceMachine);
        }
        this.inputEnergyContainers = new EnergyContainerList(energyContainers);
        this.getRecipeLogic().setEnergyContainer(this.inputEnergyContainers);
    }

    private static boolean isPartIgnored(IMultiPart part) {
        if (part instanceof DiodePartMachine) {
            return true;
        }
        return part instanceof HullMachine;
    }

    public void updateStructureDimensions() {
        int i;
        Level world = this.getLevel();
        Direction front = this.getFrontFacing();
        Direction back = front.m_122424_();
        Direction left = front.m_122428_();
        Direction right = left.m_122424_();
        BlockPos.MutableBlockPos lPos = this.getPos().m_122032_();
        BlockPos.MutableBlockPos rPos = this.getPos().m_122032_();
        BlockPos.MutableBlockPos fPos = this.getPos().m_122032_();
        BlockPos.MutableBlockPos bPos = this.getPos().m_122032_();
        BlockPos.MutableBlockPos hPos = this.getPos().m_122032_();
        int lDist = 0;
        int rDist = 0;
        int bDist = 0;
        int fDist = 0;
        int hDist = 0;
        for (i = 1; i < 8; ++i) {
            if (lDist == 0 && this.isBlockEdge(world, lPos, left)) {
                lDist = i;
            }
            if (rDist == 0 && this.isBlockEdge(world, rPos, right)) {
                rDist = i;
            }
            if (bDist == 0 && this.isBlockEdge(world, bPos, back)) {
                bDist = i;
            }
            if (fDist == 0 && this.isBlockEdge(world, fPos, front)) {
                fDist = i;
            }
            if (lDist != 0 && rDist != 0 && bDist != 0 && fDist != 0) break;
        }
        for (i = 1; i < 15; ++i) {
            if (this.isBlockFloor(world, hPos, Direction.DOWN)) {
                hDist = i;
            }
            if (hDist != 0) break;
        }
        if (lDist < 2 || rDist < 2 || bDist < 2 || fDist < 2 || hDist < 4) {
            this.isFormed = false;
            return;
        }
        this.lDist = lDist;
        this.rDist = rDist;
        this.bDist = bDist;
        this.fDist = fDist;
        this.hDist = hDist;
    }

    public boolean isBlockEdge(@Nonnull Level world, @Nonnull BlockPos.MutableBlockPos pos, @Nonnull Direction direction) {
        return world.m_8055_((BlockPos)pos.m_122173_(direction)) == GTBlocks.PLASTCRETE.getDefaultState();
    }

    public boolean isBlockFloor(@Nonnull Level world, @Nonnull BlockPos.MutableBlockPos pos, @Nonnull Direction direction) {
        return this.isBlockEdge(world, pos, direction) || world.m_8055_((BlockPos)pos) == GTBlocks.CLEANROOM_GLASS.getDefaultState();
    }

    @Override
    @Nonnull
    public BlockPattern getPattern() {
        int i;
        if (this.getLevel() != null) {
            this.updateStructureDimensions();
        }
        if (this.lDist < 2) {
            this.lDist = 2;
        }
        if (this.rDist < 2) {
            this.rDist = 2;
        }
        if (this.bDist < 2) {
            this.bDist = 2;
        }
        if (this.fDist < 2) {
            this.fDist = 2;
        }
        if (this.hDist < 4) {
            this.hDist = 4;
        }
        if (this.getFrontFacing() == Direction.EAST || this.getFrontFacing() == Direction.WEST) {
            int tmp = this.lDist;
            this.lDist = this.rDist;
            this.rDist = tmp;
        }
        StringBuilder borderBuilder = new StringBuilder();
        StringBuilder wallBuilder = new StringBuilder();
        StringBuilder insideBuilder = new StringBuilder();
        StringBuilder roofBuilder = new StringBuilder();
        StringBuilder controllerBuilder = new StringBuilder();
        StringBuilder centerBuilder = new StringBuilder();
        for (i = 0; i < this.lDist; ++i) {
            borderBuilder.append("B");
            if (i == 0) {
                wallBuilder.append("B");
                insideBuilder.append("X");
                roofBuilder.append("B");
                controllerBuilder.append("B");
                centerBuilder.append("B");
                continue;
            }
            insideBuilder.append(" ");
            wallBuilder.append("X");
            roofBuilder.append("F");
            controllerBuilder.append("F");
            centerBuilder.append("X");
        }
        borderBuilder.append("B");
        wallBuilder.append("X");
        insideBuilder.append(" ");
        roofBuilder.append("F");
        controllerBuilder.append("S");
        centerBuilder.append("K");
        for (i = 0; i < this.rDist; ++i) {
            borderBuilder.append("B");
            if (i == this.rDist - 1) {
                wallBuilder.append("B");
                insideBuilder.append("X");
                roofBuilder.append("B");
                controllerBuilder.append("B");
                centerBuilder.append("B");
                continue;
            }
            insideBuilder.append(" ");
            wallBuilder.append("X");
            roofBuilder.append("F");
            controllerBuilder.append("F");
            centerBuilder.append("X");
        }
        Object[] wall = new String[this.hDist + 1];
        Arrays.fill(wall, wallBuilder.toString());
        wall[0] = borderBuilder.toString();
        wall[wall.length - 1] = borderBuilder.toString();
        Object[] slice = new String[this.hDist + 1];
        Arrays.fill(slice, insideBuilder.toString());
        slice[0] = wallBuilder.toString();
        slice[slice.length - 1] = roofBuilder.toString();
        String[] center = (String[])Arrays.copyOf(slice, slice.length);
        if (this.getFrontFacing() == Direction.NORTH || this.getFrontFacing() == Direction.SOUTH) {
            center[0] = centerBuilder.reverse().toString();
            center[center.length - 1] = controllerBuilder.reverse().toString();
        } else {
            center[0] = centerBuilder.toString();
            center[center.length - 1] = controllerBuilder.toString();
        }
        TraceabilityPredicate wallPredicate = Predicates.states(this.getCasingState(), this.getGlassState());
        TraceabilityPredicate basePredicate = Predicates.autoAbilities(true, false, false).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3));
        return FactoryBlockPattern.start().aisle((String[])wall).aisle((String[])slice).setRepeatable(this.bDist - 1).aisle(center).aisle((String[])slice).setRepeatable(this.fDist - 1).aisle((String[])wall).where('S', Predicates.controller(Predicates.blocks(this.getDefinition().get()))).where('B', Predicates.states(this.getCasingState()).or(basePredicate)).where('X', wallPredicate.or(basePredicate).or(CleanroomMachine.doorPredicate().setMaxGlobalLimited(8)).or(Predicates.abilities(PartAbility.PASSTHROUGH_HATCH).setMaxGlobalLimited(30))).where('K', wallPredicate).where('F', Predicates.cleanroomFilters()).where(' ', this.innerPredicate()).build();
    }

    @Nonnull
    protected BlockState getCasingState() {
        return GTBlocks.PLASTCRETE.getDefaultState();
    }

    @Nonnull
    protected BlockState getGlassState() {
        return GTBlocks.CLEANROOM_GLASS.getDefaultState();
    }

    @Nonnull
    protected static TraceabilityPredicate doorPredicate() {
        return Predicates.custom(blockWorldState -> blockWorldState.getBlockState().m_60734_() instanceof DoorBlock, () -> new BlockInfo[]{new BlockInfo(Blocks.f_50166_.m_49966_()), new BlockInfo((BlockState)Blocks.f_50166_.m_49966_().m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER))});
    }

    @Nonnull
    protected TraceabilityPredicate innerPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            ICleanroomReceiver receiver;
            IMachineBlockEntity machineBlockEntity;
            MetaMachine machine;
            Set receivers = blockWorldState.getMatchContext().getOrCreate("cleanroomReceiver", Sets::newHashSet);
            BlockEntity blockEntity = blockWorldState.getTileEntity();
            if (blockEntity instanceof IMachineBlockEntity && this.isMachineBanned(machine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine())) {
                return false;
            }
            if (blockEntity != null && (receiver = GTCapabilityHelper.getCleanroomReceiver(blockWorldState.getWorld(), blockWorldState.getPos(), null)) != null) {
                receivers.add(receiver);
            }
            return true;
        }, null){

            @Override
            public boolean isAny() {
                return true;
            }

            @Override
            public boolean addCache() {
                return true;
            }
        };
    }

    protected boolean isMachineBanned(MetaMachine metaTileEntity) {
        if (metaTileEntity instanceof ICleanroomProvider) {
            return true;
        }
        if (metaTileEntity instanceof IMufflerMachine) {
            return true;
        }
        if (metaTileEntity instanceof SimpleGeneratorMachine) {
            return true;
        }
        if (metaTileEntity instanceof CokeOvenMachine) {
            return true;
        }
        if (metaTileEntity instanceof PrimitiveBlastFurnaceMachine) {
            return true;
        }
        return metaTileEntity instanceof PrimitivePumpMachine;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        if (this.isFormed()) {
            long maxVoltage = this.getMaxVoltage();
            if (maxVoltage > 0L) {
                String voltageName = GTValues.VNF[GTUtil.getFloorTierByVoltage(maxVoltage)];
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{maxVoltage, voltageName}));
            }
            if (this.cleanroomType != null) {
                textList.add((Component)Component.m_237115_((String)this.cleanroomType.getTranslationKey()));
            }
            if (!this.isWorkingEnabled()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.running"));
                int currentProgress = (int)(this.recipeLogic.getProgressPercent() * 100.0);
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.progress", (Object[])new Object[]{currentProgress}));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
            if (this.recipeLogic.isWaiting()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.waiting").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
            if (this.isClean()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.cleanroom.clean_state"));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.cleanroom.dirty_state"));
            }
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.cleanroom.clean_amount", (Object[])new Object[]{this.cleanAmount}));
        } else {
            MutableComponent tooltip = Component.m_237115_((String)"gtceu.multiblock.invalid_structure.tooltip").m_130940_(ChatFormatting.GRAY);
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.invalid_structure").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tooltip))));
        }
    }

    @Override
    public Set<CleanroomType> getTypes() {
        return this.cleanroomType == null ? Set.of() : Set.of(this.cleanroomType);
    }

    public void adjustCleanAmount(int amount) {
        this.cleanAmount = Mth.m_14045_((int)(this.cleanAmount + amount), (int)0, (int)100);
    }

    @Override
    public boolean isClean() {
        return this.cleanAmount >= 90;
    }

    @Nonnull
    public List<Component> getDataInfo() {
        return Collections.singletonList(Component.m_237115_((String)(this.isClean() ? "gtceu.multiblock.cleanroom.clean_state" : "gtceu.multiblock.cleanroom.dirty_state")));
    }

    @Override
    public long getMaxVoltage() {
        if (this.inputEnergyContainers == null) {
            return 1L;
        }
        return this.inputEnergyContainers.getInputVoltage();
    }

    @Nullable
    public EnergyContainerList getInputEnergyContainers() {
        return this.inputEnergyContainers;
    }

    @Nullable
    public Collection<ICleanroomReceiver> getCleanroomReceivers() {
        return this.cleanroomReceivers;
    }
}

